/*
 * Decompiled with CFR 0.152.
 */
package com.wily.debug;

import com.wily.util.properties.IndexedProperties;
import com.wily.utilities.properties.Messages;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.text.DateFormat;
import java.util.Date;

public class HeapLogger
extends Thread {
    public static final String kHeapLoggerPrefix = "Debug";
    public static final String kHeapLoggerSuffix = ".leakhunter.enable";
    public static final String kHeapLoggerIntervalInMillisSuffix = ".leakhunter.intervalInMillis";
    public static final String kHeapLoggerLogFilePathSuffix = ".leakhunter.logPath";
    private static final int kDefaultIntervalInMillis = 15000;
    private static final String kDefaultLogFilePath = "memusage.txt";
    private static final String kVerboseSystemProperty = "com.wily.memorylogger.verbose";
    private static final boolean kVerboseDefaultValue = false;
    private static final String kThreadName = "Memory Logger";
    private static final String kModulePrefix = "[MemoryLogger] ";
    private static final String kExceptionSeparator = ": ";
    private static final boolean kAppendToFile = true;
    private static final boolean kAutoflushStream = true;
    private Runtime fRuntime;
    private DateFormat fFormatter;
    private Date fDate;
    private PrintWriter fLogWriter;
    private long fIntervalInMillis;
    private boolean fIsVerbose;

    private static void info(String message) {
        HeapLogger.feedback(System.err, message);
    }

    private static void error(String message) {
        HeapLogger.feedback(System.err, message);
    }

    private static void error(String message, Throwable t) {
        HeapLogger.feedback(System.err, String.valueOf(message) + kExceptionSeparator + t);
        t.printStackTrace(System.err);
    }

    private static void feedback(PrintStream stream, String message) {
        stream.println(kModulePrefix + message);
    }

    public HeapLogger(IndexedProperties properties, String keyPrefix) throws IOException {
        super(kThreadName);
        String logPath = properties.getProperty(String.valueOf(keyPrefix) + kHeapLoggerLogFilePathSuffix, kDefaultLogFilePath);
        File logFile = new File(logPath);
        int interval = properties.getIntProperty(String.valueOf(keyPrefix) + kHeapLoggerIntervalInMillisSuffix, 15000);
        this.fIntervalInMillis = interval;
        this.fRuntime = Runtime.getRuntime();
        this.fFormatter = DateFormat.getDateTimeInstance(1, 1);
        this.fDate = new Date();
        this.fIntervalInMillis = properties.getIntProperty(String.valueOf(keyPrefix) + kHeapLoggerIntervalInMillisSuffix, 15000);
        this.fIsVerbose = HeapLogger.getBooleanSystemProperty(kVerboseSystemProperty, false);
        this.fLogWriter = this.openLog(logFile);
        this.writeMarker(System.currentTimeMillis(), Messages.getString("HeapLogger.MemoryTraceStartedMsg_Log"));
    }

    public void startLeakHunter() {
        this.start();
    }

    private static boolean getBooleanSystemProperty(String key, boolean defaultValue) {
        try {
            String value = System.getProperty(key);
            if (value != null) {
                return Boolean.valueOf(value);
            }
        }
        catch (NumberFormatException numberFormatException) {
            HeapLogger.error(Messages.getString("HeapLogger.InvalidPropertyValueMsg_Log", (Object)key, (Object)defaultValue));
        }
        return defaultValue;
    }

    private PrintWriter openLog(File logFile) throws IOException {
        return new PrintWriter(new FileOutputStream(logFile.getPath(), true), true);
    }

    private boolean isVerbose() {
        return this.fIsVerbose;
    }

    private long getBytesInUse() {
        long totalMem = this.fRuntime.totalMemory();
        long freeMem = this.fRuntime.freeMemory();
        return totalMem - freeMem;
    }

    private void recordMemoryUsage() {
        long time = System.currentTimeMillis();
        long value = this.getBytesInUse();
        this.writeMemoryUsage(time, value);
    }

    private synchronized String getDateString(long time) {
        this.fDate.setTime(time);
        String dateString = this.fFormatter.format(this.fDate);
        return dateString;
    }

    private void writeMarker(long time, String message) {
        this.fLogWriter.print(this.getDateString(time));
        this.fLogWriter.print("\t");
        this.fLogWriter.println(message);
    }

    private void writeMemoryUsage(long time, long value) {
        String dateString = this.getDateString(time);
        this.fLogWriter.print(dateString);
        this.fLogWriter.print("\t");
        this.fLogWriter.println(value);
        if (this.isVerbose()) {
            HeapLogger.info(String.valueOf(dateString) + Messages.getString("HeapLogger.MemoryUsageMsg_Log") + value);
        }
    }

    private void waitForNextInterval() {
        try {
            Thread.sleep(this.fIntervalInMillis);
        }
        catch (InterruptedException ie) {
            HeapLogger.error(Messages.getString("HeapLogger.MeasuringThreadInterruptedMsg_Log"), ie);
        }
    }

    public void run() {
        while (true) {
            try {
                while (true) {
                    this.recordMemoryUsage();
                    this.waitForNextInterval();
                }
            }
            catch (Throwable t) {
                HeapLogger.error(Messages.getString("HeapLogger.RecordMemoryUsageError_Log"), t);
                continue;
            }
            break;
        }
    }
}

