/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.introscope.agent.AgentShim;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;

public class AllocationStackTrace
extends Throwable {
    private static final long serialVersionUID = -640250297807767508L;
    private static final String kAgentPackagePrefix = "com.wily.introscope.agent";
    private static final String kThrowableClassName = "java.lang.Throwable";
    private static final String kUnknownMethodName = "<unknown>";
    private StackFrame[] fFrames;
    private String fStackTraceAsString;
    private String fAllocationMethod;
    static /* synthetic */ Class class$0;

    public String getStackTraceAsString() {
        if (this.fStackTraceAsString == null) {
            this.cacheContents();
        }
        return this.fStackTraceAsString;
    }

    public String getAllocationMethod() {
        if (this.fAllocationMethod == null) {
            this.cacheContents();
        }
        return this.fAllocationMethod;
    }

    public int hashCode() {
        return this.getStackTraceAsString().hashCode();
    }

    public boolean equals(Object obj) {
        Class<?> clazz = obj.getClass();
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.wily.introscope.agent.leakhunter.AllocationStackTrace");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz == clazz2) {
            AllocationStackTrace trace = (AllocationStackTrace)obj;
            return this.getStackTraceAsString().equals(trace.getStackTraceAsString());
        }
        return false;
    }

    private synchronized void cacheContents() {
        if (this.fStackTraceAsString == null) {
            this.fFrames = this.parseStackTrace();
            this.fStackTraceAsString = this.buildStackTraceString();
            this.fAllocationMethod = this.parseStackTraceForAllocationMethod();
        }
    }

    private boolean isHiddenClass(String className) {
        return className.equals(kThrowableClassName) || className.startsWith(kAgentPackagePrefix);
    }

    private String buildStackTraceString() {
        boolean firstFrame = true;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.fFrames.length) {
            String className = this.fFrames[i].getClassName();
            if (className == null || !this.isHiddenClass(className)) {
                if (!firstFrame) {
                    buffer.append("\n");
                }
                buffer.append(this.fFrames[i].getLine());
                firstFrame = false;
            }
            ++i;
        }
        return buffer.toString();
    }

    private String parseStackTraceForAllocationMethod() {
        int i = 0;
        while (i < this.fFrames.length) {
            String className = this.fFrames[i].getClassName();
            if (className != null && !this.isHiddenClass(className)) {
                return this.fFrames[i].getMethodName();
            }
            ++i;
        }
        return kUnknownMethodName;
    }

    String convertStackTraceToString() {
        StringWriter writer = new StringWriter();
        this.printStackTrace(new PrintWriter(writer));
        return writer.toString();
    }

    private StackFrame[] parseStackTrace() {
        LineNumberReader reader = new LineNumberReader(new StringReader(this.convertStackTraceToString()));
        ArrayList<StackFrame> frames = new ArrayList<StackFrame>(20);
        try {
            String line = reader.readLine();
            if (line != null) {
                while ((line = reader.readLine()) != null) {
                    frames.add(new StackFrame(line));
                }
            }
        }
        catch (IOException ioe) {
            AgentShim.handleError((String)"Error occurred while parsing allocation stack trace", (Throwable)ioe);
        }
        StackFrame[] stackFrames = new StackFrame[frames.size()];
        frames.toArray(stackFrames);
        return stackFrames;
    }

    private static final class StackFrame {
        private final String fLine;
        private boolean fIsParsed;
        private String fClassName;
        private String fMethodName;
        private String fSourceFile;
        private int fLineNumber;

        public StackFrame(String line) {
            this.fLine = line;
            this.fIsParsed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void parseIfNecessary() {
            if (!this.fIsParsed) {
                StackFrame stackFrame = this;
                synchronized (stackFrame) {
                    if (!this.fIsParsed) {
                        this.parse();
                    }
                }
            }
        }

        public String getLine() {
            return this.fLine;
        }

        public String getClassName() {
            this.parseIfNecessary();
            return this.fClassName;
        }

        public String getMethodName() {
            this.parseIfNecessary();
            return this.fMethodName;
        }

        public String getSourceFile() {
            this.parseIfNecessary();
            return this.fSourceFile;
        }

        public int getLineNumber() {
            this.parseIfNecessary();
            return this.fLineNumber;
        }

        private void parse() {
            int colonIndex;
            int methodSeparatorIndex;
            this.fIsParsed = true;
            String line = this.fLine.trim();
            if (line.startsWith("at")) {
                line = line.substring(2);
            }
            line = line.trim();
            String source = "";
            int index = line.indexOf(40);
            int lastIndex = line.indexOf(41);
            if (index != -1 && lastIndex != -1 && lastIndex > index) {
                source = line.substring(index + 1, lastIndex);
                line = line.substring(0, index);
            }
            if ((methodSeparatorIndex = line.lastIndexOf(46)) != -1) {
                this.fClassName = line.substring(0, methodSeparatorIndex);
                this.fMethodName = line.substring(methodSeparatorIndex + 1);
            }
            if ((colonIndex = source.indexOf(":")) != -1) {
                String lineNumberString = source.substring(colonIndex + 1);
                source = source.substring(0, colonIndex);
                try {
                    this.fLineNumber = Integer.parseInt(lineNumberString);
                }
                catch (NumberFormatException numberFormatException) {}
            }
            this.fSourceFile = source;
        }
    }
}

