/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.leakhunter;

import com.wily.util.Glob;
import java.util.ArrayList;
import java.util.HashMap;

public class BadCollectionFilter {
    public static final String kWeakHashMapBannedGlob = "java.util.WeakHashMap*";
    private Glob[] fGlobs;
    private final HashMap fCache = new HashMap(1009);

    public BadCollectionFilter(String[] filters) {
        ArrayList<Glob> globs = new ArrayList<Glob>();
        globs.add(new Glob(kWeakHashMapBannedGlob));
        int i = 0;
        while (i < filters.length) {
            if (filters[i].length() != 0) {
                globs.add(new Glob(filters[i]));
            }
            ++i;
        }
        this.fGlobs = globs.toArray(new Glob[globs.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOK(String className) {
        Boolean b = (Boolean)this.fCache.get(className);
        if (b == null) {
            HashMap hashMap = this.fCache;
            synchronized (hashMap) {
                b = (Boolean)this.fCache.get(className);
                if (b == null) {
                    b = this.computeIsOK(className) ? Boolean.TRUE : Boolean.FALSE;
                    this.fCache.put(className, b);
                }
            }
        }
        return b;
    }

    private boolean computeIsOK(String className) {
        int i = 0;
        while (i < this.fGlobs.length) {
            if (this.fGlobs[i].matches(className)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void ignoreClassOfName(String className) {
        Glob[] newGlobs = new Glob[this.fGlobs.length + 1];
        System.arraycopy(this.fGlobs, 0, newGlobs, 0, this.fGlobs.length);
        newGlobs[this.fGlobs.length] = new Glob(className);
        this.fGlobs = newGlobs;
    }
}

