/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.feedback;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.backend.NativeFeedbackBackend;
import com.wily.wilyassert.Assertion;

public abstract class ADefaultModuleFeedbackChannel
implements IModuleFeedbackChannel {
    private String fApplicationName;
    private Module fModule;
    private String fCategory;
    private String fDynamicModule;
    private Object fLogger;
    private final Lock fLock = new Lock();

    static {
        System.setProperty("com.wily.log4j.defaultInitOverride", Boolean.TRUE.toString());
    }

    protected ADefaultModuleFeedbackChannel(String applicationName) {
        this.initializeChannel(applicationName, null);
        this.calculateLogger();
    }

    protected ADefaultModuleFeedbackChannel(String applicationName, String moduleName) {
        this.initializeChannel(applicationName, moduleName);
        this.calculateLogger();
    }

    protected ADefaultModuleFeedbackChannel(IModuleFeedbackChannel original, String moduleName) {
        this.initializeChannel(original.getApplicationName(), moduleName);
        this.calculateLogger();
    }

    private void initializeChannel(String applicationName, String moduleName) {
        this.setApplicationName(applicationName);
        this.setModuleName(moduleName);
    }

    public void setApplicationName(String applicationName) {
        Assertion.wilyAssert(false);
        this.fApplicationName = applicationName;
    }

    private void setModuleName(String moduleName) {
        this.fDynamicModule = moduleName;
    }

    public SeverityLevel getEffectiveLevel(Module module) {
        Object actualLogger = this.getActualLogger(module);
        return NativeFeedbackBackend.getNativeFeedbackBackend().getEffectiveLevel(actualLogger);
    }

    public SeverityLevel getLevel(Module module) {
        Object actualLogger = this.getActualLogger(module);
        return NativeFeedbackBackend.getNativeFeedbackBackend().getLevel(actualLogger);
    }

    public void setLevel(SeverityLevel level, Module module) {
        Object actualLogger = this.getActualLogger(module);
        NativeFeedbackBackend.getNativeFeedbackBackend().setLevel(actualLogger, level);
    }

    protected final Object getFeedbackChannelLock() {
        return this.fLock;
    }

    private void calculateLogger() {
        String category = this.getCategory();
        Assertion.wilyAssert(false);
        if (category != null) {
            this.fModule = this.fDynamicModule != null ? new Module(this.fDynamicModule) : new Module(category);
            this.fLogger = NativeFeedbackBackend.getNativeFeedbackBackend().getLoggerByName(category);
        } else {
            this.fLogger = NativeFeedbackBackend.getNativeFeedbackBackend().getLoggerByName("default");
        }
    }

    private String getCategory() {
        if (this.fCategory == null) {
            String category = this.getApplicationName();
            String module = this.getModuleName();
            this.fCategory = module != null ? (category != null ? (category.equals(module) ? category : String.valueOf(category) + "." + module) : module) : category;
            if (this.fCategory != null) {
                this.fCategory = LocalStringUtils.replace(this.fCategory, " ", "");
            }
        }
        return this.fCategory;
    }

    protected Object getActualLogger(Module module) {
        Object logger = null;
        if (this.getModuleName() != null) {
            logger = this.fLogger;
        } else {
            String fullname = null;
            fullname = this.getCategory().equals(module.getName()) ? module.getName() : String.valueOf(this.getCategory()) + "." + module.getName();
            logger = NativeFeedbackBackend.getNativeFeedbackBackend().getLoggerByName(fullname);
        }
        return logger;
    }

    public final String getApplicationName() {
        return this.fApplicationName;
    }

    public final String getModuleName() {
        return this.fDynamicModule;
    }

    public boolean isVerboseEnabled() {
        return this.isLogEnabled(SeverityLevel.VERBOSE, this.fModule);
    }

    public final boolean isDebugEnabled() {
        return this.isLogEnabled(SeverityLevel.DEBUG, this.fModule);
    }

    public final boolean isTraceEnabled() {
        return this.isLogEnabled(SeverityLevel.TRACE, this.fModule);
    }

    public SeverityLevel getLevel() {
        return NativeFeedbackBackend.getNativeFeedbackBackend().getLevel(this.fLogger);
    }

    public void setLevel(SeverityLevel level) {
        NativeFeedbackBackend.getNativeFeedbackBackend().setLevel(this.fLogger, level);
    }

    public final boolean isErrorEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.ERROR, module);
    }

    public final boolean isWarningEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.WARN, module);
    }

    public final boolean isInfoEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.INFO, module);
    }

    public final boolean isVerboseEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.VERBOSE, module);
    }

    public final boolean isDebugEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.DEBUG, module);
    }

    public final boolean isTraceEnabled(Module module) {
        return this.isLogEnabled(SeverityLevel.TRACE, module);
    }

    public boolean isLogEnabled(SeverityLevel severity, Module module) {
        Object actualLogger = this.getActualLogger(module);
        return NativeFeedbackBackend.getNativeFeedbackBackend().isEnabledFor(actualLogger, severity);
    }

    public final void error(String message) {
        this.log(SeverityLevel.ERROR, this.fModule, message);
    }

    public final void error(String message, Throwable t) {
        this.log(SeverityLevel.ERROR, this.fModule, message, t);
    }

    public final void warn(String message) {
        this.log(SeverityLevel.WARN, this.fModule, message);
    }

    public final void warn(String message, Throwable t) {
        this.log(SeverityLevel.WARN, this.fModule, message, t);
    }

    public final void info(String message) {
        this.log(SeverityLevel.INFO, this.fModule, message);
    }

    public final void info(String message, Throwable t) {
        this.log(SeverityLevel.INFO, this.fModule, message, t);
    }

    public final void verbose(String message) {
        this.log(SeverityLevel.VERBOSE, this.fModule, message);
    }

    public final void verbose(String message, Throwable t) {
        this.log(SeverityLevel.VERBOSE, this.fModule, message, t);
    }

    public final void debug(String message) {
        this.log(SeverityLevel.DEBUG, this.fModule, message);
    }

    public final void debug(String message, Throwable t) {
        this.log(SeverityLevel.DEBUG, this.fModule, message, t);
    }

    public final void log(SeverityLevel severity, String message) {
        this.log(severity, this.fModule, message);
    }

    public final void log(SeverityLevel severity, String message, Throwable t) {
        this.log(severity, this.fModule, message, t);
    }

    public final void error(Throwable t) {
        this.log(SeverityLevel.ERROR, this.fModule, null, t);
    }

    public final void verbose(Throwable t) {
        this.log(SeverityLevel.VERBOSE, this.fModule, null, t);
    }

    public final void debug(Throwable t) {
        this.log(SeverityLevel.DEBUG, this.fModule, null, t);
    }

    public final void error(Module module, String message) {
        this.log(SeverityLevel.ERROR, module, message);
    }

    public final void error(Module module, String message, Throwable t) {
        this.log(SeverityLevel.ERROR, module, message, t);
    }

    public final void warn(Module module, String message) {
        this.log(SeverityLevel.WARN, module, message);
    }

    public final void warn(Module module, String message, Throwable t) {
        this.log(SeverityLevel.WARN, module, message, t);
    }

    public final void info(Module module, String message) {
        this.log(SeverityLevel.INFO, module, message);
    }

    public final void info(Module module, String message, Throwable t) {
        this.log(SeverityLevel.INFO, module, message, t);
    }

    public final void verbose(Module module, String message) {
        this.log(SeverityLevel.VERBOSE, module, message);
    }

    public final void verbose(Module module, String message, Throwable t) {
        this.log(SeverityLevel.VERBOSE, module, message, t);
    }

    public final void debug(Module module, String message) {
        this.log(SeverityLevel.DEBUG, module, message);
    }

    public final void debug(Module module, String message, Throwable t) {
        this.log(SeverityLevel.DEBUG, module, message, t);
    }

    public final void trace(String message) {
        this.log(SeverityLevel.TRACE, this.fModule, message);
    }

    public final void trace(Module module, String message) {
        this.log(SeverityLevel.TRACE, module, message);
    }

    public final void trace(Module module, String message, Throwable t) {
        this.log(SeverityLevel.TRACE, module, message, t);
    }

    public final void log(SeverityLevel severity, Module module, String message) {
        this.log(severity, module, message, null);
    }

    public final void log(SeverityLevel severity, Module module, String message, Throwable t) {
        this.logbottleneck(severity, module, message, t);
    }

    public final void logImmediate(SeverityLevel severity, Module module, String message) {
        this.logImmediate(severity, module, message, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void logImmediate(SeverityLevel severity, Module module, String message, Throwable t) {
        if (this.isLogEnabled(severity, module)) {
            Object object = this.getFeedbackChannelLock();
            synchronized (object) {
                this.doLog(severity, module, message, t, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logbottleneck(SeverityLevel severity, Module module, String message, Throwable t) {
        if (this.isLogEnabled(severity, module)) {
            Object object = this.getFeedbackChannelLock();
            synchronized (object) {
                this.doLog(severity, module, message, t, false);
            }
        }
    }

    protected void doLog(SeverityLevel severity, Module module, String message, Throwable t, boolean forceImmediate) {
        if (message == null) {
            message = "\n";
        }
        Object actualLogger = this.getActualLogger(module);
        NativeFeedbackBackend.getNativeFeedbackBackend().log(actualLogger, severity, message, t);
    }

    final String debug_getLog4JCategory() {
        return NativeFeedbackBackend.getNativeFeedbackBackend().getName(this.fLogger);
    }

    private static class LocalStringUtils {
        private LocalStringUtils() {
        }

        public static boolean isEmpty(String string) {
            if (string == null) {
                return true;
            }
            int length = string.length();
            int i = 0;
            while (i < length) {
                if (!Character.isWhitespace(string.charAt(i))) {
                    return false;
                }
                ++i;
            }
            return true;
        }

        public static String replace(String original, String source, String dest) {
            int end;
            StringBuffer buffer = new StringBuffer(original.length() + dest.length());
            if (source.length() == 0) {
                return original;
            }
            int start = 0;
            while ((end = original.indexOf(source, start)) >= 0) {
                buffer.append(original.substring(start, end));
                buffer.append(dest);
                start = end + source.length();
            }
            buffer.append(original.substring(start));
            return buffer.toString();
        }
    }

    private static class Lock {
        private Lock() {
        }
    }
}

