/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.wrapper;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.brtm.utilities.ResponseDecorationUtils;
import com.wily.introscope.agent.brtm.wrapper.BrtmWrapperFactory;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;

public abstract class BRTHttpServletResponseWrapperBase
extends HttpServletResponseWrapper {
    private static final Module BRTM_MODULE = new Module("BrowserAgent");
    protected static final String CLASSNAME_WEBLOGIC_RESPONSEIMPL = "weblogic.servlet.internal.ServletResponseImpl";
    protected static final String CLASSNAME_WEBSPHERE_RESPONSEIMPL = "com.ibm.ws.webcontainer.srt.SRTServletResponse";
    protected static final String CLASSNAME_WEBLOGICPORTAL_SCOPEDRESPONSE = "com.bea.wlw.netui.pageflow.scoping.internal.ScopedResponseImpl";
    protected static final String HTTPHEADER_CONTENTENCODING = "content-encoding";
    protected static final String HTTPHEADER_CONTENTTYPE = "Content-Type";
    protected static final String HTTPHEADER_CONTENTLENGTH = "Content-Length";
    protected static final String HTTPHEADTAG = "<head";
    protected static final String HTTPHEADTAG_START = "<head>";
    protected static final String HTTPHEADTAG_END = "</head>";
    protected static final String HTTPBODYTAG = "<body";
    static long g_javaScriptTemplateFileLastFetched;
    static int g_brtPingFrequencyCounter;
    protected HttpServletResponse m_outer;
    protected BRTPrintWriterWrapper m_innerPrintWriter;
    protected BRTOutputStream m_innerOutputStream;
    protected Long m_contentLength;
    protected Integer m_contentLengthInteger;
    protected Long m_contentLengthLong;
    protected String m_contentType;
    protected String m_contentEncoding;
    protected String m_originalContentEncoding;
    protected boolean m_javaScriptWritten;
    protected boolean m_weblogicMagic;
    protected boolean m_websphereMagic;
    protected boolean m_weblogicPortalMagic;
    protected boolean m_bIsClosedAll;
    protected boolean m_bAllowGetResponse;
    protected String contentType;
    private Boolean shouldExecute;
    private StringBuffer stringBuffer;
    private long offset;
    private long m_snippetLength;
    private long m_maxResponseContentLengthForSearching;
    private String m_url;
    private Boolean m_setContentLength;
    private Boolean m_updateContentLength;
    private String insertedSnippetSource;
    static volatile Method setContentLengthLongMethod;
    IAgent agent;
    public static final String wrapperName = "BRTServletResponseWrapperBase";
    private static IModuleFeedbackChannel feedback;
    static final int SIZEOF_BOOLEAN = 2;
    static final int SIZEOF_CHAR = 2;
    static final int SIZEOF_DOUBLE = 8;
    static final int SIZEOF_LONG = 4;
    static final int SIZEOF_FLOAT = 8;
    static final int SIZEOF_INT = 4;
    static final int SIZEOF_CRLF = 2;

    static {
        g_brtPingFrequencyCounter = 0;
        setContentLengthLongMethod = null;
    }

    public abstract String getWrapperName();

    public BRTHttpServletResponseWrapperBase(HttpServletResponse outer, String url, long maxResponseContentLengthForSearching) {
        block8: {
            super(outer);
            this.m_bIsClosedAll = false;
            this.m_bAllowGetResponse = true;
            this.offset = 0L;
            this.m_snippetLength = 0L;
            this.m_maxResponseContentLengthForSearching = 1000L;
            this.m_url = null;
            this.m_setContentLength = false;
            this.m_updateContentLength = false;
            feedback = new DelegatingFeedbackChannel(AgentShim.getAgentShim().IAgentShim_getModuleFeedback(), BRTM_MODULE);
            this.m_originalContentEncoding = outer.getCharacterEncoding();
            this.m_outer = outer;
            this.m_maxResponseContentLengthForSearching = maxResponseContentLengthForSearching;
            this.m_url = url;
            String outerClassName = outer.getClass().getName();
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...constructor. outer type:" + outerClassName + ", url = " + this.m_url);
            }
            if (outerClassName.equals(CLASSNAME_WEBSPHERE_RESPONSEIMPL)) {
                this.m_websphereMagic = true;
            } else if (outerClassName.equals(CLASSNAME_WEBLOGICPORTAL_SCOPEDRESPONSE)) {
                this.m_weblogicPortalMagic = true;
            } else if (outerClassName.equals(CLASSNAME_WEBLOGIC_RESPONSEIMPL)) {
                this.m_weblogicMagic = true;
            }
            try {
                this.agent = AgentShim.getAgent();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                if (!feedback.isDebugEnabled()) break block8;
                feedback.debug(BRTM_MODULE, "AgentNotAvailable");
            }
        }
    }

    public boolean getAllowGetResponse() {
        return this.m_bAllowGetResponse;
    }

    public void flushBufferStream() throws IOException {
        if (this.m_innerOutputStream != null) {
            this.m_innerOutputStream.flush();
        }
    }

    public ServletOutputStream getOutputStream() throws IOException {
        try {
            if (!this.m_bIsClosedAll) {
                this.m_innerOutputStream = new BRTOutputStream(super.getOutputStream(), this.m_bIsClosedAll, this);
                this.insertCookieAndHeader();
                return this.m_innerOutputStream;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "getOutputStream: ", t);
            }
            return super.getOutputStream();
        }
        return this.m_innerOutputStream;
    }

    public PrintWriter getWriter() throws IOException {
        try {
            if (!this.m_bIsClosedAll) {
                this.m_innerPrintWriter = this.createPrintWriterWrapper(super.getWriter(), this.m_bIsClosedAll, this);
                this.insertCookieAndHeader();
                return this.m_innerPrintWriter;
            }
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "getWriter: throwable");
            }
            return super.getWriter();
        }
        return super.getWriter();
    }

    protected BRTPrintWriterWrapper createPrintWriterWrapper(PrintWriter writer, boolean isClosed, BRTHttpServletResponseWrapperBase wrapper) {
        return new BRTPrintWriterWrapper(writer, this.m_bIsClosedAll, this);
    }

    public void setStatus(int sc) {
        this.insertCookieAndHeader();
        super.setStatus(sc);
    }

    public void sendError(int sc) throws IOException {
        try {
            this.insertCookieAndHeader();
            super.sendError(sc);
        }
        catch (IOException iOException) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "sendError: throwable");
            }
            super.sendError(sc);
        }
    }

    public void sendError(int sc, String msg) throws IOException {
        try {
            this.insertCookieAndHeader();
            super.sendError(sc, msg);
        }
        catch (IOException iOException) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "sendError: throwable");
            }
            super.sendError(sc, msg);
        }
    }

    public void setContentLengthLong(long length) {
        this.m_setContentLength = true;
        this.m_contentLengthLong = new Long(length);
        this.m_contentLength = new Long(length);
        if (this.stringBuffer == null) {
            this.stringBuffer = new StringBuffer();
        }
        if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...call method: setContentLengthLong =" + length + ", url = " + this.m_url);
        }
    }

    public void setContentLength(int len) {
        this.m_setContentLength = true;
        this.m_contentLength = new Long(len);
        this.m_contentLengthInteger = new Integer(len);
        if (this.stringBuffer == null) {
            this.stringBuffer = new StringBuffer();
        }
        if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...call method: setContentLength =" + len + ", url = " + this.m_url);
        }
    }

    public void setHeader(String name, String value) {
        if (name != null) {
            if (HTTPHEADER_CONTENTENCODING.equalsIgnoreCase(name)) {
                this.m_contentEncoding = value;
                if (feedback.isTraceEnabled()) {
                    feedback.trace(BRTM_MODULE, "...call method: setHeader_contentEncoding =" + value + ", url = " + this.m_url);
                }
            }
            if (HTTPHEADER_CONTENTTYPE.equalsIgnoreCase(name)) {
                this.m_contentType = value;
            }
        }
        super.setHeader(name, value);
    }

    public void setContentType(String type) {
        try {
            this.m_contentType = type;
            if (this.m_weblogicMagic && type.indexOf("Shift_JIS") > -1) {
                String newtype;
                int index = type.indexOf("Shift_JIS");
                type = newtype = String.valueOf(type.substring(0, index)) + "Windows-31J" + type.substring(index + 9);
            }
            super.setContentType(type);
            this.insertCookieAndHeader();
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "setContentType: throwable");
            }
            super.setContentType(type);
        }
    }

    public boolean containsHeader(String name) {
        try {
            return super.containsHeader(name);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable throwable) {
            if (feedback.isDebugEnabled()) {
                feedback.debug(BRTM_MODULE, "containsHeader: throwable");
            }
            return super.containsHeader(name);
        }
    }

    public ServletResponse getResponse() {
        if (this.m_websphereMagic && !this.m_bAllowGetResponse) {
            return null;
        }
        return super.getResponse();
    }

    public void setAllowGetResponse(Boolean value) {
        this.m_bAllowGetResponse = value;
    }

    public String getJavaScriptSnippet(String content, String lowerCaseContent) throws IOException {
        if (BrtmWrapperFactory.getJSSnippet() != null) {
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...get snippet.js ready for response object, url = " + this.m_url);
            }
            return BrtmWrapperFactory.getJSSnippet();
        }
        return "";
    }

    public int getTagOccurrence(String content, String lowerCaseContent, String tag) {
        int bodyIndex = -1;
        if (content != null) {
            if (lowerCaseContent == null) {
                lowerCaseContent = content.toLowerCase();
            }
            bodyIndex = lowerCaseContent.indexOf(tag);
        }
        return bodyIndex;
    }

    private boolean isValidTag(String lowerCaseContent, String tag) {
        String[] excludeList;
        boolean result = true;
        String[] tagArr = lowerCaseContent.split(tag);
        if (tagArr != null && (excludeList = BrtmWrapperFactory.getJSExcludePatternList()) != null) {
            int i = 0;
            while (i < excludeList.length) {
                if (tagArr[0].indexOf(excludeList[i]) >= 0) {
                    result = false;
                    break;
                }
                ++i;
            }
        }
        return result;
    }

    public void reallyClose() throws IOException {
        if (!this.m_javaScriptWritten && this.m_contentLength != null && !this.m_outer.isCommitted()) {
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...setting content length: " + this.m_contentLength);
            }
            this.updateContentLength();
        } else if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...setting content length: " + (this.m_contentLength == null ? "null" : this.m_contentLength.toString()));
        }
        if (this.m_innerPrintWriter != null) {
            this.m_innerPrintWriter.reallyClose();
        }
        if (this.m_innerOutputStream != null) {
            this.m_innerOutputStream.reallyClose();
        }
        this.m_innerPrintWriter = null;
        this.m_innerOutputStream = null;
    }

    public void forwardedClose() {
        if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...forwardedClose, url = " + this.m_url);
        }
        this.m_bIsClosedAll = true;
        if (this.m_innerPrintWriter != null) {
            this.m_innerPrintWriter.m_bIsClosed = true;
        }
        if (this.m_innerOutputStream != null) {
            this.m_innerOutputStream.m_bIsClosed = true;
        }
    }

    public Boolean getShouldExecute() {
        if (this.shouldExecute == null) {
            this.shouldExecute = this.shouldWriteJavaScript();
        }
        return this.shouldExecute;
    }

    private boolean shouldWriteJavaScript() {
        boolean hopelessEncoding;
        boolean contentTypeIncludesTextHtml = this.m_contentType != null && this.m_contentType.indexOf("text/html") == 0;
        boolean outputGenerated = this.m_innerPrintWriter != null || this.m_innerOutputStream != null;
        boolean bl = hopelessEncoding = this.m_contentEncoding != null && this.m_contentEncoding.length() > 0;
        if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...shouldWriteJavaScript contentTypeIncludesTextHtml: " + contentTypeIncludesTextHtml + "(" + (this.m_contentType != null ? this.m_contentType : "null") + ")" + ", url = " + this.m_url);
            feedback.trace(BRTM_MODULE, "...shouldWriteJavaScript outputGenerated: " + outputGenerated + ", url = " + this.m_url);
            feedback.trace(BRTM_MODULE, "...shouldWriteJavaScript m_weblogicPortalMagic: " + this.m_weblogicPortalMagic + ", url = " + this.m_url);
            feedback.trace(BRTM_MODULE, "...shouldWriteJavaScript m_contentEncoding: " + this.m_contentEncoding + ", url = " + this.m_url);
        }
        this.shouldExecute = contentTypeIncludesTextHtml && outputGenerated && !this.m_weblogicPortalMagic && !hopelessEncoding;
        if (feedback.isTraceEnabled()) {
            feedback.trace(BRTM_MODULE, "...shouldWriteJavaScript returns: " + this.shouldExecute + ", url = " + this.m_url);
        }
        return this.shouldExecute;
    }

    static void loadJavaScriptTemplate(File javaScriptTemplateFile) throws FileNotFoundException, IOException {
        String line;
        BufferedReader input = new BufferedReader(new FileReader(javaScriptTemplateFile));
        StringBuffer buf = new StringBuffer();
        while ((line = input.readLine()) != null) {
            buf.append(line);
            buf.append('\n');
        }
        g_javaScriptTemplateFileLastFetched = javaScriptTemplateFile.lastModified();
    }

    private void appendStringBuffer(int off, int len, char ... chars) {
        this.stringBuffer.append(chars, off, len);
    }

    private void appendByteBuffer(int off, int len, byte ... b) throws IOException {
        byte[] subsetArr = this.getSubsetArray(b, off, len);
        String content = new String(subsetArr, this.m_outer.getCharacterEncoding());
        this.stringBuffer.append(content);
    }

    private void appendStringBuffer(char ... chars) {
        this.stringBuffer.append(chars);
    }

    private void appendStringBuffer(String str) {
        this.stringBuffer.append(str);
    }

    private void appendStringBufferLn(String str) {
        this.stringBuffer.append(str);
        this.stringBuffer.append('\n');
    }

    private void appendStringBufferLn(char ... chars) {
        this.stringBuffer.append(chars);
        this.stringBuffer.append('\n');
    }

    public byte[] getSubsetArray(byte[] b, int off, int len) {
        if (b.length == len) {
            return b;
        }
        byte[] arr = new byte[len];
        int j = 0;
        int i = off;
        while (i < off + len) {
            arr[j] = b[i];
            ++i;
            ++j;
        }
        return arr;
    }

    public String getSubString(int off, int len, char ... chars) {
        return new StringBuffer().append(chars, off, len).toString();
    }

    public String getSubString(char ... chars) {
        return new StringBuffer().append(chars).toString();
    }

    private byte[] searchAndGetModifiedContent(byte[] bytes) throws IOException {
        if (!this.m_javaScriptWritten) {
            String lowerCaseContent;
            String content = new String(bytes, this.m_outer.getCharacterEncoding());
            if (this.getTagOccurrence(content, lowerCaseContent = content.toLowerCase(), HTTPHEADTAG) >= 0 || this.getTagOccurrence(content, lowerCaseContent, HTTPBODYTAG) >= 0) {
                String modifiedContent = this.getModifiedContent(content, lowerCaseContent, this.getJavaScriptSnippet(content, lowerCaseContent));
                byte[] bytesModified = modifiedContent.getBytes(this.m_outer.getCharacterEncoding());
                if (this.m_javaScriptWritten && this.insertedSnippetSource != null) {
                    this.m_snippetLength = this.insertedSnippetSource.getBytes(this.m_outer.getCharacterEncoding()).length;
                }
                return bytesModified;
            }
            return bytes;
        }
        return bytes;
    }

    private byte[] searchAndGetModifiedContent(StringBuffer buffer) throws IOException {
        String content = buffer.toString();
        if (!this.m_javaScriptWritten) {
            String lowerCaseContent = content.toLowerCase();
            if (this.getTagOccurrence(content, lowerCaseContent, HTTPHEADTAG) >= 0 || this.getTagOccurrence(content, lowerCaseContent, HTTPBODYTAG) >= 0) {
                String modifiedContent = this.getModifiedContent(content, lowerCaseContent, this.getJavaScriptSnippet(content, lowerCaseContent));
                byte[] bytesModified = modifiedContent.getBytes(this.m_outer.getCharacterEncoding());
                if (this.m_javaScriptWritten && this.insertedSnippetSource != null) {
                    this.m_snippetLength = this.insertedSnippetSource.getBytes(this.m_outer.getCharacterEncoding()).length;
                }
                return bytesModified;
            }
            return content.getBytes(this.m_outer.getCharacterEncoding());
        }
        return content.getBytes(this.m_outer.getCharacterEncoding());
    }

    private String searchAndGetModifiedContent(String content) throws IOException {
        if (!this.m_javaScriptWritten) {
            String lowerCaseContent = content.toLowerCase();
            if (this.getTagOccurrence(content, lowerCaseContent, HTTPHEADTAG) >= 0 || this.getTagOccurrence(content, lowerCaseContent, HTTPBODYTAG) >= 0) {
                String modifiedContent = this.getModifiedContent(content, lowerCaseContent, this.getJavaScriptSnippet(content, lowerCaseContent));
                if (this.m_javaScriptWritten && this.insertedSnippetSource != null) {
                    this.m_snippetLength = this.insertedSnippetSource.length();
                }
                return modifiedContent;
            }
            return content;
        }
        return content;
    }

    private void writeByteBuffer(byte[] bytes) throws IOException {
        if (bytes != null) {
            WritableByteChannel writableByteChannel = Channels.newChannel((OutputStream)this.m_outer.getOutputStream());
            ByteBuffer buffer = ByteBuffer.allocateDirect(bytes.length);
            buffer.put(bytes);
            buffer.flip();
            writableByteChannel.write(buffer);
            buffer.clear();
            writableByteChannel.close();
        }
    }

    private void writeCharBuffer(String str) throws IOException {
        if (str != null) {
            byte[] bytes = str.getBytes(this.m_outer.getCharacterEncoding());
            WritableByteChannel writableByteChannel = Channels.newChannel((OutputStream)this.m_outer.getOutputStream());
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bytes.length);
            byteBuffer.put(bytes);
            byteBuffer.flip();
            writableByteChannel.write(byteBuffer);
            byteBuffer.clear();
            writableByteChannel.close();
        }
    }

    private void writeWriterCharBuffer(String str) throws IOException {
        if (str != null) {
            byte[] bytes = str.getBytes(this.m_outer.getCharacterEncoding());
            ByteBuffer byteBuffer = ByteBuffer.allocateDirect(bytes.length);
            WriterOutputStream writerOutputStream = new WriterOutputStream(this.m_outer.getCharacterEncoding(), this.m_outer.getWriter());
            WritableByteChannel writableByteChannel = Channels.newChannel(writerOutputStream);
            byteBuffer.put(bytes);
            byteBuffer.flip();
            writableByteChannel.write(byteBuffer);
            byteBuffer.clear();
            writableByteChannel.close();
            writerOutputStream.close();
        }
    }

    private void insertCookieAndHeader() {
        if (!this.m_outer.isCommitted()) {
            ResponseDecorationUtils.createCookiesAndHeader(this.agent, feedback, this.m_outer);
        }
    }

    public void updateContentLength() {
        if (this.m_updateContentLength.booleanValue()) {
            return;
        }
        this.m_updateContentLength = true;
        if (this.m_setContentLength.booleanValue()) {
            if (this.m_contentLengthLong != null) {
                this.updateContentLengthLong();
                return;
            }
            if (this.m_contentLengthInteger != null) {
                super.setContentLength(this.m_javaScriptWritten ? this.m_contentLengthInteger + (int)this.m_snippetLength : this.m_contentLengthInteger);
                return;
            }
        }
    }

    private void updateContentLengthLong() {
        Long contentLengthWithSnippet = this.m_contentLengthLong + this.m_snippetLength;
        if (this.m_javaScriptWritten) {
            if (contentLengthWithSnippet < Integer.MAX_VALUE) {
                super.setContentLength(contentLengthWithSnippet.intValue());
            } else {
                this.reflectionCallSetContentLengthLong(contentLengthWithSnippet);
            }
        } else if (this.m_contentLengthLong < Integer.MAX_VALUE) {
            super.setContentLength(this.m_contentLengthLong.intValue());
        } else {
            this.reflectionCallSetContentLengthLong(this.m_contentLengthLong);
        }
    }

    private void reflectionCallSetContentLengthLong(Long contentLengthWithSnippet) {
        block11: {
            try {
                if (setContentLengthLongMethod == null) {
                    Class[] paramLong = new Class[]{Long.TYPE};
                    setContentLengthLongMethod = this.m_outer.getClass().getDeclaredMethod("setContentLengthLong", paramLong);
                }
                setContentLengthLongMethod.setAccessible(true);
                setContentLengthLongMethod.invoke((Object)this.m_outer, contentLengthWithSnippet);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, "reflectionCallSetContentLengthLong: NoSuchMethodException throwable");
                }
            }
            catch (SecurityException securityException) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, "reflectionCallSetContentLengthLong: SecurityException throwable");
                }
            }
            catch (IllegalAccessException illegalAccessException) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, "reflectionCallSetContentLengthLong: IllegalAccessException throwable");
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, "reflectionCallSetContentLengthLong: IllegalArgumentException throwable");
                }
            }
            catch (InvocationTargetException invocationTargetException) {
                if (!feedback.isDebugEnabled()) break block11;
                feedback.debug(BRTM_MODULE, "reflectionCallSetContentLengthLong: InvocationTargetException throwable");
            }
        }
    }

    private boolean checkSearchState() {
        return this.m_contentLength == null ? this.m_javaScriptWritten || this.offset >= this.m_maxResponseContentLengthForSearching : this.m_javaScriptWritten || this.offset >= this.m_contentLength || this.offset >= this.m_maxResponseContentLengthForSearching;
    }

    public String getModifiedContent(String content, String lowerCaseContent, String source) {
        String result = null;
        if (content == null) {
            result = content;
            if (feedback.isTraceEnabled()) {
                feedback.trace("...responsewrapperbase .....getModifiedContent is null ... can not find <head> or <body> tag, url = " + this.m_url);
            }
        } else {
            int headIndex = lowerCaseContent.indexOf(HTTPHEADTAG);
            if (headIndex >= 0) {
                if (this.isValidTag(lowerCaseContent, HTTPHEADTAG)) {
                    int closeHeadTagIndex = 0;
                    closeHeadTagIndex = HTTPHEADTAG_START.equalsIgnoreCase(lowerCaseContent.substring(headIndex, headIndex + 6)) ? headIndex + 5 : this.getCloseHeadTagIndex(content, headIndex);
                    if (closeHeadTagIndex > headIndex) {
                        String beforeHeadTag = content.substring(0, closeHeadTagIndex + 1);
                        String afterHeadTag = content.substring(closeHeadTagIndex + 1);
                        this.insertedSnippetSource = this.replaceCorrelation(source);
                        result = String.valueOf(beforeHeadTag) + this.insertedSnippetSource + afterHeadTag;
                        this.m_javaScriptWritten = true;
                        this.removeCookie();
                        if (feedback.isTraceEnabled()) {
                            feedback.trace("...responsewrapperbase .....getModifiedContent... find <head> to insert the snippet code, url = " + this.m_url);
                        }
                    } else {
                        result = content;
                        if (feedback.isTraceEnabled()) {
                            feedback.trace("...responsewrapperbase .....getModifiedContent... can not find <head> tag, url = " + this.m_url);
                        }
                    }
                } else {
                    result = content;
                    if (feedback.isTraceEnabled()) {
                        feedback.trace("...responsewrapperbase .....getModifiedContent... can not find <head> tag, url = " + this.m_url);
                    }
                }
            } else {
                int bodyIndex = lowerCaseContent.indexOf(HTTPBODYTAG);
                if (bodyIndex >= 0 && this.isValidTag(lowerCaseContent, HTTPBODYTAG)) {
                    String beforeBodyTag = content.substring(0, bodyIndex);
                    String afterBodyTag = content.substring(bodyIndex);
                    this.insertedSnippetSource = HTTPHEADTAG_START + this.replaceCorrelation(source) + HTTPHEADTAG_END;
                    result = String.valueOf(beforeBodyTag) + this.insertedSnippetSource + afterBodyTag;
                    this.m_javaScriptWritten = true;
                    this.removeCookie();
                    if (feedback.isTraceEnabled()) {
                        feedback.debug("...responsewrapperbase .....getModifiedContent... find <body> tag to insert the snippet code, url = " + this.m_url);
                    }
                } else {
                    result = content;
                    if (feedback.isTraceEnabled()) {
                        feedback.trace("...responsewrapperbase .....getModifiedContent... can not find <body> tag, url = " + this.m_url);
                    }
                }
            }
        }
        return result;
    }

    private void removeCookie() {
        String createdCookieName = BTThreadLocalAdministrator.getInstance().getString("createdCookie");
        if (createdCookieName != null) {
            Cookie c = new Cookie(createdCookieName, "");
            c.setPath("/");
            c.setMaxAge(0);
            this.addCookie(c);
        }
    }

    private String replaceCorrelation(String source) {
        String correlation = BTThreadLocalAdministrator.getInstance().getString("btCorrelationValue");
        if (correlation != null) {
            source = source.replaceAll("<correlation>", correlation);
        }
        return source;
    }

    public int getCloseHeadTagIndex(String content, int headIndex) {
        int closeHeadTagIndex = -1;
        int currentIndex = headIndex;
        boolean existSingleQuotationMark = false;
        boolean existDoubleQuotationMark = false;
        while (currentIndex < content.length()) {
            int closeHeadTag = content.substring(currentIndex).indexOf(">");
            if (closeHeadTag == -1) {
                closeHeadTagIndex = -1;
                return closeHeadTagIndex;
            }
            int singleQuotationMark = content.substring(currentIndex, closeHeadTag + currentIndex).indexOf("'");
            int doubleQuotationMark = content.substring(currentIndex, closeHeadTag + currentIndex).indexOf("\"");
            existSingleQuotationMark = singleQuotationMark > 0;
            boolean bl = existDoubleQuotationMark = doubleQuotationMark > 0;
            if (existSingleQuotationMark && existDoubleQuotationMark) {
                if (doubleQuotationMark < singleQuotationMark) {
                    currentIndex += doubleQuotationMark + content.substring(currentIndex + doubleQuotationMark + 1).indexOf("\"") + 2;
                    continue;
                }
                currentIndex += singleQuotationMark + content.substring(currentIndex + singleQuotationMark + 1).indexOf("'") + 2;
                continue;
            }
            if (existSingleQuotationMark) {
                currentIndex += singleQuotationMark + content.substring(currentIndex + singleQuotationMark + 1).indexOf("'") + 2;
                continue;
            }
            if (existDoubleQuotationMark) {
                currentIndex += doubleQuotationMark + content.substring(currentIndex + doubleQuotationMark + 1).indexOf("\"") + 2;
                continue;
            }
            closeHeadTagIndex = currentIndex + closeHeadTag;
            break;
        }
        return closeHeadTagIndex;
    }

    public class BRTOutputStream
    extends ServletOutputStream {
        private ServletOutputStream stream;
        private boolean m_bIsClosed = false;
        private BRTHttpServletResponseWrapperBase m_wrapper;

        public BRTOutputStream(ServletOutputStream stream, boolean isClosed, BRTHttpServletResponseWrapperBase wrapper) {
            this.stream = stream;
            this.m_bIsClosed = isClosed;
            this.m_wrapper = wrapper;
        }

        public void close() throws IOException {
            this.m_bIsClosed = true;
            BRTHttpServletResponseWrapperBase.this.m_bIsClosedAll = true;
        }

        public void reallyClose() throws IOException {
            this.stream.close();
            this.m_bIsClosed = true;
            BRTHttpServletResponseWrapperBase.this.m_bIsClosedAll = true;
        }

        public boolean equals(Object obj) {
            return this.stream.equals(obj);
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public int hashCode() {
            return this.stream.hashCode();
        }

        public String toString() {
            return this.stream.toString();
        }

        public void writeStream(int off, int len, byte ... b) throws IOException {
            if (this.m_bIsClosed) {
                return;
            }
            try {
                if (BRTHttpServletResponseWrapperBase.this.getShouldExecute().booleanValue()) {
                    if (!BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                        long previousOffset = BRTHttpServletResponseWrapperBase.this.offset;
                        if (!BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset >= BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                this.stream.write(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.getSubsetArray(b, off, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset))));
                                this.stream.write(b, off + (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), (int)((long)len - (BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)));
                            } else {
                                this.stream.write(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.getSubsetArray(b, off, len)));
                            }
                            return;
                        }
                        if (BRTHttpServletResponseWrapperBase.this.offset < BRTHttpServletResponseWrapperBase.this.m_contentLength) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset > BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                BRTHttpServletResponseWrapperBase.this.appendByteBuffer(off, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), b);
                                byte[] result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer);
                                if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                }
                                this.stream.write(result);
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                                this.stream.write(b, off + (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), (int)((long)len - (BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)));
                                return;
                            }
                            BRTHttpServletResponseWrapperBase.this.appendByteBuffer(off, len, b);
                            byte[] result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer);
                            if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                this.stream.write(result);
                                BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                            }
                            return;
                        }
                    } else if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                        this.stream.write(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString().getBytes(BRTHttpServletResponseWrapperBase.this.m_outer.getCharacterEncoding()));
                        BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                    }
                }
                if (BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                }
                this.stream.write(b, off, len);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, BRTHttpServletResponseWrapperBase.this.getWrapperName(), t);
                }
                if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                    this.stream.write(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString().getBytes(BRTHttpServletResponseWrapperBase.this.m_outer.getCharacterEncoding()));
                }
                this.stream.write(b, off, len);
            }
        }

        public void printStream(char ch) throws IOException {
            if (this.m_bIsClosed) {
                return;
            }
            try {
                int len = 1;
                if (BRTHttpServletResponseWrapperBase.this.getShouldExecute().booleanValue()) {
                    if (!BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                        if (!BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset >= BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                            }
                            this.stream.print(ch);
                            return;
                        }
                        if (BRTHttpServletResponseWrapperBase.this.offset < BRTHttpServletResponseWrapperBase.this.m_contentLength) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset > BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                            }
                            BRTHttpServletResponseWrapperBase.this.appendStringBuffer(new char[]{ch});
                            String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                            if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                this.stream.print(result);
                                BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                            }
                            return;
                        }
                    } else if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                        this.stream.print(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                        BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                    }
                }
                if (BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                }
                this.stream.print(ch);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, BRTHttpServletResponseWrapperBase.this.getWrapperName(), t);
                }
                if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                    this.stream.print(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                }
                this.stream.print(ch);
            }
        }

        public void printStream(String str) throws IOException {
            if (this.m_bIsClosed) {
                return;
            }
            try {
                int len = str.length();
                if (BRTHttpServletResponseWrapperBase.this.getShouldExecute().booleanValue()) {
                    if (!BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                        long previousOffset = BRTHttpServletResponseWrapperBase.this.offset;
                        if (!BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset >= BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                this.stream.print(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(str.substring(0, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset - 1L))));
                                this.stream.print(str.substring((int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)));
                            } else {
                                this.stream.print(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(str));
                            }
                            return;
                        }
                        if (BRTHttpServletResponseWrapperBase.this.offset < BRTHttpServletResponseWrapperBase.this.m_contentLength) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset > BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                BRTHttpServletResponseWrapperBase.this.appendStringBuffer(str.substring(0, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset - 1L)));
                                String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                                if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                }
                                this.stream.print(result);
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                                this.stream.print(str.substring((int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)));
                                return;
                            }
                            BRTHttpServletResponseWrapperBase.this.appendStringBuffer(str);
                            String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                            if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                this.stream.print(result);
                                BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                            }
                            return;
                        }
                    } else if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                        this.stream.print(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                        BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                    }
                }
                if (BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                }
                this.stream.print(str);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, BRTHttpServletResponseWrapperBase.this.getWrapperName(), t);
                }
                if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                    this.stream.print(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                }
                this.stream.print(str);
            }
        }

        public void printlnStream(String str) throws IOException {
            if (this.m_bIsClosed) {
                return;
            }
            try {
                int len = str.length();
                if (BRTHttpServletResponseWrapperBase.this.getShouldExecute().booleanValue()) {
                    if (!BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                        long previousOffset = BRTHttpServletResponseWrapperBase.this.offset;
                        if (!BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset >= BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                this.stream.println(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(str.substring(0, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset - 1L))));
                                this.stream.println(str.substring((int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)));
                            } else {
                                this.stream.println(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(str));
                            }
                            return;
                        }
                        if (BRTHttpServletResponseWrapperBase.this.offset < BRTHttpServletResponseWrapperBase.this.m_contentLength) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset > BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                BRTHttpServletResponseWrapperBase.this.appendStringBufferLn(str.substring(0, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset - 1L)));
                                String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                                if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                }
                                this.stream.println(result);
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                                this.stream.println(str.substring((int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)));
                                return;
                            }
                            BRTHttpServletResponseWrapperBase.this.appendStringBufferLn(str);
                            String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                            if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                this.stream.println(result);
                                BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                            }
                            return;
                        }
                    } else if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                        this.stream.println(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                        BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                    }
                }
                if (BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                }
                this.stream.println(str);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, BRTHttpServletResponseWrapperBase.this.getWrapperName(), t);
                }
                if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                    this.stream.println(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                }
                this.stream.println(str);
            }
        }

        public void printlnStream(char ch) throws IOException {
            if (this.m_bIsClosed) {
                return;
            }
            try {
                int len = 1;
                if (BRTHttpServletResponseWrapperBase.this.getShouldExecute().booleanValue()) {
                    if (!BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                        if (!BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset >= BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                            }
                            this.stream.println(ch);
                            return;
                        }
                        if (BRTHttpServletResponseWrapperBase.this.offset < BRTHttpServletResponseWrapperBase.this.m_contentLength) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset > BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                            }
                            BRTHttpServletResponseWrapperBase.this.appendStringBufferLn(new char[]{ch});
                            String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                            if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                this.stream.println(result);
                                BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                            }
                            return;
                        }
                    } else if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                        this.stream.println(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                        BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                    }
                }
                if (BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                }
                this.stream.println(ch);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, BRTHttpServletResponseWrapperBase.this.getWrapperName(), t);
                }
                if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                    this.stream.println(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                }
                this.stream.println(ch);
            }
        }

        public void write(byte[] b) throws IOException {
            if (b != null) {
                int len = b.length;
                this.writeStream(0, len, b);
            }
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.writeStream(off, len, b);
        }

        public void write(int b) throws IOException {
            this.writeStream(0, 1, (byte)b);
        }

        public void print(char arg0) throws IOException {
            this.printStream(arg0);
        }

        public void print(String arg0) throws IOException {
            this.printStream(arg0);
        }

        public void println(char arg0) throws IOException {
            this.printlnStream(arg0);
        }

        public void println(String arg0) throws IOException {
            this.printlnStream(arg0);
        }
    }

    protected class BRTPrintWriterWrapper
    extends PrintWriter {
        private PrintWriter writer;
        private boolean m_bIsClosed;
        private BRTHttpServletResponseWrapperBase m_wrapper;

        protected BRTPrintWriterWrapper(PrintWriter writer, boolean isClosed, BRTHttpServletResponseWrapperBase wrapper) {
            super(writer);
            this.m_bIsClosed = false;
            this.writer = writer;
            this.m_bIsClosed = isClosed;
            this.m_wrapper = wrapper;
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...BRTPrintWriterWrapper: constructor. outer type:" + writer.getClass().getName() + ", url = " + BRTHttpServletResponseWrapperBase.this.m_url);
            }
        }

        @Override
        public void close() {
            if (feedback.isTraceEnabled()) {
                feedback.trace(BRTM_MODULE, "...BRTPrintWriterWrapper: close, url = " + BRTHttpServletResponseWrapperBase.this.m_url);
            }
            this.m_bIsClosed = true;
            BRTHttpServletResponseWrapperBase.this.m_bIsClosedAll = true;
        }

        public void reallyClose() {
            this.writer.close();
            this.m_bIsClosed = true;
            BRTHttpServletResponseWrapperBase.this.m_bIsClosedAll = true;
        }

        @Override
        public void flush() {
            this.writer.flush();
        }

        public boolean equals(Object obj) {
            return this.writer.equals(obj);
        }

        public int hashCode() {
            return this.writer.hashCode();
        }

        public String toString() {
            return this.writer.toString();
        }

        public void writeWriter(int off, int len, char ... chars) {
            if (this.m_bIsClosed) {
                return;
            }
            try {
                if (BRTHttpServletResponseWrapperBase.this.getShouldExecute().booleanValue()) {
                    if (!BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                        long previousOffset = BRTHttpServletResponseWrapperBase.this.offset;
                        if (!BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset >= BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                this.writer.write(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.getSubString(off, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), chars)));
                                this.writer.write(chars, off + (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), (int)((long)len - (BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)));
                            } else {
                                this.writer.write(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.getSubString(off, len, chars)));
                            }
                            return;
                        }
                        if (BRTHttpServletResponseWrapperBase.this.offset < BRTHttpServletResponseWrapperBase.this.m_contentLength) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset > BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                BRTHttpServletResponseWrapperBase.this.appendStringBuffer(off, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), chars);
                                String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                                if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                }
                                this.writer.write(result);
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                                this.writer.write(chars, off + (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), (int)((long)len - (BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)));
                                return;
                            }
                            BRTHttpServletResponseWrapperBase.this.appendStringBuffer(off, len, chars);
                            String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                            if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                this.writer.write(result);
                                BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                            }
                            return;
                        }
                    } else if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                        this.writer.write(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                        BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                    }
                }
                if (BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                }
                this.writer.write(chars, off, len);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, BRTHttpServletResponseWrapperBase.this.getWrapperName(), t);
                }
                if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                    this.writer.write(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                }
                this.writer.write(chars, off, len);
            }
        }

        public void printWriter(char ... chars) {
            if (this.m_bIsClosed) {
                return;
            }
            try {
                int len = chars.length;
                if (BRTHttpServletResponseWrapperBase.this.getShouldExecute().booleanValue()) {
                    if (!BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                        long previousOffset = BRTHttpServletResponseWrapperBase.this.offset;
                        if (!BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset >= BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                this.writer.print(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.getSubString(0, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), chars)));
                                this.writer.print(BRTHttpServletResponseWrapperBase.this.getSubString((int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), (int)((long)len - (BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)), chars));
                            } else {
                                this.writer.print(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.getSubString(chars)));
                            }
                            return;
                        }
                        if (BRTHttpServletResponseWrapperBase.this.offset < BRTHttpServletResponseWrapperBase.this.m_contentLength) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset > BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                BRTHttpServletResponseWrapperBase.this.appendStringBuffer(BRTHttpServletResponseWrapperBase.this.getSubString(0, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), chars));
                                String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                                if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                }
                                this.writer.print(result);
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                                this.writer.print(BRTHttpServletResponseWrapperBase.this.getSubString((int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), (int)((long)len - (BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)), chars));
                                return;
                            }
                            BRTHttpServletResponseWrapperBase.this.appendStringBuffer(chars);
                            String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                            if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                this.writer.print(result);
                                BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                            }
                            return;
                        }
                    } else if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                        this.writer.print(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                        BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                    }
                }
                if (BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                }
                this.writer.print(chars);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, BRTHttpServletResponseWrapperBase.this.getWrapperName(), t);
                }
                if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                    this.writer.print(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                }
                this.writer.print(chars);
            }
        }

        public void printlnWriter(char ... chars) {
            if (this.m_bIsClosed) {
                return;
            }
            try {
                int len = chars.length;
                if (BRTHttpServletResponseWrapperBase.this.getShouldExecute().booleanValue()) {
                    if (!BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                        long previousOffset = BRTHttpServletResponseWrapperBase.this.offset;
                        if (!BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset >= BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                this.writer.println(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.getSubString(0, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), chars)));
                                this.writer.println(BRTHttpServletResponseWrapperBase.this.getSubString((int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), (int)((long)len - (BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)), chars));
                            } else {
                                this.writer.println(BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.getSubString(chars)));
                            }
                            return;
                        }
                        if (BRTHttpServletResponseWrapperBase.this.offset < BRTHttpServletResponseWrapperBase.this.m_contentLength) {
                            BRTHttpServletResponseWrapperBase bRTHttpServletResponseWrapperBase = BRTHttpServletResponseWrapperBase.this;
                            bRTHttpServletResponseWrapperBase.offset = bRTHttpServletResponseWrapperBase.offset + (long)len;
                            if (BRTHttpServletResponseWrapperBase.this.offset > BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching) {
                                BTThreadLocalAdministrator.getInstance().increaseMaxSearchCountAndRecordUrl(BRTHttpServletResponseWrapperBase.this.m_url);
                                BRTHttpServletResponseWrapperBase.this.appendStringBufferLn(BRTHttpServletResponseWrapperBase.this.getSubString(0, (int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), chars));
                                String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                                if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                }
                                this.writer.println(result);
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                                this.writer.println(BRTHttpServletResponseWrapperBase.this.getSubString((int)(BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset), (int)((long)len - (BRTHttpServletResponseWrapperBase.this.m_maxResponseContentLengthForSearching - previousOffset)), chars));
                                return;
                            }
                            BRTHttpServletResponseWrapperBase.this.appendStringBufferLn(chars);
                            String result = BRTHttpServletResponseWrapperBase.this.searchAndGetModifiedContent(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                            if (BRTHttpServletResponseWrapperBase.this.checkSearchState()) {
                                this.writer.println(result);
                                BRTHttpServletResponseWrapperBase.this.updateContentLength();
                                BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                            }
                            return;
                        }
                    } else if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                        this.writer.println(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                        BRTHttpServletResponseWrapperBase.this.stringBuffer.setLength(0);
                    }
                }
                if (BRTHttpServletResponseWrapperBase.this.m_setContentLength.booleanValue()) {
                    BRTHttpServletResponseWrapperBase.this.updateContentLength();
                }
                this.writer.println(chars);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                if (feedback.isDebugEnabled()) {
                    feedback.debug(BRTM_MODULE, BRTHttpServletResponseWrapperBase.this.getWrapperName(), t);
                }
                if (BRTHttpServletResponseWrapperBase.this.stringBuffer != null && BRTHttpServletResponseWrapperBase.this.stringBuffer.length() > 0) {
                    this.writer.println(BRTHttpServletResponseWrapperBase.this.stringBuffer.toString());
                }
                this.writer.println(chars);
            }
        }

        @Override
        public void write(String s) {
            this.writeWriter(0, s.length(), s.toCharArray());
        }

        @Override
        public void write(String s, int off, int len) {
            this.writeWriter(off, len, s.toCharArray());
        }

        @Override
        public void write(char[] buf, int off, int len) {
            this.writeWriter(off, len, buf);
        }

        @Override
        public void write(char[] buf) {
            this.writeWriter(0, buf.length, buf);
        }

        @Override
        public void write(int c) {
            char ch = (char)c;
            this.writeWriter(0, 1, ch);
        }

        @Override
        public void print(String str) {
            this.printWriter(str.toCharArray());
        }

        @Override
        public void print(char ch) {
            this.printWriter(ch);
        }

        @Override
        public void print(char[] buf) {
            this.printWriter(buf);
        }

        @Override
        public void print(int c) {
            char ch = (char)c;
            this.printWriter(ch);
        }

        @Override
        public void println(String str) {
            if (str != null) {
                this.printlnWriter(str.toCharArray());
            }
        }

        @Override
        public void println(int c) {
            char ch = (char)c;
            this.printlnWriter(ch);
        }

        @Override
        public void println(char ch) {
            this.printlnWriter(ch);
        }

        @Override
        public void println(char[] buf) {
            this.printlnWriter(buf);
        }
    }

    class WriterOutputStream
    extends OutputStream {
        private final Writer writer;
        private final String characterEncoding;

        public WriterOutputStream(String characterEncoding, Writer writer) {
            this.writer = writer;
            this.characterEncoding = characterEncoding;
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            byte[] subsetArr = this.getSubsetArray(b, off, len);
            String content = new String(subsetArr, this.characterEncoding);
            this.writer.write(content);
        }

        @Override
        public void write(int b) throws IOException {
            this.write(new byte[]{(byte)b}, 0, 1);
        }

        public byte[] getSubsetArray(byte[] b, int off, int len) {
            if (b.length == len) {
                return b;
            }
            byte[] arr = new byte[len];
            int j = 0;
            int i = off;
            while (i < off + len) {
                arr[j] = b[i];
                ++i;
                ++j;
            }
            return arr;
        }
    }
}

