/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

public final class BidirectionalIntMapping {
    private int[] fForwardMappings;
    private int[] fReverseMappings;
    private int fSize;

    public BidirectionalIntMapping(int size) {
        this.initialize(size);
    }

    private void initialize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size must be non-negative");
        }
        this.fSize = size;
        int initialCapacity = this.fSize == 0 ? 10 : this.fSize;
        this.fForwardMappings = new int[initialCapacity];
        this.fReverseMappings = new int[initialCapacity];
        int i = 0;
        while (i < this.fSize) {
            this.fForwardMappings[i] = i;
            this.fReverseMappings[i] = i;
            ++i;
        }
    }

    private void ensureCapacity(int capacity) {
        while (this.fForwardMappings.length < capacity) {
            int[] newForwardMappings = new int[this.fForwardMappings.length * 2];
            System.arraycopy(this.fForwardMappings, 0, newForwardMappings, 0, this.fForwardMappings.length);
            this.fForwardMappings = newForwardMappings;
            int[] newReverseMappings = new int[this.fReverseMappings.length * 2];
            System.arraycopy(this.fReverseMappings, 0, newReverseMappings, 0, this.fReverseMappings.length);
            this.fReverseMappings = newReverseMappings;
        }
    }

    public void setSize(int size) {
        this.initialize(size);
    }

    public int getSize() {
        return this.fSize;
    }

    public void insert(int index) {
        this.insert(index, this.fSize);
    }

    public void insert(int index, int newTarget) {
        if (index < 0 || index > this.fSize) {
            throw new IllegalArgumentException("index of " + index + " is outside the range [0," + this.fSize + "]");
        }
        if (newTarget < 0 || newTarget > this.fSize) {
            throw new IllegalArgumentException("target of " + newTarget + " is outside the range [0," + this.fSize + "]");
        }
        this.ensureCapacity(this.fSize + 1);
        if (this.fSize - index > 0) {
            System.arraycopy(this.fForwardMappings, index, this.fForwardMappings, index + 1, this.fSize - index);
        }
        if (this.fSize - newTarget > 0) {
            System.arraycopy(this.fReverseMappings, newTarget, this.fReverseMappings, newTarget + 1, this.fSize - newTarget);
        }
        ++this.fSize;
        int i = 0;
        while (i < this.fSize) {
            if (this.fForwardMappings[i] >= newTarget) {
                int n = i;
                this.fForwardMappings[n] = this.fForwardMappings[n] + 1;
            }
            if (this.fReverseMappings[i] >= index) {
                int n = i;
                this.fReverseMappings[n] = this.fReverseMappings[n] + 1;
            }
            ++i;
        }
        this.fForwardMappings[index] = newTarget;
        this.fReverseMappings[newTarget] = index;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.fSize) {
            throw new IllegalArgumentException("index of " + index + " is outside the range [0," + this.fSize + ")");
        }
        int oldTarget = this.fForwardMappings[index];
        --this.fSize;
        if (this.fSize - index > 0) {
            System.arraycopy(this.fForwardMappings, index + 1, this.fForwardMappings, index, this.fSize - index);
        }
        if (this.fSize - oldTarget > 0) {
            System.arraycopy(this.fReverseMappings, oldTarget + 1, this.fReverseMappings, oldTarget, this.fSize - oldTarget);
        }
        int i = 0;
        while (i < this.fSize) {
            if (this.fForwardMappings[i] > oldTarget) {
                int n = i;
                this.fForwardMappings[n] = this.fForwardMappings[n] - 1;
            }
            if (this.fReverseMappings[i] > index) {
                int n = i;
                this.fReverseMappings[n] = this.fReverseMappings[n] - 1;
            }
            ++i;
        }
    }

    public int mapIndex(int srcIndex) {
        if (srcIndex < 0 || srcIndex >= this.fSize) {
            throw new IllegalArgumentException("index of " + srcIndex + " is outside the range [0," + this.fSize + ")");
        }
        return this.fForwardMappings[srcIndex];
    }

    public int reverseMapIndex(int destIndex) {
        if (destIndex < 0 || destIndex >= this.fSize) {
            throw new IllegalArgumentException("index of " + destIndex + " is outside the range [0," + this.fSize + ")");
        }
        return this.fReverseMappings[destIndex];
    }

    public void setMapping(int srcIndex, int destIndex) {
        if (srcIndex < 0 || srcIndex >= this.fSize) {
            throw new IllegalArgumentException("source index of " + srcIndex + " is outside the range [0," + this.fSize + ")");
        }
        if (destIndex < 0 || destIndex >= this.fSize) {
            throw new IllegalArgumentException("dest index of " + destIndex + " is outside the range [0," + this.fSize + ")");
        }
        int previousDest = this.fForwardMappings[srcIndex];
        int previousSrc = this.fReverseMappings[destIndex];
        this.fForwardMappings[srcIndex] = destIndex;
        this.fReverseMappings[destIndex] = srcIndex;
        this.fForwardMappings[previousSrc] = previousDest;
        this.fReverseMappings[previousDest] = previousSrc;
    }

    public void moveMapping(int srcIndex, int destIndex) {
        if (srcIndex < 0 || srcIndex >= this.fSize) {
            throw new IllegalArgumentException("source index of " + srcIndex + " is outside the range [0," + this.fSize + ")");
        }
        if (destIndex < 0 || destIndex >= this.fSize) {
            throw new IllegalArgumentException("dest index of " + destIndex + " is outside the range [0," + this.fSize + ")");
        }
        int previousDest = this.fForwardMappings[srcIndex];
        int i = 0;
        while (i < this.fSize) {
            if (this.fForwardMappings[i] > previousDest) {
                int n = i;
                this.fForwardMappings[n] = this.fForwardMappings[n] - 1;
            }
            if (this.fForwardMappings[i] >= destIndex) {
                int n = i;
                this.fForwardMappings[n] = this.fForwardMappings[n] + 1;
            }
            ++i;
        }
        this.fForwardMappings[srcIndex] = destIndex;
        if (this.fSize - previousDest - 1 > 0) {
            System.arraycopy(this.fReverseMappings, previousDest + 1, this.fReverseMappings, previousDest, this.fSize - previousDest - 1);
        }
        i = 0;
        while (i < this.fSize) {
            if (this.fReverseMappings[i] > srcIndex) {
                int n = i;
                this.fReverseMappings[n] = this.fReverseMappings[n] - 1;
            }
            ++i;
        }
        if (this.fSize - destIndex - 1 > 0) {
            System.arraycopy(this.fReverseMappings, destIndex, this.fReverseMappings, destIndex + 1, this.fSize - destIndex - 1);
        }
        i = 0;
        while (i < this.fSize) {
            if (this.fReverseMappings[i] >= srcIndex) {
                int n = i;
                this.fReverseMappings[n] = this.fReverseMappings[n] + 1;
            }
            ++i;
        }
        this.fReverseMappings[destIndex] = srcIndex;
    }

    public Object clone() {
        BidirectionalIntMapping clone = new BidirectionalIntMapping(this.fSize);
        clone.fForwardMappings = (int[])this.fForwardMappings.clone();
        clone.fReverseMappings = (int[])this.fReverseMappings.clone();
        return clone;
    }
}

