/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform.aix;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.platform.ADefaultPlatformStatistics;
import com.wily.introscope.agent.platform.PlatformLibraryException;
import com.wily.introscope.agent.platform.PlatformLibraryNotSupportedException;
import com.wily.introscope.agent.platform.PlatformStatUnavailableException;
import com.wily.introscope.agent.platform.aix.AIXPlatformStatisticsBackEnd;
import com.wily.introscope.agent.platform.util.AggregateCPUUsageCalculator;
import com.wily.introscope.agent.platform.util.ProcessCPUUsageCalculator;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.wilyassert.Assertion;

public abstract class AIXPlatformStatistics
extends ADefaultPlatformStatistics {
    private static final String[] kSupportedPlatforms = new String[]{"AIXPSeries32"};
    private AggregateCPUUsageCalculator[] fAggregateCPUUsageCalculator;
    private ProcessCPUUsageCalculator fProcessCPUUsageCalculator;

    public AIXPlatformStatistics(String name, IAgent agent, String nativeLibName) throws PlatformLibraryException {
        super(name, agent, nativeLibName);
    }

    protected void checkSupportedPlatform(String platformName, String platformVersion) throws PlatformLibraryException {
        if (platformVersion != null && platformName.startsWith("AIX")) {
            String jvmarch = System.getProperty("sun.arch.data.model");
            String osarchitecture = System.getProperty("os.arch");
            if (jvmarch == null) {
                jvmarch = System.getProperty("com.ibm.vm.bitmode");
            }
            if (jvmarch.startsWith("64") && osarchitecture.startsWith("ppc")) {
                platformName = "AIXPSeries64";
            } else if (jvmarch.startsWith("32") && osarchitecture.startsWith("ppc")) {
                platformName = "AIXPSeries32";
            }
        }
        String[] supportedPlatforms = this.getSupportedPlatforms();
        boolean platformMatch = false;
        boolean versionMatch = false;
        for (int i = 0; i < supportedPlatforms.length && !versionMatch; ++i) {
            if (!supportedPlatforms[i].equals(platformName)) continue;
            platformMatch = true;
            versionMatch = this.checkSupportedVersion(platformName, platformVersion);
        }
        if (!platformMatch) {
            throw new PlatformLibraryNotSupportedException(new FormattedLocalizableMessage("Agent_Platform_Monitor_Unsupported_Platform_Message", this.IPlatformStatistics_getName(), platformName));
        }
        if (!versionMatch) {
            throw new PlatformLibraryNotSupportedException(new FormattedLocalizableMessage("Agent_Platform_Monitor_Unsupported_Platform_Version_Message", this.IPlatformStatistics_getName(), platformName, platformVersion));
        }
    }

    protected abstract boolean checkSupportedVersion(String var1, String var2);

    protected String[] getSupportedPlatforms() {
        return kSupportedPlatforms;
    }

    protected void terminate() throws PlatformLibraryException {
    }

    protected abstract AIXPlatformStatisticsBackEnd getBackEnd();

    protected void registerDefaultStats() throws PlatformLibraryException {
        int cpuCount = 0;
        cpuCount = this.getBackEnd().getInstalledCPUCount();
        Assertion.wilyAssert(cpuCount >= 0);
        this.fAggregateCPUUsageCalculator = new AggregateCPUUsageCalculator[cpuCount];
        for (int i = 0; i < cpuCount; ++i) {
            this.fAggregateCPUUsageCalculator[i] = new AggregateCPUUsageCalculator();
            long[] cpuStates = AggregateCPUUsageCalculator.kInitializedStatsArray;
            try {
                cpuStates = this.getBackEnd().getAggregateCPUUsage(i);
            }
            catch (PlatformStatUnavailableException psue) {
                // empty catch block
            }
            this.fAggregateCPUUsageCalculator[i].setSnapshot(cpuStates);
        }
        this.fProcessCPUUsageCalculator = new ProcessCPUUsageCalculator();
        try {
            this.fProcessCPUUsageCalculator.setSnapshot(this.getBackEnd().getTotalClockTicksInSeconds(), this.getBackEnd().getProcessTotalCPUUsageInSeconds());
        }
        catch (PlatformStatUnavailableException psue) {
            this.fProcessCPUUsageCalculator.setSnapshot(0L, 0L);
        }
    }

    public void IPlatformStatistics_initializePlatformSpecificStatistics() throws PlatformLibraryException {
    }

    public long IPlatformStatistics_getProcessID() throws PlatformLibraryException, PlatformStatUnavailableException {
        long pid = this.getBackEnd().getProcessID();
        Assertion.wilyAssert(pid >= 0L);
        return pid;
    }

    public int IPlatformStatistics_getCPUCount() throws PlatformLibraryException, PlatformStatUnavailableException {
        int count = this.getBackEnd().getInstalledCPUCount();
        Assertion.wilyAssert(count > 0);
        return count;
    }

    public double IPlatformStatistics_getCPUUtilizationForCurrentProcess() throws PlatformLibraryException, PlatformStatUnavailableException {
        double usage = this.fProcessCPUUsageCalculator.getTotalCPUUsageByThisProcess(this.getBackEnd().getTotalClockTicksInSeconds(), this.getBackEnd().getProcessTotalCPUUsageInSeconds());
        Assertion.wilyAssert(usage >= 0.0 && usage <= 100.0);
        return usage;
    }

    public void IPlatformStatistics_resetCPUUtilizationForCurrentProcess() throws PlatformLibraryException, PlatformStatUnavailableException {
        this.fProcessCPUUsageCalculator.setSnapshot(this.getBackEnd().getTotalClockTicksInSeconds(), this.getBackEnd().getProcessTotalCPUUsageInSeconds());
    }

    public int IPlatformStatistics_mapLinearZeroBasedCPUIndexToOSName(int linearZeroBasedIndex) {
        try {
            return this.getBackEnd().mapLinearZeroBasedCPUIndexToOSName(linearZeroBasedIndex);
        }
        catch (PlatformLibraryException ple) {
            this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Platform_Monitor_CPU_Name_Mapping_Failed_Message", this.IPlatformStatistics_getName(), Integer.toString(linearZeroBasedIndex)));
            return linearZeroBasedIndex;
        }
    }

    public void IPlatformStatistics_resetAggregateCPUUtilizationForProcessor(int linearZeroBasedIndex) throws PlatformLibraryException, PlatformStatUnavailableException {
        Assertion.wilyAssert(linearZeroBasedIndex >= 0 && linearZeroBasedIndex < this.fAggregateCPUUsageCalculator.length);
        if (linearZeroBasedIndex < 0 || linearZeroBasedIndex >= this.fAggregateCPUUsageCalculator.length) {
            throw new PlatformStatUnavailableException();
        }
        long[] cpuStates = this.getBackEnd().getAggregateCPUUsage(linearZeroBasedIndex);
        this.fAggregateCPUUsageCalculator[linearZeroBasedIndex].setSnapshot(cpuStates);
    }

    public double IPlatformStatistics_getAggregateCPUUtilizationForProcessor(int linearZeroBasedIndex) throws PlatformLibraryException, PlatformStatUnavailableException {
        Assertion.wilyAssert(linearZeroBasedIndex >= 0 && linearZeroBasedIndex < this.fAggregateCPUUsageCalculator.length);
        if (linearZeroBasedIndex < 0 || linearZeroBasedIndex >= this.fAggregateCPUUsageCalculator.length) {
            throw new PlatformStatUnavailableException();
        }
        long[] cpuStates = this.getBackEnd().getAggregateCPUUsage(linearZeroBasedIndex);
        return this.fAggregateCPUUsageCalculator[linearZeroBasedIndex].getAggregateCPUUsage(cpuStates);
    }
}

