/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.platform.aix;

import com.wily.introscope.agent.platform.ADefaultPlatformStatisticsBackEnd;
import com.wily.introscope.agent.platform.PlatformLibraryException;
import com.wily.introscope.agent.platform.PlatformStatUnavailableException;
import com.wily.wilyassert.Assertion;

public abstract class AIXPlatformStatisticsBackEnd
extends ADefaultPlatformStatisticsBackEnd {
    private static final int kCurrentAIXPlatformStatsProtocolVersion = 5;
    private final String fCPUNamePrefix = this.getCPUNamePrefix();
    private final int[] fCPUIndexMapping = this.getCPUIndexMapping();
    private final int fCPUCount = this.fCPUIndexMapping.length;

    public AIXPlatformStatisticsBackEnd(String platformMonitorName) throws PlatformLibraryException {
        super(platformMonitorName, 5);
    }

    public int IPlatformStatisticsBackEnd_getProtocolVersion() {
        return this.getProtocolVersion();
    }

    public int mapLinearZeroBasedCPUIndexToOSName(int linearZeroBasedIndex) throws PlatformLibraryException {
        Assertion.wilyAssert(linearZeroBasedIndex >= 0 && linearZeroBasedIndex <= this.fCPUIndexMapping.length - 1);
        return this.fCPUIndexMapping[linearZeroBasedIndex];
    }

    public long[] getAggregateCPUUsage(int linearZeroBasedIndex) throws PlatformStatUnavailableException, PlatformLibraryException {
        return this.getAggregateCPUUsage(this.fCPUNamePrefix + this.mapLinearZeroBasedCPUIndexToOSName(linearZeroBasedIndex));
    }

    public int getInstalledCPUCount() {
        return this.fCPUCount;
    }

    public native int getProtocolVersion();

    public native String getCPUNamePrefix() throws PlatformLibraryException;

    public native int[] getCPUIndexMapping() throws PlatformLibraryException;

    public native int getProcessID() throws PlatformStatUnavailableException;

    public native int getProcessTotalCPUUsageInSeconds() throws PlatformStatUnavailableException;

    public native int getTotalClockTicksInSeconds() throws PlatformStatUnavailableException;

    public native long[] getAggregateCPUUsage(String var1) throws PlatformStatUnavailableException;
}

