/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.JCAConnectionPool.pmi;

import com.ibm.websphere.management.statistics.CountStatistic;
import com.ibm.websphere.management.statistics.RangeStatistic;
import com.ibm.websphere.management.statistics.TimeStatistic;
import com.ibm.websphere.pmi.PmiDataInfo;
import com.ibm.websphere.pmi.PmiModuleConfig;
import com.ibm.websphere.pmi.stat.Statistic;
import com.ibm.websphere.pmi.stat.WSAverageStatistic;
import com.ibm.websphere.pmi.stat.WSCountStatistic;
import com.ibm.websphere.pmi.stat.WSRangeStatistic;
import com.ibm.websphere.pmi.stat.WSStatistic;
import com.ibm.ws.pmi.server.DataDescriptor;
import com.ibm.ws.pmi.server.PmiRegistry;
import com.ibm.ws.pmi.wire.WpdCollection;
import com.ibm.ws.pmi.wire.WpdData;
import com.ibm.ws.pmi.wire.WpdDouble;
import com.ibm.ws.pmi.wire.WpdInt;
import com.ibm.ws.pmi.wire.WpdLoad;
import com.ibm.ws.pmi.wire.WpdLong;
import com.ibm.ws.pmi.wire.WpdStat;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.IGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.LongTimeslicedValue;
import com.wily.powerpack.websphereMQ.agent.JCAConnectionPool.kConstants;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public final class MQPMIDataPoller
implements ITimestampedRunnable {
    private static final boolean kPmiV5AppearsToBePresent;
    private static final boolean kPmiV6AppearsToBePresent;
    private IAgent fAgent;
    private PMIModule fModule;
    private static final char kSeparatorReplacementChar = '_';
    private static final String kEmptySegmentReplacementString = "_unknown_";

    static {
        boolean pmiV6AppearsToBePresent = false;
        try {
            Class.forName("com.ibm.websphere.pmi.stat.WSRangeStatistic");
            Class.forName("com.ibm.websphere.pmi.stat.WSCountStatistic");
            Class.forName("com.ibm.websphere.pmi.stat.WSTimeStatistic");
            Class.forName("com.ibm.websphere.pmi.stat.WSStatistic");
            pmiV6AppearsToBePresent = true;
        }
        catch (Throwable throwable) {}
        kPmiV6AppearsToBePresent = pmiV6AppearsToBePresent;
        boolean pmiV5AppearsToBePresent = false;
        try {
            if (MQPMIDataPoller.pmiV6AppearsToBePresent()) {
                throw new RuntimeException("Already found PMIv6.");
            }
            Class.forName("com.ibm.websphere.management.statistics.RangeStatistic");
            Class.forName("com.ibm.websphere.management.statistics.CountStatistic");
            Class.forName("com.ibm.websphere.management.statistics.TimeStatistic");
            Class.forName("com.ibm.websphere.pmi.stat.Statistic");
            pmiV5AppearsToBePresent = true;
        }
        catch (Throwable throwable) {}
        kPmiV5AppearsToBePresent = pmiV5AppearsToBePresent;
    }

    public static boolean pmiV5AppearsToBePresent() {
        return kPmiV5AppearsToBePresent;
    }

    public static boolean pmiV6AppearsToBePresent() {
        return kPmiV6AppearsToBePresent;
    }

    public MQPMIDataPoller(IAgent agent, String modules) {
        PMIModule curModule = null;
        this.fAgent = agent;
        try {
            curModule = MQPMIDataPoller.pmiV6AppearsToBePresent() ? new PMIv6Module(agent, modules) : (MQPMIDataPoller.pmiV5AppearsToBePresent() ? new PMIv5Module(agent, modules) : new PMIModule(agent, modules, null, null));
        }
        catch (Throwable t) {
            agent.IAgent_safeReportError("Could not initialize PMI module " + modules, t);
        }
        this.fModule = curModule;
    }

    protected final IAgent getAgent() {
        return this.fAgent;
    }

    public void ITimestampedRunnable_execute(long nowInMillis) {
        PMIModule curModule = this.fModule;
        try {
            curModule.pollPMIForUpdates();
        }
        catch (Exception e) {
            this.getAgent().IAgent_safeReportError("Could not gather data from PMI module " + curModule.getName(), (Throwable)e);
        }
    }

    static String strip(String possibleMetricNameSegment) {
        if (possibleMetricNameSegment == null || possibleMetricNameSegment.length() == 0) {
            return kEmptySegmentReplacementString;
        }
        String result = possibleMetricNameSegment;
        result = result.replace('|', '_');
        result = result.replace(':', '_');
        return result;
    }

    static class PMIModule {
        private final IAgent fAgent;
        private final String fModuleName;
        private final PmiModuleConfig fModuleConfig;
        private final DataDescriptor fDataDescriptor;
        private final Hashtable fWpdStatAdaptors;
        private final Hashtable fMetricNames;

        private PMIModule(IAgent agent, String name) {
            this.fAgent = agent;
            this.fModuleName = name;
            this.fModuleConfig = PmiRegistry.getConfig((String)name);
            if (this.fModuleConfig == null) {
                throw new NullPointerException("No such module? " + name);
            }
            this.fDataDescriptor = new DataDescriptor(new String[]{name});
            this.fWpdStatAdaptors = new Hashtable();
            this.fMetricNames = new Hashtable();
        }

        public String getName() {
            return this.fModuleName;
        }

        protected final IAgent getAgent() {
            return this.fAgent;
        }

        protected PmiModuleConfig getPmiModuleConfig() {
            return this.fModuleConfig;
        }

        private void clearMetrics() {
            Enumeration e = this.fMetricNames.keys();
            while (e.hasMoreElements()) {
                this.fMetricNames.put(e.nextElement(), Boolean.FALSE);
            }
        }

        private void checkForDeadMetrics() {
            Vector deadMetrics = new Vector();
            Enumeration e = this.fMetricNames.keys();
            while (e.hasMoreElements()) {
                Object key = e.nextElement();
                Object val = this.fMetricNames.get(key);
                if (val != null && val != Boolean.FALSE) continue;
                deadMetrics.addElement(key);
            }
            int i = 0;
            while (i < deadMetrics.size()) {
                this.destroyMetric((String)deadMetrics.elementAt(i));
                ++i;
            }
        }

        private void destroyMetric(String name) {
            this.fMetricNames.remove(name);
            this.fWpdStatAdaptors.remove(name);
            try {
                this.getAgent().IAgent_getDataAccumulatorFactory().removeMetric(name);
            }
            catch (Exception e) {
                this.getAgent().IAgent_safeReportError("Could not remove PMI metric " + name, (Throwable)e);
            }
        }

        protected void noteMetricGathered(String name) {
            this.fMetricNames.put(name, Boolean.TRUE);
        }

        public void pollPMIForUpdates() {
            this.clearMetrics();
            WpdCollection root = PmiRegistry.get((DataDescriptor)this.fDataDescriptor, (boolean)true);
            this.recursivelyPollCollection(root, "JCA");
            this.checkForDeadMetrics();
        }

        private void recursivelyPollCollection(WpdCollection c, String prefix) {
            ArrayList kids;
            ArrayList members;
            if (c == null) {
                return;
            }
            String stripped = MQPMIDataPoller.strip(c.getName());
            if (stripped.equals("WebSphere MQ JMS Provider") && (members = c.dataMembers()) != null) {
                int m = 0;
                while (m < members.size()) {
                    try {
                        Object curDataObject = members.get(m);
                        if (curDataObject instanceof WpdData) {
                            WpdData curData = (WpdData)curDataObject;
                            String dataName = this.fModuleConfig.getDataInfo(curData.getId()).getName();
                            this.handleSingleV4DataElement("JCA|WebSphere MQ|Connection Pool:" + MQPMIDataPoller.strip(dataName), curData);
                        } else if (MQPMIDataPoller.pmiV5AppearsToBePresent()) {
                            this.handleSingleV5DataElement("JCA|WebSphere MQ|Connection Pool", curDataObject);
                        } else if (MQPMIDataPoller.pmiV6AppearsToBePresent()) {
                            this.handleSingleV6DataElement("JCA|WebSphere MQ|Connection Pool", curDataObject);
                        }
                    }
                    catch (Throwable t) {
                        this.getAgent().IAgent_safeReportError("Couldn't poll data element in JCA|WebSphere MQ|Connection Pool", t);
                    }
                    ++m;
                }
            }
            if ((kids = c.subCollections()) != null) {
                int k = 0;
                while (k < kids.size()) {
                    this.recursivelyPollCollection((WpdCollection)kids.get(k), "JCA|WebSphere MQ|Connection Pool");
                    ++k;
                }
            }
        }

        private void handleSingleV4DataElement(String introscopeMetricName, WpdData d) {
            this.noteMetricGathered(introscopeMetricName);
            try {
                if (d instanceof WpdInt) {
                    IIntegerFluctuatingCounterDataAccumulator acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(introscopeMetricName);
                    if (!this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) {
                        WpdInt cast = (WpdInt)d;
                        acc.IIntegerCounterDataAccumulator_setValue(cast.getIntValue());
                    }
                } else if (d instanceof WpdLoad) {
                    ILongFluctuatingCounterDataAccumulator acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(introscopeMetricName);
                    if (!this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) {
                        WpdLoad cast = (WpdLoad)d;
                        acc.ILongCounterDataAccumulator_setValue((long)cast.getLastValue());
                    }
                } else if (d instanceof WpdDouble) {
                    ILongFluctuatingCounterDataAccumulator acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(introscopeMetricName);
                    if (!this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) {
                        WpdDouble cast = (WpdDouble)d;
                        acc.ILongCounterDataAccumulator_setValue((long)cast.getDoubleValue());
                    }
                } else if (d instanceof WpdLong) {
                    ILongFluctuatingCounterDataAccumulator acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(introscopeMetricName);
                    if (!this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) {
                        WpdLong cast = (WpdLong)d;
                        acc.ILongCounterDataAccumulator_setValue(cast.getLongValue());
                    }
                } else if (d instanceof WpdStat) {
                    WpdStat cast = (WpdStat)d;
                    WpdStatAdaptor adaptor = this.lookupOrCreateWpdStatAdaptor(introscopeMetricName);
                    double total = cast.getTotal();
                    int count = cast.getCount();
                    adaptor.setCurrentValue(total, count);
                } else {
                    this.getAgent().IAgent_safeReportError("PMIv4Element: Couldn't understand PMIv4 value at " + introscopeMetricName, null);
                }
            }
            catch (Throwable t) {
                this.getAgent().IAgent_safeReportError("PMIv4Element: Could not poll " + introscopeMetricName, t);
            }
        }

        protected void handleSingleV5DataElement(String prefix, Object o) {
            this.getAgent().IAgent_safeReportError("PMIv5Element: Couldn't understand PMI value in " + prefix, null);
        }

        protected void handleSingleV6DataElement(String prefix, Object o) {
            this.getAgent().IAgent_safeReportError("PMIv6Element: Couldn't understand PMI value in " + prefix, null);
        }

        protected TimeStatisticAdaptor lookupOrCreateTimeStatisticAdaptor(String introscopeMetricName) throws AgentNotAvailableException {
            TimeStatisticAdaptor result = (TimeStatisticAdaptor)this.fWpdStatAdaptors.get(introscopeMetricName);
            if (result == null) {
                result = new TimeStatisticAdaptor(this.getAgent(), introscopeMetricName);
                this.fWpdStatAdaptors.put(introscopeMetricName, result);
            }
            return result;
        }

        private WpdStatAdaptor lookupOrCreateWpdStatAdaptor(String introscopeMetricName) {
            WpdStatAdaptor result = (WpdStatAdaptor)this.fWpdStatAdaptors.get(introscopeMetricName);
            if (result == null) {
                result = new WpdStatAdaptor(this.getAgent(), introscopeMetricName);
                this.fWpdStatAdaptors.put(introscopeMetricName, result);
            }
            return result;
        }

        /* synthetic */ PMIModule(IAgent iAgent, String string, PMIModule pMIModule, PMIModule pMIModule2) {
            this(iAgent, string);
        }
    }

    static final class PMIv5Module
    extends PMIModule {
        public PMIv5Module(IAgent agent, String name) {
            super(agent, name);
        }

        protected void handleSingleV5DataElement(String prefix, Object o) {
            String introscopeMetricName = null;
            try {
                if (o instanceof Statistic) {
                    Statistic curData = (Statistic)o;
                    if (curData != null) {
                        String dataName;
                        PmiDataInfo inf;
                        int id = curData.getId();
                        PmiModuleConfig cfg = this.getPmiModuleConfig();
                        if (cfg != null && (inf = cfg.getDataInfo(id)) != null && (dataName = inf.getName()) != null && kConstants.metricNameMap.containsKey(dataName)) {
                            introscopeMetricName = String.valueOf(prefix) + ':' + kConstants.metricNameMap.get(dataName);
                        }
                    }
                } else {
                    this.getAgent().IAgent_safeReportError("PMIv5: Couldn't understand PMIv5 value in " + prefix, null);
                    return;
                }
                if (introscopeMetricName != null) {
                    ILongFluctuatingCounterDataAccumulator acc;
                    this.noteMetricGathered(introscopeMetricName);
                    if (o instanceof RangeStatistic) {
                        acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(introscopeMetricName);
                        if (!this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) {
                            RangeStatistic cast = (RangeStatistic)o;
                            acc.ILongCounterDataAccumulator_setValue(cast.getCurrent());
                        }
                    } else if (o instanceof CountStatistic) {
                        acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(introscopeMetricName);
                        if (!this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) {
                            CountStatistic cast = (CountStatistic)o;
                            acc.ILongCounterDataAccumulator_setValue(cast.getCount());
                        }
                    } else if (o instanceof TimeStatistic) {
                        acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(introscopeMetricName);
                        if (!this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) {
                            TimeStatistic cast = (TimeStatistic)o;
                            long total = cast.getTotalTime();
                            long count = cast.getCount();
                            long mean = total;
                            if (count > 0L) {
                                mean = total / count;
                            }
                            acc.ILongAggregatingDataAccumulator_recordDataPoint(mean);
                        }
                    } else {
                        this.getAgent().IAgent_safeReportError("PMIv5: Couldn't understand PMIv5 value at " + introscopeMetricName, null);
                    }
                }
            }
            catch (Throwable t) {
                this.getAgent().IAgent_safeReportError("PMIv5: Could not poll " + introscopeMetricName, t);
            }
        }
    }

    static final class PMIv6Module
    extends PMIModule {
        public PMIv6Module(IAgent agent, String name) {
            super(agent, name);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        protected void handleSingleV6DataElement(String prefix, Object o) {
            String introscopeMetricName = null;
            try {
                ILongFluctuatingCounterDataAccumulator acc;
                if (o instanceof WSStatistic) {
                    String dataName;
                    PmiDataInfo inf;
                    WSStatistic curData = (WSStatistic)o;
                    if (curData == null) return;
                    int id = curData.getId();
                    PmiModuleConfig cfg = this.getPmiModuleConfig();
                    if (cfg != null && (inf = cfg.getDataInfo(id)) != null && (dataName = inf.getName()) != null) {
                        if (!kConstants.metricNameMap.containsKey(dataName)) return;
                        introscopeMetricName = String.valueOf(prefix) + ':' + MQPMIDataPoller.strip(dataName);
                    }
                } else {
                    this.getAgent().IAgent_safeReportError("Couldn't understand PMIv6 value in " + prefix, null);
                    return;
                }
                if (introscopeMetricName == null) return;
                this.noteMetricGathered(introscopeMetricName);
                if (o instanceof WSRangeStatistic) {
                    acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(introscopeMetricName);
                    if (this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) return;
                    WSRangeStatistic cast = (WSRangeStatistic)o;
                    acc.ILongCounterDataAccumulator_setValue(cast.getCurrent());
                    return;
                } else if (o instanceof WSCountStatistic) {
                    acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(introscopeMetricName);
                    if (this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) return;
                    WSCountStatistic cast = (WSCountStatistic)o;
                    acc.ILongCounterDataAccumulator_setValue(cast.getCount());
                    return;
                } else if (o instanceof WSAverageStatistic) {
                    acc = this.getAgent().IAgent_getDataAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(introscopeMetricName);
                    if (this.getAgent().IAgent_isMetricShutOff(acc.IDataAccumulator_getMetric())) return;
                    WSAverageStatistic cast = (WSAverageStatistic)o;
                    acc.ILongCounterDataAccumulator_setValue((long)cast.getMean());
                    return;
                } else {
                    this.getAgent().IAgent_safeReportError("PMIv6: Couldn't understand PMIv6 value at " + introscopeMetricName + " for: " + o.getClass().getName(), null);
                }
                return;
            }
            catch (Throwable t) {
                this.getAgent().IAgent_safeReportError("PMIv6: Could not poll " + introscopeMetricName, t);
            }
        }
    }

    static final class TimeStatisticAdaptor {
        private final IAgent fAgent;
        private long fLastTotal = 0L;
        private long fLastCount = 0L;
        private final IGatherer fGatherer;
        private final AgentMetric fAttribute;

        public TimeStatisticAdaptor(IAgent agent, String introscopeMetricName) {
            this.fAgent = agent;
            ILongAverageDataAccumulator acc = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(introscopeMetricName);
            this.fAttribute = acc.IDataAccumulator_getMetric();
            this.fGatherer = acc.IDataAccumulator_getGatherer();
        }

        public void setCurrentValue(long currentTotal, long currentCount) throws IncompatibleTypesException {
            long countDifference;
            long totalDifference = currentTotal - this.fLastTotal;
            if (totalDifference < 0L | (countDifference = currentCount - this.fLastCount) < 0L) {
                this.fGatherer.IGatherer_reinitialize();
                totalDifference = currentTotal;
                countDifference = currentCount;
            }
            if (!this.fAgent.IAgent_isMetricShutOff(this.fAttribute)) {
                long value = countDifference == 0L ? 0L : totalDifference / countDifference;
                long now = System.currentTimeMillis();
                LongTimeslicedValue l = new LongTimeslicedValue(1026, now, now, BlameStackSnapshot.kEmptyBlameStackSnapshot, countDifference, false, value, value, value);
                this.fGatherer.IGatherer_acceptAggregateTimeslicedValue((ATimeslicedValue)l);
            }
            this.fLastTotal = currentTotal;
            this.fLastCount = currentCount;
        }
    }

    static final class WpdStatAdaptor {
        private static final long kMicrosecondsPerMillisecond = 1000L;
        private static final String kSpecialCaseWpdStatThatIsNotAResponseTime = "beanModule.avgDrainSize";
        private double fLastTotal = 0.0;
        private int fLastCount = 0;
        private final IGatherer fGatherer;
        private final AgentMetric fAttribute;
        private final boolean fIsInMicroseconds;
        private final IAgent fAgent;

        public WpdStatAdaptor(IAgent agent, String introscopeMetricName) {
            this.fAgent = agent;
            ILongAverageDataAccumulator acc = agent.IAgent_getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(introscopeMetricName);
            this.fAttribute = acc.IDataAccumulator_getMetric();
            this.fGatherer = acc.IDataAccumulator_getGatherer();
            this.fIsInMicroseconds = introscopeMetricName.indexOf(kSpecialCaseWpdStatThatIsNotAResponseTime) == -1;
        }

        public void setCurrentValue(double currentTotal, int currentCount) throws IncompatibleTypesException {
            int countDifference;
            double totalDifference = currentTotal - this.fLastTotal;
            if (totalDifference < 0.0 | (countDifference = currentCount - this.fLastCount) < 0) {
                this.fGatherer.IGatherer_reinitialize();
                totalDifference = currentTotal;
                countDifference = currentCount;
            }
            if (!this.fAgent.IAgent_isMetricShutOff(this.fAttribute)) {
                long value;
                long l = value = countDifference == 0 ? 0L : (long)(totalDifference / (double)countDifference);
                if (this.fIsInMicroseconds) {
                    value /= 1000L;
                }
                long now = System.currentTimeMillis();
                LongTimeslicedValue l2 = new LongTimeslicedValue(1026, now, now, BlameStackSnapshot.kEmptyBlameStackSnapshot, (long)countDifference, false, value, value, value);
                this.fGatherer.IGatherer_acceptAggregateTimeslicedValue((ATimeslicedValue)l2);
            }
            this.fLastTotal = currentTotal;
            this.fLastCount = currentCount;
        }
    }
}

