/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.MonitoredClasses.PlaceHolder;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAMQUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueManagerUtils;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.CAQueueUtils;

public class CAMQQueueManager
extends PlaceHolder {
    public String getHostName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        Class<?> mqQueueManagerClass = mqObject.getClass();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueManager:getHostName:mqQueueManagerClass: " + mqQueueManagerClass.getName());
        try {
            this.hostname = CAMQUtils.getPropertyMQQueueManager(mqObject, "hostname");
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQQueueManager:getHostName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueManager:getHostName:Host Name: " + this.hostname);
        return this.hostname;
    }

    public String getQueueManagerName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueManager:getQueueManagerName:mqQueueManagerClass: " + mqObject.getClass().getName());
        try {
            this.qmname = CAQueueManagerUtils.getQMName(mqObject);
        }
        catch (Exception e) {
            MQPPLog.getLogger().warn(MQPPLog.getModule(), "CAMQQueueManager:getQueueManagerName:Exception: " + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueManager:getQueueManagerName:Queue Manager Name: " + this.qmname);
        return this.qmname;
    }

    public String getQueueName(InvocationData invocationdata) {
        Object mqObject = invocationdata.getInvocationObject();
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueManager:getQueueName:mqQueueManagerClass: " + mqObject.getClass().getName());
        if (invocationdata.getInvocationParameterCount() <= 5) {
            this.queuename = (String)invocationdata.getInvocationParameterAsObject(0);
        } else if (invocationdata.getInvocationParameterCount() > 5) {
            this.queuename = (String)invocationdata.getInvocationParameterAsObject(1);
        }
        if (this.queuename != null && this.queuename.trim().length() != 0 && CAQueueUtils.isDynamicQueue(mqObject, this.queuename)) {
            this.queuename = "Dynamic Queues";
        }
        MQPPLog.getLogger().debug(MQPPLog.getModule(), "CAMQQueueManager:getQueueName:Queue Name: " + this.queuename);
        return this.queuename;
    }
}

