/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils;

import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.Kconstants;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueRepository;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueVO;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;

public final class QueueManagerRepository
implements Kconstants {
    private static final String CLASS_NAME = "QueueManagerRepository.";
    private static final Object MUTEX_LOCK = new Object();
    private static Map qmVOsMap = new WeakHashMap();
    private static List queuevosList = new CopyOnWriteArrayList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static QueueVO getQueueVO(Object qmObj, String queueName) {
        QueueVO vo = null;
        if (qmObj != null) {
            WeakHashMap<String, QueueVO> queueVOsMap = (WeakHashMap<String, QueueVO>)qmVOsMap.get(qmObj);
            if (queueVOsMap != null) {
                vo = (QueueVO)queueVOsMap.get(queueName);
            }
            if (vo == null && (vo = QueueManagerRepository.createQueueVO(qmObj, queueName)) != null) {
                Object object = MUTEX_LOCK;
                synchronized (object) {
                    QueueVO vo1;
                    queueVOsMap = (WeakHashMap)qmVOsMap.get(qmObj);
                    if (queueVOsMap == null) {
                        queueVOsMap = new WeakHashMap<String, QueueVO>();
                    }
                    if ((vo1 = (QueueVO)queueVOsMap.get(queueName)) == null) {
                        queueVOsMap.put(new String(queueName), vo);
                        qmVOsMap.put(qmObj, queueVOsMap);
                        if (TraceProperties.shouldStartDiscovery() && !queuevosList.contains(vo)) {
                            queuevosList.add(vo);
                        }
                    } else {
                        vo = vo1;
                    }
                }
            }
        }
        return vo;
    }

    private static QueueVO createQueueVO(Object qmgrObj, String queueName) {
        QueueVO queueVO = null;
        Object queue = null;
        boolean tempQueueCreated = false;
        queue = MQTransactionTracerUtil.createTemporaryQueue(qmgrObj, queueName);
        if (queue != null) {
            tempQueueCreated = true;
            queueVO = QueueRepository.createQueueVO(queue, queueName);
        }
        if (tempQueueCreated) {
            MQTransactionTracerUtil.closeQueue(queue);
        }
        return queueVO;
    }

    public static Map getQmVOsMap() {
        return qmVOsMap;
    }

    public static List getQueuevosList() {
        return queuevosList;
    }
}

