/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake;

import com.wily.powerpack.websphereMQ.agent.extensions.metrics.ActivityReportMetric;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeMQMonitorAgent;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeNotifier;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakePacket;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeQM;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.MQMonitorAgentsMonitor;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;

public final class HandshakeWriter
extends Thread
implements HandshakeConstants {
    private IModuleFeedbackChannel logger = null;
    private static String queuename = TraceProperties.HANDSHAKE_QUEUE_NAME_VALUE;
    private static Integer OPEN_WRITE_OPTIONS = new Integer(8240);
    private String agentName = null;
    private static Object writeQueue = null;
    private static HandshakeWriter instance = null;
    private HandshakePacket keepAliveMsg = null;
    private MQMonitorAgentsMonitor mqMonitorAgents = null;
    private int count = 0;

    private HandshakeWriter(String agentName, String threadName, IModuleFeedbackChannel feedback) {
        super(threadName);
        this.logger = feedback;
        this.agentName = agentName;
        HandshakeQM.setIModuleFeedbackChannel(this.logger);
        this.keepAliveMsg = HandshakePacket.getInstance(agentName, this.logger);
        this.mqMonitorAgents = MQMonitorAgentsMonitor.getInstance(this.logger);
        Thread t = new Thread((Runnable)this.mqMonitorAgents, "MQAgentPropertiesReLoaderThread");
        t.start();
    }

    public void setAgentName(String agentName) {
        this.agentName = agentName;
        this.keepAliveMsg.setAgentName(agentName);
    }

    public static synchronized HandshakeWriter getInstance(String agentName, String threadName, IModuleFeedbackChannel feedback) {
        if (instance == null) {
            instance = new HandshakeWriter(agentName, threadName, feedback);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.logger.info(handshakeModule, "Started the handshake writer thread ");
        Object handshakeQM = null;
        block13: while (true) {
            if (handshakeQM != null) {
                try {
                    this.logger.info(handshakeModule, "Closing old handshake queuemanager connection for writer");
                    Reflection.closeMQQueueManager(handshakeQM);
                }
                catch (Exception exception) {}
            }
            if (MQMonitorAgentsMonitor.isMQMonitorAgentNamesEmpty()) {
                while (true) {
                    try {
                        Integer n = HandshakeNotifier.LOCKOBJECT;
                        synchronized (n) {
                            if (MQMonitorAgentsMonitor.isMQMonitorAgentNamesEmpty()) {
                                HandshakeNotifier.LOCKOBJECT.wait();
                                this.logger.info(handshakeModule, "MQMonitor name provided in the list. Continuing with the handshake reader process");
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (MQMonitorAgentsMonitor.isMQMonitorAgentNamesEmpty()) continue;
                        this.logger.info(handshakeModule, "MQMonitor name provided in the list. Continuing with the handshake writer process");
                    }
                    break;
                }
            }
            if ((handshakeQM = HandshakeQM.establishHandshakeQM()) == null) continue;
            boolean successfulQueueConn = this.createQueueHandle(handshakeQM);
            if (successfulQueueConn) {
                while (true) {
                    if (MQMonitorAgentsMonitor.isMQMonitorAgentNamesEmpty()) continue block13;
                    boolean done = this.writeMessageToMQMonitorAgents();
                    if (!done) {
                        if (writeQueue == null) continue block13;
                        try {
                            Reflection.closeMQQueue(writeQueue);
                        }
                        catch (Exception exception) {}
                        continue block13;
                    }
                    ++this.count;
                    if (this.count >= 230) {
                        this.writeKeepAliveMessageToMQMonitorAgents();
                        this.count = 0;
                    }
                    try {
                        HandshakeWriter.sleep(360000L);
                    }
                    catch (InterruptedException interruptedException) {
                        this.logger.debug(handshakeModule, "Handshake writer thread is interrupted in sleep. Shouldn't have happened, though no problem because of this. ");
                    }
                }
            }
            this.logger.warn(handshakeModule, "Problem in getting queue connection for reading from handshake queue: " + TraceProperties.HANDSHAKE_QUEUE_NAME_VALUE + " but, queue manager connection was fine. " + "Check if the queue exist in the queuemanager or queuename given " + "in the property files is correct. " + " Going to sleep for " + 60000 + " milliseconds before trying again.");
            try {
                HandshakeWriter.sleep(60000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                this.logger.debug(handshakeModule, "Handshake writer thread is interrupted in sleep. Shouldn't have happened, though no problem because of this. ");
                continue;
            }
            break;
        }
    }

    private synchronized boolean createQueueHandle(Object handshakeQM) {
        try {
            writeQueue = Reflection.createMQQueuePut(handshakeQM, queuename, OPEN_WRITE_OPTIONS);
            this.logger.info(handshakeModule, "Successful write connection to queue: " + queuename + " for handshake");
            return true;
        }
        catch (Exception e) {
            this.logger.warn(handshakeModule, "Problem in creating write connection to queue: " + queuename + " for handshake. " + e.getMessage());
            this.logger.debug((Throwable)e);
            return false;
        }
    }

    private boolean writeMessageToMQMonitorAgents() {
        long currentTimeInMillis = System.currentTimeMillis();
        HandshakeMQMonitorAgent[] mqMonitorAgentArray = this.mqMonitorAgents.getMQMonitorAgentsArray();
        if (mqMonitorAgentArray != null && mqMonitorAgentArray.length > 0) {
            try {
                int i = 0;
                while (i < mqMonitorAgentArray.length) {
                    HandshakeMQMonitorAgent mqMonitorAgent = mqMonitorAgentArray[i];
                    long timestampLastStatusUpdate = mqMonitorAgent.getTimestamp();
                    long elapsedTime = currentTimeInMillis - timestampLastStatusUpdate;
                    String mqMonitorAgentName = mqMonitorAgent.getAgentName();
                    if (elapsedTime >= 360000L) {
                        this.logger.debug(handshakeModule, "Message has to be sent to MQMonitor agent " + mqMonitorAgentName + " since the last handshake message was received " + elapsedTime + " milliseconds back from this MQMonitor agent. " + "That is greater than the heartbeat interval " + 360000 + " milliseconds for message update.");
                        this.mqMonitorAgents.setMQMonitorAgentStatus(mqMonitorAgentName, false);
                        this.logger.warn(handshakeModule, "Setting ALLMQMONITOR flag to False since heartbeat message from MQMonitor client: " + mqMonitorAgentName + " not received within " + 360000 + " millisecond interval.");
                        this.mqMonitorAgents.setAllMQMonitored(false, ActivityReportMetric.VALUE_STATUS_MESSAGE_ALL_QM_NOT_MONITORED);
                        Object message = this.keepAliveMsg.createMessageForMQMonitorAgent(mqMonitorAgentName);
                        this.logger.debug(handshakeModule, "Sending handshake message to " + mqMonitorAgentName + " with its own agentname: " + this.agentName);
                        Object pmo = Reflection.getPMO();
                        boolean msgSentFlag = Reflection.putMessageToQueue(writeQueue, message, pmo);
                        if (msgSentFlag) {
                            this.logger.debug(handshakeModule, "After Sending handshake message to " + mqMonitorAgentName + " with its own agentname: " + this.agentName);
                        } else {
                            this.logger.warn(handshakeModule, "Failed to send handshake message to " + mqMonitorAgentName + " with its own agentname: " + this.agentName);
                        }
                    } else {
                        this.logger.debug(handshakeModule, "Message not to be sent to MQMonitor agent " + mqMonitorAgentName + " since the last handshake message was received " + elapsedTime + " milliseconds back from this MQMonitor agent. " + "That is less than the heartbeat interval " + 360000 + " milliseconds for message update.");
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.logger.warn(handshakeModule, "Problem in sending handshake message to queue: " + queuename + ". ");
                this.logger.debug((Throwable)e);
                return false;
            }
        } else {
            this.logger.warn(handshakeModule, "\n***********************************************\nNo MQMonitor agent configured for property: mqmonitor.mqagent.id.list in MQAgent.properties. That is there is no MQMonitor agent configured in the System. Ensure that if any MQMonitor agent is running in the system  then provide that agent's name to this property.  This property will be read and reloaded at interval of 1800000 milliseconds.\n***********************************************");
        }
        return true;
    }

    private boolean writeKeepAliveMessageToMQMonitorAgents() {
        HandshakeMQMonitorAgent[] mqMonitorAgentArray = this.mqMonitorAgents.getMQMonitorAgentsArray();
        if (mqMonitorAgentArray != null && mqMonitorAgentArray.length > 0) {
            try {
                int i = 0;
                while (i < mqMonitorAgentArray.length) {
                    HandshakeMQMonitorAgent mqMonitorAgent = mqMonitorAgentArray[i];
                    String mqMonitorAgentName = mqMonitorAgent.getAgentName();
                    this.logger.debug(handshakeModule, "Sending MQClient agent heartbeat message to MQMonitor agent " + mqMonitorAgentName);
                    Object message = this.keepAliveMsg.createMessageForMQMonitorAgent(mqMonitorAgentName);
                    Object pmo = Reflection.getPMO();
                    this.logger.debug(handshakeModule, "Sending handshake message to " + mqMonitorAgentName + " with its own agentname: " + this.agentName);
                    boolean msgSentFlag = Reflection.putMessageToQueue(writeQueue, message, pmo);
                    if (msgSentFlag) {
                        this.logger.debug(handshakeModule, "After Sending handshake message to " + mqMonitorAgentName + " with its own agentname: " + this.agentName);
                    } else {
                        this.logger.warn(handshakeModule, "Failed to send handshake message to " + mqMonitorAgentName + " with its own agentname: " + this.agentName);
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                this.logger.warn(handshakeModule, "Problem in writing to queue: " + queuename + " for handshake. " + e.getMessage());
                this.logger.debug((Throwable)e);
                return false;
            }
        } else {
            this.logger.debug(handshakeModule, "No MQClient agent yet registered to me - agent: " + this.agentName + ". So not sending message to any MQClient agent");
        }
        return true;
    }

    public static Object getWriteQueue() {
        return writeQueue;
    }
}

