/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.MQClassLoaderUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.QueueVO;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryDataProcessor;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryDataWriter;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeManager;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeWriter;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.MQMonitorAgentsMonitor;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class MQPutTransactionTracer
extends ASingleMetricTracerFactory
implements MQTransactionTracerConstants {
    private IModuleFeedbackChannel fLogger = MQPPLog.getLogger();
    public static final Module kModule = new Module("MQPutTransactionTracer");

    static {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        MQClassLoaderUtil.initialize(classloader);
        Reflection.initialise(classloader);
        if (TraceProperties.shouldTraceMQCPT()) {
            HandshakeManager.getInstance();
        }
        if (TraceProperties.shouldStartDiscovery()) {
            MQDiscoveryDataProcessor.getInstance();
        }
    }

    public MQPutTransactionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fLogger.debug(kModule, "Inside MQPutTransactionTracer consutructor");
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        block22: {
            this.fLogger.debug(kModule, "Inside ITracer_startTrace");
            boolean traceOn = FilterController.shouldCurrentTraceBePropagated();
            boolean mqCrossProcessFlag = TraceProperties.shouldTraceMQCPT();
            boolean allQMMonitored = false;
            if (mqCrossProcessFlag) {
                allQMMonitored = MQMonitorAgentsMonitor.getInstance(this.fLogger).isAllMQMonitored();
            }
            try {
                Object object = data.getInvocationObject();
                QueueVO queueVO = null;
                Object mqMessage = null;
                Object mqPutMessageOptions = null;
                String objectClassName = object.getClass().getName();
                this.fLogger.debug(kModule, "Invocation object class name: " + objectClassName);
                mqMessage = this.getMQMessageObject(data);
                if (TraceProperties.shouldTraceMQSYSVIEW()) {
                    int feedback = MQTransactionTracerUtil.getMQMessageFeedback(mqMessage);
                    int messageType = MQTransactionTracerUtil.getMQMessageType(mqMessage);
                    if (messageType != 4 && feedback == 0) {
                        if (traceOn) {
                            MQTransactionTracerUtil.setMQMessageFeedback(mqMessage, 99990001);
                        } else {
                            MQTransactionTracerUtil.setMQMessageFeedback(mqMessage, 99990000);
                        }
                    }
                }
                if (!traceOn) break block22;
                if (objectClassName.equals("com.ibm.mq.MQDistributionList")) {
                    mqPutMessageOptions = data.getInvocationParameterAsObject(1);
                    MQTransactionTracerUtil.updatePutMessageOptions(mqPutMessageOptions);
                    if (!mqCrossProcessFlag || !allQMMonitored) break block22;
                    Object distributionListQM = MQTransactionTracerUtil.getDistributionListQueueManager(object);
                    String distributionListQMName = MQTransactionTracerUtil.getDistributionListQueueManagerName(object);
                    Object[] distributionListItems = MQTransactionTracerUtil.getDistributionListItems(object);
                    int i = 0;
                    while (i < distributionListItems.length) {
                        String queueName = MQTransactionTracerUtil.getDistributionItemQueueName(object, distributionListItems[i]);
                        String queueManagerName = MQTransactionTracerUtil.getDistributionItemQueueManagerName(object, distributionListItems[i]);
                        if (!MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName)) {
                            queueVO = MQTransactionTracerUtil.getDistributionListItemQueueVO(object, distributionListItems[i], distributionListQM, distributionListQMName);
                            if (queueVO == null) {
                                MQTransactionTracerUtil.setReportbitAndReplyToQueue(mqMessage);
                                break block22;
                            }
                            this.queueStartTrace(queueVO, mqMessage, MQTransactionTracerUtil.getDistributionListQueueManager(object));
                        }
                        ++i;
                    }
                    break block22;
                }
                if (mqCrossProcessFlag && allQMMonitored) {
                    if (objectClassName.equals("com.ibm.mq.MQQueue") || objectClassName.equals("com.ibm.mq.MQSPIQueue") || objectClassName.equals("com.ibm.mq.MQDestination") || objectClassName.equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue")) {
                        Object handshakeQueue = HandshakeWriter.getWriteQueue();
                        Object discoveryQueue = MQDiscoveryDataWriter.getWriteQueue();
                        if (object != handshakeQueue && object != discoveryQueue) {
                            queueVO = MQTransactionTracerUtil.getQueueVO(object, null, null, null);
                            String queueName = queueVO.getQueueName();
                            String queueManagerName = queueVO.getQmName();
                            if (!MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName)) {
                                this.queueStartTrace(queueVO, mqMessage, MQTransactionTracerUtil.getQueueManager(object));
                            }
                        }
                    } else if (objectClassName.equals("com.ibm.mq.MQQueueManager") || objectClassName.equals("com.ibm.mq.MQSPIQueueManager") || objectClassName.equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager")) {
                        String queueName = "";
                        Object remoteQMName = null;
                        String queueManagerName = MQTransactionTracerUtil.getQMName(object);
                        if (data.getInvocationParameterCount() <= 5) {
                            queueName = data.getInvocationParameterAsObject(0).toString().trim();
                            remoteQMName = data.getInvocationParameterAsObject(1);
                        } else {
                            queueName = data.getInvocationParameterAsObject(1).toString().trim();
                            remoteQMName = data.getInvocationParameterAsObject(2);
                        }
                        if (!MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName)) {
                            if (remoteQMName == null || remoteQMName.toString().trim().length() == 0 || remoteQMName.toString().trim().equalsIgnoreCase(queueManagerName)) {
                                queueVO = MQTransactionTracerUtil.getQueueVO(null, object, queueName, null);
                                this.queueStartTrace(queueVO, mqMessage, object);
                            } else {
                                MQTransactionTracerUtil.setReportbitAndReplyToQueue(mqMessage);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
            }
        }
    }

    private void queueStartTrace(QueueVO queueVO, Object mqMessage, Object mqQueueManager) {
        try {
            if (queueVO != null) {
                int qType = queueVO.getQueueType();
                int qDefinitionType = -1;
                if (qType == 1) {
                    qDefinitionType = queueVO.getQueueDefinitionType();
                }
                String qName = queueVO.getQueueName();
                if (qType == 3) {
                    qType = queueVO.getBaseQueueType();
                    qDefinitionType = queueVO.getBaseQueueDefinitionType();
                    qName = queueVO.getBaseQueueName();
                }
                if ("SYSTEM.ADMIN.ACTIVITY.QUEUE".equalsIgnoreCase(qName)) {
                    this.fLogger.debug(kModule, "Q is SYSTEM ADMIN ACTIVITY QUEUE, no MQ transaction trace");
                } else if (qDefinitionType == 2 || qDefinitionType == 3) {
                    this.fLogger.debug(kModule, "Q Type is PERMANENT or TEMPORARY DYNAMIC, no MQ transaction trace");
                } else if (qType == 1) {
                    this.fLogger.debug(kModule, "Q Type is LOCAL or ALIAS BASE LOCAL, will send dummy message...");
                } else {
                    this.fLogger.debug(kModule, "Q Type is REMOTE or Other, will set the activity bit");
                    MQTransactionTracerUtil.setReportbitAndReplyToQueue(mqMessage);
                }
            }
        }
        catch (Exception e) {
            this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
        }
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        this.fLogger.debug(kModule, "Inside ITracer_finishTrace");
        boolean traceOn = FilterController.shouldCurrentTraceBePropagated();
        boolean mqCrossProcessFlag = TraceProperties.shouldTraceMQCPT();
        boolean allQMMonitored = false;
        if (mqCrossProcessFlag) {
            allQMMonitored = MQMonitorAgentsMonitor.getInstance(this.fLogger).isAllMQMonitored();
        }
        try {
            int feedback;
            Object object = data.getInvocationObject();
            Object mqQueueManager = null;
            QueueVO queueVO = null;
            Object mqMessage = null;
            String objectClassName = object.getClass().getName();
            mqMessage = this.getMQMessageObject(data);
            if (TraceProperties.shouldTraceMQSYSVIEW() && ((feedback = MQTransactionTracerUtil.getMQMessageFeedback(mqMessage)) == 99990001 || feedback == 99990000)) {
                MQTransactionTracerUtil.setMQMessageFeedback(mqMessage, 0);
            }
            if (traceOn) {
                int rc = MQTransactionTracerUtil.getMQReasonCode(object);
                if (rc != 0) {
                    this.fLogger.debug(kModule, "MQPUT is not successful, no MQ correlated traces. Reason code: " + rc);
                }
                if (objectClassName.equals("com.ibm.mq.MQQueue") || objectClassName.equals("com.ibm.mq.MQSPIQueue") || objectClassName.equals("com.ibm.mq.MQDestination") || objectClassName.equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue")) {
                    Object handshakeQueue = HandshakeWriter.getWriteQueue();
                    Object discoveryQueue = MQDiscoveryDataWriter.getWriteQueue();
                    if (object != handshakeQueue && object != discoveryQueue) {
                        queueVO = MQTransactionTracerUtil.getQueueVO(object, null, null, null);
                        String queueName = queueVO.getQueueName();
                        String queueManagerName = queueVO.getQmName();
                        if (!MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName)) {
                            String messageID = MQTransactionTracerUtil.getMQMessageID(mqMessage);
                            String correlationID = MQTransactionTracerUtil.getMQCorrelationID(mqMessage);
                            MQTransactionTracerUtil.addToCorrelation(this.getAgent(), messageID, correlationID, data);
                            if (rc == 0 && mqCrossProcessFlag && allQMMonitored) {
                                mqQueueManager = MQTransactionTracerUtil.getQueueManager(object);
                                this.queueFinishTrace(queueVO, mqQueueManager, mqMessage, null);
                            }
                        } else {
                            this.fLogger.debug(kModule, String.valueOf(queueVO.getQueueName()) + " is in exclude list to avoid mq tracing");
                        }
                    } else {
                        this.fLogger.debug(kModule, "Invocation object is Handshake queue, no MQ correlated transaction trace");
                    }
                } else if (objectClassName.equals("com.ibm.mq.MQQueueManager") || objectClassName.equals("com.ibm.mq.MQSPIQueueManager") || objectClassName.equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager")) {
                    String queueName = "";
                    Object remoteQMName = null;
                    String queueManagerName = MQTransactionTracerUtil.getQMName(object);
                    if (data.getInvocationParameterCount() <= 5) {
                        queueName = data.getInvocationParameterAsObject(0).toString().trim();
                        remoteQMName = data.getInvocationParameterAsObject(1);
                    } else {
                        queueName = data.getInvocationParameterAsObject(1).toString().trim();
                        remoteQMName = data.getInvocationParameterAsObject(2);
                    }
                    if (!MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName)) {
                        String messageID = MQTransactionTracerUtil.getMQMessageID(mqMessage);
                        String correlationID = MQTransactionTracerUtil.getMQCorrelationID(mqMessage);
                        MQTransactionTracerUtil.addToCorrelation(this.getAgent(), messageID, correlationID, data);
                        if (rc == 0 && mqCrossProcessFlag && allQMMonitored && (remoteQMName == null || remoteQMName.toString().trim().length() == 0 || remoteQMName.toString().trim().equalsIgnoreCase(queueManagerName))) {
                            queueVO = MQTransactionTracerUtil.getQueueVO(null, object, queueName, null);
                            this.queueFinishTrace(queueVO, object, mqMessage, null);
                        }
                    } else {
                        this.fLogger.debug(kModule, String.valueOf(queueName) + " is in exclude list to avoid mq tracing");
                    }
                } else if (objectClassName.equals("com.ibm.mq.MQDistributionList")) {
                    mqQueueManager = MQTransactionTracerUtil.getDistributionListQueueManager(object);
                    String qmName = MQTransactionTracerUtil.getDistributionListQueueManagerName(object);
                    Object[] distributionItems = MQTransactionTracerUtil.getDistributionListItems(object);
                    Object objMessageID = null;
                    Object objCorrelationID = null;
                    int i = 0;
                    while (i < distributionItems.length) {
                        if (distributionItems[i] != null) {
                            String queueName = MQTransactionTracerUtil.getDistributionItemQueueName(object, distributionItems[i]);
                            String queueManagerName = MQTransactionTracerUtil.getDistributionItemQueueManagerName(object, distributionItems[i]);
                            if (!MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName)) {
                                objMessageID = MQTransactionTracerUtil.getDistributionItemMessageID(distributionItems[i]);
                                String messageID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(objMessageID));
                                int length = messageID.length() - 48;
                                messageID = messageID.substring(length, messageID.length());
                                this.fLogger.debug(kModule, "MQDistributionList messageID: " + messageID);
                                objCorrelationID = MQTransactionTracerUtil.getDistributionItemCorrelationID(distributionItems[i]);
                                String correlationID = MQTransactionTracerUtil.getHexId(MQTransactionTracerUtil.getBytes(objCorrelationID));
                                length = correlationID.length() - 48;
                                correlationID = correlationID.substring(length, correlationID.length());
                                this.fLogger.debug(kModule, "MQDistributionList correlationID: " + correlationID);
                                MQTransactionTracerUtil.addToCorrelation(this.getAgent(), messageID, correlationID, data);
                                if (rc == 0 && mqCrossProcessFlag && allQMMonitored && (queueVO = MQTransactionTracerUtil.getDistributionListItemQueueVO(object, distributionItems[i], mqQueueManager, qmName)) != null) {
                                    this.queueFinishTrace(queueVO, mqQueueManager, mqMessage, objMessageID);
                                }
                            } else {
                                this.fLogger.debug(kModule, String.valueOf(queueName) + " is in exclude list to avoid mq tracing");
                            }
                        }
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
        }
    }

    private void queueFinishTrace(QueueVO queueVO, Object mqQueueManager, Object mqMessage, Object objMessageID) {
        try {
            int qType = queueVO.getQueueType();
            int qDefinitionType = -1;
            if (qType == 1) {
                qDefinitionType = queueVO.getQueueDefinitionType();
            }
            String qName = queueVO.getQueueName();
            if (qType == 3) {
                qType = queueVO.getBaseQueueType();
                qDefinitionType = queueVO.getBaseQueueDefinitionType();
                qName = queueVO.getBaseQueueName();
            }
            if ("SYSTEM.ADMIN.ACTIVITY.QUEUE".equalsIgnoreCase(qName)) {
                this.fLogger.debug(kModule, "Q is SYSTEM ADMIN ACTIVITY QUEUE, no MQ transaction trace");
            } else if (qDefinitionType == 2 || qDefinitionType == 3) {
                this.fLogger.debug(kModule, "Q Type is PERMANENT or TEMPORARY DYNAMIC, no MQ transaction trace");
            } else if (qType == 1) {
                Object dummyMessage = MQTransactionTracerUtil.createDummyMessage(queueVO, mqMessage, objMessageID);
                MQTransactionTracerUtil.putDummyMessage(mqQueueManager, dummyMessage);
                this.fLogger.debug(kModule, "Q Type is LOCAL or ALIAS BASE LOCAL, sent dummy message");
            }
        }
        catch (Exception e) {
            this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
        }
    }

    private Object getMQMessageObject(InvocationData data) {
        Object mqMessage = null;
        String objectClassName = data.getInvocationObject().getClass().getName();
        if (objectClassName.equals("com.ibm.mq.MQDistributionList") || objectClassName.equals("com.ibm.mq.MQQueue") || objectClassName.equals("com.ibm.mq.MQSPIQueue") || objectClassName.equals("com.ibm.mq.MQDestination") || objectClassName.equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueue")) {
            mqMessage = data.getInvocationParameterAsObject(0);
        } else if (objectClassName.equals("com.ibm.mq.MQQueueManager") || objectClassName.equals("com.ibm.mq.MQSPIQueueManager") || objectClassName.equals("com.ibm.msg.client.wmq.v6.base.internal.MQQueueManager")) {
            mqMessage = data.getInvocationParameterCount() <= 5 ? data.getInvocationParameterAsObject(2) : data.getInvocationParameterAsObject(4);
        }
        return mqMessage;
    }
}

