/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ctg.server;

import com.ibm.ctg.client.stats.GatewayConnection;
import com.ibm.ctg.client.stats.StatData;
import com.ibm.ctg.client.stats.StatResultSet;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.api.DataRecorderFactory;
import com.wily.introscope.agent.api.IllegalMetricNameException;
import com.wily.introscope.agent.api.IntAverageDataRecorder;
import com.wily.introscope.agent.api.IntCounterDataRecorder;
import com.wily.introscope.agent.api.LongCounterDataRecorder;
import com.wily.introscope.agent.api.PerIntervalCounterDataRecorder;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.util.feedback.ABufferedApplicationFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.version.IVersion;
import java.io.PrintStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public final class APM_GlobalStatsExit_Poller
implements Runnable {
    public String stats_hostname;
    public int stats_port;
    public int stats_sleep;
    public int conn_retry_count;
    public GatewayConnection gateway;
    public boolean shuttingDown = false;
    public PrintStream stdout;
    public String err_msg;
    private static ABufferedApplicationFeedbackChannel sFeedback;
    private static IStringLocalizer sLocalizer;
    private static IVersion sVersion;
    private static String sPropertiesFilename;
    private static Properties smfProps;
    public IAgent my_agent;
    public DataAccumulatorFactory dataaccumulator_factory;
    public IntCounterDataRecorder AggEci_ProgInvokeIntRecorder;
    public IntAverageDataRecorder AggEci_RspIntRecorder;
    public IntCounterDataRecorder AggEci_ErrorsIntRecorder;
    public PerIntervalCounterDataRecorder AggEci_InvokesIntRecorder;
    public IIntegerFluctuatingCounterDataAccumulator ConcurInvokesCounter;
    public IIntegerFluctuatingCounterDataAccumulator pcumtcbRecorder;
    public IIntegerFluctuatingCounterDataAccumulator slparNameRecorder;
    public static final String kBackend_Global_Server_Stats_HLQ = "Backends|CTG_Global_Statistics_StatsExit";
    public static final String kBackend_Global_Server_Stats_GWDMN = "Backends|CTG_Global_Statistics_StatsExit|Gateway Daemon";
    public static final String kBackend_Global_Stats_CICS_Aggregates = "|CICS Aggregates";
    public static final String kBackend_Global_Stats_Conn_Manager = "|ConnectionManager";
    public static final String kBackend_Global_Stats_Conn_Manager_Threads = "|ConnectionManager Threads";
    public static final String kBackend_Global_Stats_Gateway_Daemon = "|Gateway Daemon";
    public static final String kBackend_Global_Stats_Incoming_Conn = "|Incoming Connection Requests From Clients";
    private static final Map<String, String> METRICS_FROM_STAT_ID;
    private static final String IGNORE = "";

    static {
        METRICS_FROM_STAT_ID = APM_GlobalStatsExit_Poller.metricsFromStatId();
    }

    public APM_GlobalStatsExit_Poller(IAgent agent, PrintStream trace_stdout, ABufferedApplicationFeedbackChannel trace_agentFeedback, String filteringString, String statistics_host_name, int statistics_port, int statistics_sleep_time) {
        this.stdout = trace_stdout;
        sFeedback = new ABufferedApplicationFeedbackChannel("PPCTG: GlobalStats");
        sFeedback.warn("  ----$$$$  APM_GlobalStatsExit_Poller starting up   $$$$----");
        this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller starting up   $$$$----");
        this.my_agent = agent;
        this.dataaccumulator_factory = null;
        this.conn_retry_count = 0;
        this.gateway = null;
        this.shuttingDown = false;
        this.stats_hostname = statistics_host_name;
        this.stats_port = statistics_port;
        this.stats_sleep = statistics_sleep_time * 1000;
        try {
            APM_GlobalStatsExit_Poller.class.getClassLoader();
            sLocalizer = this.my_agent.IAgent_getStringLocalizer();
            sVersion = new IntroscopeVersion(sLocalizer);
            String wilyRelease = sVersion.IVersion_getReleaseString();
            String wilyBuildNum = sVersion.IVersion_getBuildNumberString();
            this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller initialization starting.   $$$$----  Release=" + wilyRelease + " Build=" + wilyBuildNum);
            sFeedback.warn("  ----$$$$  APM_GlobalStatsExit_Poller initialization starting   $$$$----  Release=" + wilyRelease + " Build=" + wilyBuildNum);
            this.dataaccumulator_factory = agent.IAgent_getDataAccumulatorFactory();
        }
        catch (Exception e) {
            this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$---- \r\nCTG Global Stats Introscope startup logic failed: " + e.toString() + "\r\n");
            e.printStackTrace();
            sFeedback.warn("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$---- \r\nCTG Global Stats Introscope startup logic failed: " + e.toString() + "\r\n");
        }
        this.conn_retry_count = 2;
    }

    public void gstats_connect_to_gateway(String host, int port) {
        this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller attempting to connect to Gateway daemon on host=" + host + " using TCP port " + port + "   $$$$----\r\n");
        this.gateway = null;
        try {
            this.gateway = new GatewayConnection(host, port);
        }
        catch (Exception e) {
            this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to connect to Gateway daemon on port " + port + ".\r\n" + e.toString() + "\r\n");
            e.printStackTrace();
            sFeedback.warn("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to connect to Gateway daemon on port " + port + ".\r\n" + e.toString() + "\r\n");
            this.gateway = null;
            return;
        }
        this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Successfully connected to Gateway daemon on port " + port + "   $$$$----\r\n");
        sFeedback.warn("  ----$$$$  APM_GlobalStatsExit_Poller Successfully connected to Gateway daemon on port " + port + "   $$$$----\r\n");
        String statsRc = this.gateway.getStatsAPIVersion();
        this.trace_println("CTG Statistics API Version: " + statsRc);
    }

    private void gstats_publish(StatResultSet resultSet, String metricNode) {
        try {
            for (StatData statData : resultSet) {
                this.processStatData(statData, metricNode);
            }
        }
        catch (Exception e) {
            this.trace_println(" ----$$$$ APM_GlobalStatsExit_Poller Error $$$$----\r\n Failed to process resultSet.\n" + e.toString() + "\r\n");
            e.printStackTrace();
        }
    }

    private void processStatData(StatData statData, String metricNode) throws IllegalMetricNameException {
        boolean dataMeansNoSsl;
        if (statData.getRc() != 0) {
            return;
        }
        String statId = statData.getStatId();
        if (statId == null) {
            return;
        }
        Long statValue = this.longValueOf(statData);
        if (statValue == null) {
            return;
        }
        String shortDescription = statData.getShortDesc();
        boolean statIsSslPort = shortDescription.startsWith("SSL protocol handler port");
        boolean bl = dataMeansNoSsl = statValue <= 0L;
        if (statIsSslPort && dataMeansNoSsl) {
            return;
        }
        String metricName = kBackend_Global_Server_Stats_HLQ;
        String metricFromStatId = METRICS_FROM_STAT_ID.get(statId);
        if (metricFromStatId == null) {
            metricName = String.valueOf(metricName) + "|" + metricNode + ":" + shortDescription;
        } else {
            if (metricFromStatId.equals(IGNORE)) {
                return;
            }
            metricName = String.valueOf(metricName) + "|ConnectionManager:" + metricFromStatId;
        }
        LongCounterDataRecorder recorder = DataRecorderFactory.createLongCounterDataRecorder((String)metricName);
        recorder.recordCurrentValue(statValue.longValue());
    }

    private Long longValueOf(StatData statData) {
        Long statValue = null;
        try {
            String statValueAsString = statData.getValue();
            if (statValueAsString != null) {
                statValue = Long.parseLong(statValueAsString);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        return statValue;
    }

    public void gstats_runtime() {
        block29: {
            int uptime;
            String ids;
            StatResultSet resultSet;
            block28: {
                block27: {
                    block26: {
                        block25: {
                            block24: {
                                block23: {
                                    block22: {
                                        block21: {
                                            resultSet = null;
                                            ids = IGNORE;
                                            uptime = 0;
                                            if (this.gateway == null) {
                                                return;
                                            }
                                            ids = "CD";
                                            try {
                                                resultSet = this.gateway.getStats(ids);
                                            }
                                            catch (Exception e) {
                                                this.err_msg = e.toString();
                                                this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to collect resultSet " + ids + "\r\n" + this.err_msg + "\r\n");
                                                e.printStackTrace();
                                                if (!this.err_msg.startsWith("java.io.IOException: CTG6653")) break block21;
                                                this.gateway.close();
                                                this.gateway = null;
                                                return;
                                            }
                                        }
                                        this.gstats_publish(resultSet, "Client Daemon");
                                        ids = "CM";
                                        try {
                                            resultSet = this.gateway.getStats(ids);
                                        }
                                        catch (Exception e) {
                                            this.err_msg = e.toString();
                                            this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to collect resultSet " + ids + "\r\n" + this.err_msg + "\r\n");
                                            e.printStackTrace();
                                            if (!this.err_msg.startsWith("java.io.IOException: CTG6653")) break block22;
                                            this.gateway.close();
                                            this.gateway = null;
                                            return;
                                        }
                                    }
                                    this.gstats_publish(resultSet, "Connection Manager");
                                    ids = "CS";
                                    try {
                                        resultSet = this.gateway.getStats(ids);
                                    }
                                    catch (Exception e) {
                                        this.err_msg = e.toString();
                                        this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to collect resultSet " + ids + "\n" + this.err_msg + "\r\n");
                                        e.printStackTrace();
                                        if (!this.err_msg.startsWith("java.io.IOException: CTG6653")) break block23;
                                        this.gateway.close();
                                        this.gateway = null;
                                        return;
                                    }
                                }
                                this.gstats_publish(resultSet, "CICS Server");
                                ids = "GD";
                                try {
                                    resultSet = this.gateway.getStats(ids);
                                }
                                catch (Exception e) {
                                    this.err_msg = e.toString();
                                    this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to collect resultSet " + ids + "\r\n" + this.err_msg + "\r\n");
                                    e.printStackTrace();
                                    if (!this.err_msg.startsWith("java.io.IOException: CTG6653")) break block24;
                                    this.gateway.close();
                                    this.gateway = null;
                                    return;
                                }
                            }
                            this.gstats_publish(resultSet, "Gateway Daemon");
                            ids = "PH";
                            try {
                                resultSet = this.gateway.getStats(ids);
                            }
                            catch (Exception e) {
                                this.err_msg = e.toString();
                                this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to collect resultSet " + ids + "\r\n" + this.err_msg + "\r\n");
                                e.printStackTrace();
                                if (!this.err_msg.startsWith("java.io.IOException: CTG6653")) break block25;
                                this.gateway.close();
                                this.gateway = null;
                                return;
                            }
                        }
                        this.gstats_publish(resultSet, "Protocol Handler");
                        ids = "SE";
                        try {
                            resultSet = this.gateway.getStats(ids);
                        }
                        catch (Exception e) {
                            this.err_msg = e.toString();
                            this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to collect resultSet " + ids + "\r\n" + this.err_msg + "\r\n");
                            e.printStackTrace();
                            if (!this.err_msg.startsWith("java.io.IOException: CTG6653")) break block26;
                            this.gateway.close();
                            this.gateway = null;
                            return;
                        }
                    }
                    this.gstats_publish(resultSet, "System Environment");
                    ids = "WT";
                    try {
                        resultSet = this.gateway.getStats(ids);
                    }
                    catch (Exception e) {
                        this.err_msg = e.toString();
                        this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to collect resultSet " + ids + "\r\n" + this.err_msg + "\r\n");
                        e.printStackTrace();
                        if (!this.err_msg.startsWith("java.io.IOException: CTG6653")) break block27;
                        this.gateway.close();
                        this.gateway = null;
                        return;
                    }
                }
                this.gstats_publish(resultSet, "Worker Threads");
                ids = "GD_LRUNTIME";
                try {
                    resultSet = this.gateway.getStats("GD_LRUNTIME");
                }
                catch (Exception e) {
                    this.err_msg = e.toString();
                    this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to collect resultSet " + ids + "\r\n" + this.err_msg + "\r\n");
                    e.printStackTrace();
                    if (!this.err_msg.startsWith("java.io.IOException: CTG6653")) break block28;
                    this.gateway.close();
                    this.gateway = null;
                    return;
                }
            }
            for (StatData stat : resultSet) {
                if (stat.getRc() != 0) continue;
                uptime = Integer.parseInt(stat.getValue());
                int cfr_ignored_0 = uptime % 60;
                int minutes = uptime / 60;
                int cfr_ignored_1 = minutes / 60;
                int n = minutes % 60;
            }
            ids = "GD_LALLREQ";
            try {
                resultSet = this.gateway.getStats("GD_LALLREQ");
                for (StatData stat : resultSet) {
                    if (stat.getRc() != 0) continue;
                    int numberOfRequests = Integer.parseInt(stat.getValue());
                    IntCounterDataRecorder fIntCtrRecorder = DataRecorderFactory.createIntCounterDataRecorder((String)"Backends|CTG_Global_Statistics_StatsExit|Gateway Daemon:Total Requests Processed/Second");
                    fIntCtrRecorder.recordCurrentValue(numberOfRequests);
                }
            }
            catch (Exception e) {
                this.err_msg = e.toString();
                this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n  Failed to collect resultSet " + ids + "\r\n" + this.err_msg + "\r\n");
                e.printStackTrace();
                if (!this.err_msg.startsWith("java.io.IOException: CTG6653")) break block29;
                this.gateway.close();
                this.gateway = null;
                return;
            }
        }
    }

    @Override
    public void run() {
        while (!this.shuttingDown) {
            this.gstats_runtime();
            try {
                if (!this.shuttingDown) {
                    Thread.sleep(this.stats_sleep);
                }
                if (this.gateway != null) continue;
                ++this.conn_retry_count;
                if (this.conn_retry_count < 2) continue;
                this.gstats_connect_to_gateway(this.stats_hostname, this.stats_port);
                this.conn_retry_count = 0;
            }
            catch (Exception e) {
                this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n" + e.toString() + "\r\n");
                e.printStackTrace();
                sFeedback.warn("  ----$$$$  APM_GlobalStatsExit_Poller Error   $$$$----\r\n" + e.toString() + "\r\n");
            }
        }
        if (this.gateway != null) {
            this.gateway.close();
        }
        this.gateway = null;
        this.trace_println("  ----$$$$  APM_GlobalStatsExit_Poller shutdown completed successfully   $$$$----\r\n");
    }

    public void requestShutdown() {
        this.shuttingDown = true;
    }

    public synchronized void trace_println(String msg_string) {
        if (this.stdout == null) {
            if (sFeedback != null) {
                sFeedback.warn(msg_string);
            } else {
                System.out.print(String.valueOf(msg_string) + "\r\n");
                System.out.flush();
            }
        } else {
            try {
                this.stdout.print(String.valueOf(msg_string) + "\r\n");
                this.stdout.flush();
            }
            catch (Throwable t) {
                System.err.println("Error using stdout: " + t + "\r\n");
                System.err.println(String.valueOf(msg_string) + "\r\n");
                System.err.flush();
            }
        }
    }

    private static Map<String, String> metricsFromStatId() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("CM_CCURR", "Pool Count");
        map.put("CM_CALLOC", "Threads Allocated to Clients");
        map.put("CM_IALLOC", "Thread Dispatch Count");
        map.put("CM_CWAITING", IGNORE);
        map.put("CM_IALLOCHI", IGNORE);
        map.put("CM_ICREATED", IGNORE);
        map.put("CM_ITIMEOUTS", IGNORE);
        map.put("CM_LALLOC", IGNORE);
        map.put("CM_LTIMEOUTS", IGNORE);
        map.put("CM_SINIT", IGNORE);
        map.put("CM_SMAX", IGNORE);
        return Collections.unmodifiableMap(map);
    }
}

