/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.QueueNameHelper;

public class EMSExtendedBackendFormatter
implements INameFormatter {
    private final IAgent agent;
    private static final String QUEUE = "{queue}";
    private static final String EMS_SERVER = "EMS-SERVER";
    private static final String QUEUE_EMS_SERVER = "Queue|EMS-SERVER";
    private static final String QUEUE_TMP_SERVER = "Queue|TMP";
    private static final String EMS_SERVER_TMP = "$TMP$";

    public String INameFormatter_format(String name, InvocationData data) {
        String formattedName = name;
        if (formattedName.indexOf(QUEUE, 0) >= 0) {
            Object producerObject;
            Object destinationObject = data.getInvocationParameterAsObject(0);
            Object destination = QueueNameHelper.extractQueueName(this.agent, destinationObject, producerObject = data.getInvocationObject());
            if (destination != null) {
                formattedName = formattedName.replace(QUEUE, this.formatDestination(destination));
            } else {
                this.agent.IAgent_getModuleFeedback().warn("No destination found on JMS send");
            }
        }
        return formattedName;
    }

    private String formatDestination(Object destinationObject) {
        String destinationString = destinationObject.toString();
        if (this.agent.IAgent_getModuleFeedback().isDebugEnabled()) {
            this.agent.IAgent_getModuleFeedback().debug("Detected Destination: " + destinationString);
        }
        if (destinationString.indexOf(EMS_SERVER) > 0) {
            return QUEUE_EMS_SERVER;
        }
        if (destinationString.indexOf(EMS_SERVER_TMP) > 0) {
            return QUEUE_TMP_SERVER;
        }
        destinationString = destinationString.replace(':', '-');
        destinationString = destinationString.replace('[', '|');
        destinationString = destinationString.replace(']', ' ').trim();
        return destinationString;
    }

    public EMSExtendedBackendFormatter(IAgent agent) {
        this.agent = agent;
    }
}

