/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.feedback.Module;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class JMSExtendedServerNameFormatter
implements INameFormatter {
    private static final String _GET_DEST_METHOD = "getJMSDestination";
    private static final String EMS_SERVER = "EMS-SERVER";
    private static final String EMS_SERVER_TMP = "$TMP$";
    private static final String QUEUE_EMS_SERVER = "EMS-SERVER";
    private static final String QUEUE_TMP_SERVER = "TMP";
    private final IAgent agent;

    public JMSExtendedServerNameFormatter(IAgent agent) {
        this.agent = agent;
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String formattedName = name;
        if (formattedName.contains("{queue}")) {
            try {
                Object eventcontextObject = data.getInvocationParameterAsObject(0);
                String queueName = this.extractQueueName(eventcontextObject);
                if (queueName == null) {
                    queueName = this.secondOption(data);
                }
                if (queueName == null) {
                    queueName = "Default";
                }
                queueName = this.removeBadCharacters(queueName);
                formattedName = formattedName.replace("{queue}", queueName);
            }
            catch (Exception e) {
                this.agent.IAgent_getModuleFeedback().error(new Module("JMS Receive Tracer"), "Error extracting queue name", (Throwable)e);
            }
        }
        return formattedName;
    }

    private String removeBadCharacters(String queueName) {
        queueName = queueName.replace(':', '-');
        queueName = queueName.replace('[', '|');
        queueName = queueName.replace(']', ' ').trim();
        return queueName;
    }

    private String secondOption(InvocationData data) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Object eventcontextObject = data.getInvocationParameterAsObject(0);
        Field jmsreceiverField = eventcontextObject.getClass().getField("evs");
        jmsreceiverField.setAccessible(true);
        Object jmsreceiver = jmsreceiverField.get(eventcontextObject);
        Method getConfigurationMethod = jmsreceiver.getClass().getMethod("getConfiguration", new Class[0]);
        Object configuration = getConfigurationMethod.invoke(jmsreceiver, new Object[0]);
        Method getDestinationNameMethod = configuration.getClass().getMethod("getDestinationName", new Class[0]);
        String destination = (String)getDestinationNameMethod.invoke(configuration, new Object[0]);
        return destination;
    }

    private String extractQueueName(Object eventcontextObject) throws NoSuchFieldException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        if (eventcontextObject != null) {
            Field messageField = eventcontextObject.getClass().getField("message");
            messageField.setAccessible(true);
            Object messageObject = messageField.get(eventcontextObject);
            if (messageObject != null) {
                Method getDestinationMethod = messageObject.getClass().getMethod(_GET_DEST_METHOD, new Class[0]);
                getDestinationMethod.setAccessible(true);
                Object destinationObject = getDestinationMethod.invoke(messageObject, new Object[0]);
                if (destinationObject != null) {
                    return this.formatDestination(destinationObject);
                }
            }
        }
        return null;
    }

    private String formatDestination(Object destinationObject) {
        String destinationString = destinationObject.toString();
        if (destinationString.indexOf("EMS-SERVER") > 0) {
            return "EMS-SERVER";
        }
        if (destinationString.indexOf(EMS_SERVER_TMP) > 0) {
            return QUEUE_TMP_SERVER;
        }
        return destinationString;
    }
}

