/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.activity.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.soaextension.tibcobw.activity.tracer.ActivityNameUtil;
import com.wily.soaextension.tibcobw.activity.tracer.XINodePropertiesCreator;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;

public class ActivityExtendedTracer
extends ASingleInstanceTracerFactoryHC {
    private static final String CAUSE = "Cause";
    private static final String CODE2 = "Code";
    private static final String ERROR_DETAILS = "Error details";
    private static final String TIBCO = "Tibco - ";
    private static final char METRICDIVIDER = ':';
    private boolean enableErrorDetails = false;
    private static final XINodePropertiesCreator xiNodePropertiesCreator = new XINodePropertiesCreator();

    public ActivityExtendedTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        String result = this.getParameter("enableErrorDetails");
        if (result != null) {
            try {
                this.enableErrorDetails = Boolean.parseBoolean(result);
            }
            catch (Exception exception) {
                this.getModuleFeedback().error("Activities - enableErrorDetails variable must be true/false");
            }
        }
    }

    public void ITracer_startTrace(int i, InvocationData invocationdata) {
    }

    public void ITracer_finishTrace(int i, InvocationData data) {
        if (data.hasInvocationThrownException()) {
            Object processContextObject;
            Throwable error = data.getInvocationThrownException();
            String component = this.formatParameterizedName(data);
            StringBuffer errorMessage = new StringBuffer(TIBCO);
            errorMessage.append(component);
            errorMessage.append(':');
            errorMessage.append(ActivityNameUtil.extractActivityName(data, this.getAgent()));
            errorMessage.append(':');
            errorMessage.append(error.getMessage());
            if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage.toString())) {
                this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
            }
            this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(component.toString()).ILongIntervalCounterDataAccumulator_addSingleIncident();
            Object XiNodeData = this.receiveData(error);
            if (XiNodeData != null) {
                if (this.enableErrorDetails) {
                    xiNodePropertiesCreator.extractXINode(XiNodeData, this.getAgent().IAgent_getModuleFeedback(), this.getComponentTracer());
                } else {
                    this.getComponentTracer().addExtraParameter(ERROR_DETAILS, XiNodeData.toString());
                }
            }
            String code = this.receiveCode(error);
            this.getComponentTracer().addExtraParameter(CODE2, code);
            Throwable exceptionCause = this.receiveExceptionCause(error);
            if (exceptionCause != null) {
                this.getComponentTracer().addExtraParameter(CAUSE, exceptionCause.toString());
            }
            if ((processContextObject = data.getInvocationParameterAsObject(0)) != null) {
                this.outputProcessContext(processContextObject);
            }
        }
    }

    private void outputProcessContext(Object processContext) {
        ComponentTracer componentTracer = this.getComponentTracer();
        try {
            Method getIdMethod = processContext.getClass().getMethod("getId", new Class[0]);
            getIdMethod.setAccessible(true);
            Method getNameMethod = processContext.getClass().getMethod("getName", new Class[0]);
            getNameMethod.setAccessible(true);
            Method getInvocationNameMethod = processContext.getClass().getMethod("getInvocationName", new Class[0]);
            getInvocationNameMethod.setAccessible(true);
            Method getServiceMethod = processContext.getClass().getMethod("getService", new Class[0]);
            getServiceMethod.setAccessible(true);
            componentTracer.addExtraParameter("Name", getNameMethod.invoke(processContext, new Object[0]).toString());
            componentTracer.addExtraParameter("Service", (String)getServiceMethod.invoke(processContext, new Object[0]));
        }
        catch (Throwable e) {
            this.getAgent().IAgent_getModuleFeedback().warn("Error retrieving activity error information: " + e.getMessage());
        }
    }

    private Throwable receiveExceptionCause(Throwable error) {
        try {
            Method getDataMethod = error.getClass().getMethod("getExceptionCause", new Class[0]);
            Throwable cause = (Throwable)getDataMethod.invoke((Object)error, new Object[0]);
            return cause;
        }
        catch (Exception e) {
            this.getAgent().IAgent_getModuleFeedback().warn("Error retrieving activity error information: " + e.getMessage());
            return null;
        }
    }

    private String receiveCode(Throwable error) {
        try {
            Method getDataMethod = error.getClass().getMethod("getCode", new Class[0]);
            String code = (String)getDataMethod.invoke((Object)error, new Object[0]);
            return code;
        }
        catch (Exception e) {
            this.getAgent().IAgent_getModuleFeedback().warn("Error retrieving activity error information: " + e.getMessage());
            return null;
        }
    }

    private Object receiveData(Throwable error) {
        try {
            Method getDataMethod = error.getClass().getMethod("getData", new Class[0]);
            Object xiNodeObject = getDataMethod.invoke((Object)error, new Object[0]);
            return xiNodeObject;
        }
        catch (Exception e) {
            this.getAgent().IAgent_getModuleFeedback().warn("Error retrieving activity error information: " + e.getMessage());
            return null;
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void doOnEndTrace(int arg0, IStackElement stackElement, ITransactionElement arg2) {
    }

    public void doOnStartTrace(int arg0, IStackElement arg1, ITransactionElement arg2) {
    }

    protected void doOnAbortedTransactionEndTrace(int arg0, IStackElement arg1) {
    }
}

