/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.activity.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.soaextension.tibcobw.activity.tracer.XiNodeInformationExtractor;
import com.wily.soaextension.tibcobw.transport.RequestParameterContainer;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class ActivityExtendedXiNodeTracer
extends ASingleInstanceTracerFactoryHC {
    private static String regex;
    private static String webservice_check;
    private static final String PROPERTY_WEBSERVICES_AMADEUS_COM = "tibco.regex.webserviceparameter";
    private static final String TIBCO_REGEX_SESSION_PARAMETER_SEARCH_EXPRESSION = "tibco.regex.SessionParameterSearchExpression";
    private static final Module sModule;
    private boolean initialized;

    static {
        sModule = new Module("XiNode Parameter Extract");
    }

    public ActivityExtendedXiNodeTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.initialize(agent);
    }

    public void initialize(IAgent agent) {
        if (!this.initialized) {
            regex = agent.IAgent_getIndexedProperties().getProperty(TIBCO_REGEX_SESSION_PARAMETER_SEARCH_EXPRESSION);
            webservice_check = agent.IAgent_getIndexedProperties().getProperty(PROPERTY_WEBSERVICES_AMADEUS_COM);
            if (regex == null || webservice_check == null) {
                this.getModuleFeedback().error(sModule, "Extension webserviceparameter or SessionParameterSearchExpression are not configured in the IntroscopeAgent.profile");
                this.getModuleFeedback().error(sModule, "Configuration Errror - Skipping Operation detection");
            } else {
                this.getModuleFeedback().info(sModule, "Configured HTTP parameter regex: " + regex);
                this.getModuleFeedback().info(sModule, "Configured webservice regex: " + webservice_check);
                this.initialized = true;
            }
        }
    }

    public void ITracer_startTrace(int i, InvocationData data) {
        Object XiNodeDataObject;
        if (data.hasInvocationParametersAvailable() && this.initialized && (XiNodeDataObject = data.getInvocationParameterAsObject(1)) != null) {
            HashMap<String, String> parameters = XiNodeInformationExtractor.getParameters(XiNodeDataObject, this.getModuleFeedback(), webservice_check, regex);
            if (parameters.isEmpty()) {
                RequestParameterContainer.reset();
            } else {
                if (this.getModuleFeedback().isDebugEnabled()) {
                    this.getModuleFeedback().debug("Injecting in Thread Local - CorrelationID: " + this.getComponentTracer().getCrossProcessDataCache().getCorrelationID() + "; Parameters: " + parameters);
                }
                RequestParameterContainer.set(parameters);
            }
        }
    }

    public void ITracer_finishTrace(int i, InvocationData invocationdata) {
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public void doOnEndTrace(int paramInt, IStackElement paramIStackElement, ITransactionElement paramITransactionElement) {
    }

    public void doOnStartTrace(int paramInt, IStackElement paramIStackElement, ITransactionElement paramITransactionElement) {
    }

    protected void doOnAbortedTransactionEndTrace(int arg0, IStackElement arg1) {
    }
}

