/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.activity.tracer;

import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class XiNodeInformationExtractor {
    private static final String NOT_DEFINED = "Not defined";
    private static final String OPT_NAME = "OptName: ";
    private static final String WSAP_NAME = "WSAP Name: ";
    private static final String STRING = "/";
    private static final String HTTP = "http://";
    private static final String SEQUENCE_NUMBER = "Sequence Number: ";
    private static final String SESSION_ID = "Session ID: ";
    private static final Module sModule = new Module("XiNode Parameter Extract");
    private static final String UNDEFINIED = "undefinied";
    private static final Class[] CLASSES = new Class[0];
    private static final Object[] OBJECTS = new Object[0];
    private static final String PARAMETER_DEFAULT_REGEX = ".*SessionId.*>(.{10})\\|(\\d*)</.*SessionId.*";
    protected static final String DOCUMENT = new String("document");
    private static Method documentGetStringValueMethod;
    private static Method getNodeKindMethod;

    public static String getDocumentString(Object XiNodeData, IModuleFeedbackChannel moduleFeedback) {
        String nodeKind = XiNodeInformationExtractor.extractNodeKind(XiNodeData, moduleFeedback);
        String result = "undefined";
        String value = "";
        if (nodeKind.equals(DOCUMENT)) {
            if (documentGetStringValueMethod == null) {
                try {
                    documentGetStringValueMethod = XiNodeData.getClass().getMethod("getStringValue", CLASSES);
                    documentGetStringValueMethod.setAccessible(true);
                }
                catch (Exception e) {
                    moduleFeedback.error(sModule, "Error getting string value vom document node");
                    moduleFeedback.error((Throwable)e);
                }
            }
            try {
                value = (String)documentGetStringValueMethod.invoke(XiNodeData, OBJECTS);
            }
            catch (Exception e) {
                moduleFeedback.error(sModule, "Error converting string value from document node to string");
                moduleFeedback.error((Throwable)e);
            }
            if (value != null && !value.trim().equals("")) {
                result = value;
            }
        } else if (moduleFeedback.isDebugEnabled()) {
            moduleFeedback.debug(sModule, "XiNode type is not DOCUMENT");
        }
        return result;
    }

    public static HashMap<String, String> getParameters(Object XiNodeDataObject, IModuleFeedbackChannel moduleFeedback, String webservice_check, String regex) {
        String input;
        HashMap<String, String> parameters = new HashMap<String, String>();
        String inputString = input = XiNodeInformationExtractor.getDocumentString(XiNodeDataObject, moduleFeedback);
        if (input.contains(webservice_check)) {
            Pattern pattern = Pattern.compile(PARAMETER_DEFAULT_REGEX);
            try {
                pattern = Pattern.compile(regex);
            }
            catch (Exception e) {
                moduleFeedback.error(sModule, "Regular expression for parameter extraction incorrect");
                moduleFeedback.error((Throwable)e);
            }
            Matcher matcher = pattern.matcher(inputString);
            if (matcher.find()) {
                String sessionId = UNDEFINIED;
                try {
                    sessionId = matcher.group(1);
                }
                catch (Exception e) {
                    moduleFeedback.error(sModule, "Regular expression for parameter extraction incorrect: session id");
                    moduleFeedback.error((Throwable)e);
                }
                String sequenceNumber = UNDEFINIED;
                try {
                    sequenceNumber = matcher.group(2);
                }
                catch (Exception e) {
                    moduleFeedback.error(sModule, "Regular expression for parameter extraction incorrect: sequence number");
                    moduleFeedback.error((Throwable)e);
                }
                parameters.put("SessionID", sessionId);
                parameters.put("SequenceNumber", sequenceNumber);
                if (moduleFeedback.isDebugEnabled()) {
                    moduleFeedback.debug(SESSION_ID + sessionId);
                    moduleFeedback.debug(SEQUENCE_NUMBER + sequenceNumber);
                }
            }
            int last_http = input.lastIndexOf(HTTP);
            String substr_http = input.substring(last_http, input.length());
            String[] substrings = substr_http.split(STRING);
            String wSAPName = UNDEFINIED;
            try {
                wSAPName = substrings[3];
            }
            catch (Exception e) {
                moduleFeedback.error(sModule, "Substring extraction for parameters failed: WSAP Name");
                moduleFeedback.error((Throwable)e);
            }
            String optName = UNDEFINIED;
            try {
                optName = substrings[4];
            }
            catch (Exception e) {
                moduleFeedback.error(sModule, "Substring extraction for parameters failed: OptName");
                moduleFeedback.error((Throwable)e);
            }
            parameters.put("WSAPName", wSAPName);
            parameters.put("OptName", optName);
            if (moduleFeedback.isDebugEnabled()) {
                moduleFeedback.debug(sModule, WSAP_NAME + wSAPName);
                moduleFeedback.debug(sModule, OPT_NAME + optName);
            }
        }
        return parameters;
    }

    private static String extractNodeKind(Object xiNodeData, IModuleFeedbackChannel moduleFeedback) {
        try {
            Object nodeKind;
            if (getNodeKindMethod == null) {
                getNodeKindMethod = xiNodeData.getClass().getMethod("getNodeKind", CLASSES);
                getNodeKindMethod.setAccessible(true);
            }
            if ((nodeKind = getNodeKindMethod.invoke(xiNodeData, OBJECTS)) != null) {
                return nodeKind.toString();
            }
        }
        catch (Exception e) {
            moduleFeedback.error(sModule, "Error extracting Node Kind");
            moduleFeedback.error((Throwable)e);
        }
        return NOT_DEFINED;
    }
}

