/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.correlation.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.ThreadCorrelationId;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoMBBSUtil;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.correlation.hc2.CorrelationTracer;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;

public class JobCreatorCorrelationTracer
extends CorrelationTracer
implements KConstants {
    public JobCreatorCorrelationTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    private HashMap getProcessContextMap(Object processContext) {
        HashMap ctxMap = null;
        try {
            ctxMap = (HashMap)TibcoReflectionCache.getF_Job_M(processContext).get(processContext);
        }
        catch (Exception e) {
            this.fLogger.info("Exception in getProcessContextMap :" + e.toString());
        }
        return ctxMap;
    }

    private void setProcessContextMap(Object processContext, HashMap ctxMap) {
        try {
            TibcoReflectionCache.getF_Job_M(processContext).set(processContext, ctxMap);
        }
        catch (Exception e) {
            this.fLogger.info("Exception in setProcessContextMap :" + e.toString());
        }
    }

    @Override
    public void ITracer_finishTrace(int i, InvocationData invocationdata) {
        Object processContext = invocationdata.getInvocationObject();
        boolean debug = this.fLogger.isDebugEnabled();
        try {
            Object correlationData = new Object();
            HashMap<String, Object> ctxMap = null;
            if (processContext != null) {
                ctxMap = this.getProcessContextMap(processContext);
            }
            if (ctxMap == null) {
                ctxMap = new HashMap<String, Object>();
            }
            if (!ctxMap.containsKey("CorID")) {
                new CorrelationId();
                SharedCrossProcessData cache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
                cache.markNextCrossProcessCallAsNonBlocking();
                if (TibcoBWUtils.isSerializationEnabled()) {
                    correlationData = cache.getOutgoingSerializableInstance();
                    this.fLogger.debug("Cross Process data serialization is enabled, if checkpoints are failing change the property value to false");
                } else {
                    correlationData = new ThreadCorrelationId().getOutgoingStringFromInstance();
                }
                if (correlationData != null) {
                    String corId;
                    if (debug) {
                        this.fLogger.debug("JobCreatorCorrelationTracer::ITracer_finishTrace Inserting Correlation Id " + correlationData);
                    }
                    ctxMap.put("CorID", correlationData);
                    if (TibcoBWUtils.isMBBSEnabled() && TibcoMBBSUtil.getFrontend(corId = cache.getCorrelationID()) == null && invocationdata != null) {
                        TibcoMBBSUtil.addFrontendEntry(corId, invocationdata);
                        if (debug) {
                            this.fLogger.debug("JobCreatorCorrelationTracer:: Adding frontend: " + TibcoMBBSUtil.getLastFrontendCursor(invocationdata) + " for id:" + corId);
                        }
                    }
                    this.setProcessContextMap(processContext, ctxMap);
                }
            }
        }
        catch (Throwable exception) {
            this.fLogger.error("JobCreatorCorrelationTracer:ITracer_finishTrace : Unexpected Error.", exception);
            TibcoBWUtils.dumpStackTrace(exception);
        }
        super.ITracer_finishTrace(i, invocationdata);
    }
}

