/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.processes.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.errors.ErrorSnapshotFeatureFactory;
import com.wily.introscope.agent.stat.IIntegerFluctuatingCounterDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.spec.metric.ESEException;
import com.wily.soaextension.tibcobw.ATibcoSingleInstanceTracer;
import com.wily.soaextension.tibcobw.KConstants;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoPPException;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.multithread.blame.MultiBoundaryBlameStackFeature;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.util.HashMap;

public class SubprocessFinishTracer
extends ATibcoSingleInstanceTracer
implements KConstants {
    private static final String TracerName = "JobCourierTracer: ";

    private void setJobHashMap(Object createdJobObject, HashMap variablesMap) throws TibcoPPException {
        try {
            TibcoReflectionCache.getF_Job_M(createdJobObject).set(createdJobObject, variablesMap);
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
    }

    private HashMap getJobHashMap(Object createdJobObject) throws TibcoPPException {
        HashMap variablesMap = null;
        try {
            variablesMap = (HashMap)TibcoReflectionCache.getF_Job_M(createdJobObject).get(createdJobObject);
        }
        catch (Exception e) {
            throw new TibcoPPException(TracerName, e.getMessage());
        }
        return variablesMap;
    }

    public SubprocessFinishTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_finishTrace(int i, InvocationData invocationdata) {
        String component = invocationdata.getComponentNameAt(i);
        if (component != null) {
            this.getComponentTracer().removeComponent(component);
        }
        Object objcreatedJob = invocationdata.getInvocationParameterAsObject(0);
        HashMap variablesMap = null;
        try {
            variablesMap = this.getJobHashMap(objcreatedJob);
            if (variablesMap != null && variablesMap.containsKey(component)) {
                IIntegerFluctuatingCounterDataAccumulator ciCounter;
                String st = (String)variablesMap.get(component);
                variablesMap.remove(component);
                this.setJobHashMap(objcreatedJob, variablesMap);
                long start = Long.valueOf(st);
                long elapsed_time = System.currentTimeMillis() - start;
                ILongAverageDataAccumulator timerAccumulator = this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(String.valueOf(component) + ":Average Response Time (ms)");
                timerAccumulator.ILongAggregatingDataAccumulator_recordDataPoint(elapsed_time);
                ILongIntervalCounterDataAccumulator accumIntervalCnt = this.getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(String.valueOf(component) + ":Responses Per Interval");
                if (!accumIntervalCnt.IDataAccumulator_isShutOff()) {
                    accumIntervalCnt.ILongIntervalCounterDataAccumulator_addSingleIncident();
                }
                if ((ciCounter = this.getDataAccumulatorFactory().safeGetIntegerFluctuatingCounterDataAccumulator(String.valueOf(component) + ":Concurrent Invocations")) != null) {
                    ciCounter.IIntegerFluctuatingCounterDataAccumulator_decrement();
                }
            }
        }
        catch (TibcoPPException tibcoPPException) {}
    }

    private void addErrorCount(Object arg2, InvocationData data, int tracerindex) {
        Exception e = (Exception)arg2;
        String errorMessage = e.getMessage();
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        if (ErrorSnapshotFeatureFactory.flagErrorInManagedApplication((String)errorMessage)) {
            this.getAgent().IAgent_getComponentTracer().noteBoundaryError();
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug(TracerName + errorMessage);
            }
        }
        try {
            String Metricname = String.valueOf(data.getComponentNameAt(tracerindex)) + ":" + "Errors Per Interval";
            if (Metricname != null) {
                this.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(Metricname).ILongIntervalCounterDataAccumulator_addSingleIncident();
                if (TibcoBWUtils.isMBBSEnabled()) {
                    String correlationId = this.getComponentTracer().getCrossProcessDataCache().getCorrelationID();
                    MultiBoundaryBlameStackFeature blameStackFeature = (MultiBoundaryBlameStackFeature)MultiBoundaryBlameStackFeature.instance.get();
                    String frontend = blameStackFeature.getCollector().getFrontend(correlationId);
                    if (frontend != null) {
                        StringBuilder sbFrontend = new StringBuilder();
                        sbFrontend.append(frontend);
                        sbFrontend.append(":");
                        sbFrontend.append("Errors Per Interval");
                        this.getDataAccumulatorFactory().safeGetFrontendLongIntervalCounterDataAccumulator(sbFrontend.toString()).ILongIntervalCounterDataAccumulator_addSingleIncident();
                    } else {
                        TibcoBWUtils.getLogger().error("No Frontend available for SubProcess: " + data.getComponentNameAt(tracerindex));
                    }
                }
            }
        }
        catch (ESEException e1) {
            Assertion.wilyFail((String)("Metric type conflict" + e1.getMessage()));
        }
    }

    @Override
    public void ITracer_startTrace(int i, InvocationData invocationdata) {
        String component = this.formatParameterizedName(invocationdata);
        invocationdata.setComponentNameAt(component, i);
        String businessProcessName = (String)invocationdata.get("com.wily.soaextension.tibcobw.SubprocessNameKey");
        if (businessProcessName != null && businessProcessName.length() > 0) {
            this.getComponentTracer().addComponent(component, "businessprocess", businessProcessName);
        } else {
            this.getComponentTracer().addComponent(component);
            TibcoBWUtils.getLogger().error("SubprocessFinishTracer:ITracer_startTrace, SubProcessName is either null or empty : " + businessProcessName);
        }
    }
}

