/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.webservice.WebServiceNameHelper;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;

public class WebServiceBackendNameFormatter
implements INameFormatter {
    private static final Object[] EMPTYOBJECTARRAY = new Object[0];
    private static final Class[] EMPTYCLASSARRAY = new Class[0];
    private static final String GET_FIELD_MAP = "getFieldMap";
    private static final String UNDEFINED = "undefined";
    private static final String URI2 = "{URI}";
    private static final WebServiceNameHelper webServiceNameHelper = new WebServiceNameHelper();
    private IModuleFeedbackChannel feedback;
    private static Module sModule = new Module("Tibco WebService Consumer Tracer");
    private static final String WSA_PAND_OPT_NAME = "{WSAPandOptName}";
    private static final String WSA_PAND_OPT_NAME2 = "|{WSAPandOptName}";
    private static final String STRING = "|";
    private static final String NAMESPACE = "{namespace}";
    private static final String OPERATION = "{operation}";
    private final IAgent agent;
    private static Method getFieldMapMethod;

    public WebServiceBackendNameFormatter(IAgent agent) {
        this.agent = agent;
        this.feedback = agent.IAgent_getModuleFeedback();
    }

    public String INameFormatter_format(String componentName, InvocationData invocationData) {
        String uri = UNDEFINED;
        if (componentName.contains(URI2)) {
            try {
                uri = webServiceNameHelper.calculateURIWebService(invocationData, this.feedback);
            }
            catch (Exception e) {
                this.feedback.error((Throwable)e);
                this.feedback.error(sModule, "Error in calculating WebService Consumer Name for Backend metric");
            }
            componentName = componentName.replace(URI2, uri);
        }
        Object wsapName = invocationData.get("WSAPName");
        Object optName = invocationData.get("OptName");
        if (componentName.contains(WSA_PAND_OPT_NAME)) {
            if (this.feedback.isDebugEnabled()) {
                this.feedback.debug("Creating component name with CorrelationID: " + this.agent.IAgent_getComponentTracer().getCrossProcessDataCache().getCorrelationID() + "; wsapName: " + wsapName + "; optName: " + optName + " for URI: " + uri);
            }
            componentName = wsapName != null && optName != null ? componentName.replace(WSA_PAND_OPT_NAME, wsapName + STRING + optName) : componentName.replace(WSA_PAND_OPT_NAME2, "");
        }
        if (componentName.contains(NAMESPACE) || componentName.contains(OPERATION)) {
            try {
                Map fieldMap = this.lookupMap(invocationData);
                if (fieldMap == null) {
                    this.feedback.error("Error in instrumentation. No fieldmap available");
                }
                if (componentName.contains(NAMESPACE)) {
                    Object namespace = fieldMap.get("namespace");
                    String namespaceString = namespace != null ? (String)namespace : UNDEFINED;
                    componentName = componentName.replace(NAMESPACE, namespaceString);
                }
                if (componentName.contains(OPERATION)) {
                    Object operation = fieldMap.get("operation");
                    String operationString = operation != null ? (String)operation : UNDEFINED;
                    componentName = componentName.replace(OPERATION, operationString);
                }
            }
            catch (Exception ex) {
                this.agent.IAgent_getModuleFeedback().error("Error analyzing namespace and operation");
                this.agent.IAgent_getModuleFeedback().error((Throwable)ex);
            }
        }
        componentName = componentName.replaceAll(":", "-");
        return componentName;
    }

    private Map lookupMap(InvocationData data) {
        try {
            Object requestExecutor = data.getInvocationObject();
            Object transportContext = webServiceNameHelper.analyzeTransportContext(requestExecutor, this.feedback);
            if (transportContext != null) {
                if (getFieldMapMethod == null) {
                    getFieldMapMethod = transportContext.getClass().getMethod(GET_FIELD_MAP, EMPTYCLASSARRAY);
                    getFieldMapMethod.setAccessible(true);
                }
                return (Map)getFieldMapMethod.invoke(transportContext, EMPTYOBJECTARRAY);
            }
        }
        catch (Exception e) {
            this.feedback.error((Throwable)e);
            this.feedback.error(sModule, "Error with code injection - Version change???");
        }
        return new HashMap();
    }
}

