/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.soaextension.tibcobw.TibcoBWUtils;
import com.wily.soaextension.tibcobw.TibcoReflectionCache;
import com.wily.soaextension.tibcobw.transport.RequestParameterContainer;
import com.wily.util.properties.AttributeListing;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class WebServiceDetectionTracer
extends ASingleInstanceTracerFactoryHC {
    public static final String URI = "uri";
    public static final String OPERATION = "operation";
    public static final String NAMESPACE = "namespace";
    public static final String kUnknownWebService = "UnknownServiceName";
    public static final String kUnknownOperation = "UnknownOperationName";
    public static final String kUnknownNamespace = "UnknownNamespace";
    public static final String kUnknownTransport = "UnknownTransport";
    public static final String kUnknownQueueType = "UnknownQueueType";
    public static final String kUnknownQueueName = "UnknownQueue";
    private static final String C_SoapJmsRequestor = "com.tibco.bw.soap.share.reqrep.SoapJmsRequestor";

    public WebServiceDetectionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int arg0, InvocationData arg1) {
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        try {
            RequestParameterContainer.get().put(NAMESPACE, this.getNamespace(data));
            RequestParameterContainer.get().put(OPERATION, this.getOperationName(data));
            RequestParameterContainer.get().put(URI, this.getWebServiceURI(data));
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    public String getNamespace(InvocationData data) {
        String namespace = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object service;
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getF_SoapSendReceiveActivity_requestor(soapSendReceive)) != null && (service = TibcoReflectionCache.getF_SoapRequestor_ISoapServiceConfig(requestor)) != null) {
                namespace = (String)TibcoReflectionCache.getF_SoapCommonConfig_wsdlNamespace(service);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getNamespace: " + namespace);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return namespace == null || namespace.trim().length() == 0 || namespace.equals(kUnknownNamespace) ? kUnknownNamespace : namespace;
    }

    public String getWebServiceURI(InvocationData data) {
        String webServiceURI = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getF_SoapSendReceiveActivity_requestor(soapSendReceive)) != null) {
                if (requestor.getClass().getName().equalsIgnoreCase(C_SoapJmsRequestor)) {
                    Map urlToServiceConfigListMap;
                    Object engineConfig = TibcoReflectionCache.getF_SoapRequestor_SoapEngineConfig(requestor);
                    if (engineConfig != null && (urlToServiceConfigListMap = (Map)TibcoReflectionCache.getF_SoapEngineConfig_urlToServiceConfigListMap(engineConfig)) != null) {
                        Set col = urlToServiceConfigListMap.keySet();
                        Iterator itr = col.iterator();
                        while (itr.hasNext()) {
                            webServiceURI = itr.next().toString();
                        }
                    }
                } else {
                    Object endpointConfig = TibcoReflectionCache.getF_SoapHttpRequestor_SoapEndpointConfig(requestor);
                    if (endpointConfig != null) {
                        webServiceURI = (String)TibcoReflectionCache.getF_SoapEndpointConfiguration_kString(endpointConfig);
                    }
                }
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getWebServiceURI: " + webServiceURI);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_NAME", bomb);
        }
        return webServiceURI == null || webServiceURI.trim().length() == 0 || webServiceURI.equals(kUnknownWebService) ? kUnknownWebService : webServiceURI;
    }

    public String getOperationName(InvocationData data) {
        String operationName = null;
        boolean isDebugEnabled = TibcoBWUtils.getLogger().isDebugEnabled();
        try {
            Object requestor;
            Object soapSendReceive = data.getInvocationObject();
            if (soapSendReceive != null && (requestor = TibcoReflectionCache.getF_SoapSendReceiveActivity_requestor(soapSendReceive)) != null) {
                operationName = (String)TibcoReflectionCache.getF_SoapRequestor_operationName(requestor);
            }
            if (isDebugEnabled) {
                TibcoBWUtils.getLogger().debug("WebServicesClientFormatter.getOperationName: " + operationName);
            }
        }
        catch (Throwable bomb) {
            TibcoBWUtils.handleError(this.getAgent(), "ERROR_IN_WEBSERVICE_OPERATION_NAME", bomb);
        }
        return operationName == null || operationName.trim().length() == 0 || operationName.equals(kUnknownOperation) ? kUnknownOperation : operationName;
    }

    public void doOnStartTrace(int paramInt, IStackElement paramIStackElement, ITransactionElement paramITransactionElement) {
    }

    public void doOnEndTrace(int paramInt, IStackElement paramIStackElement, ITransactionElement paramITransactionElement) {
    }

    protected void doOnAbortedTransactionEndTrace(int arg0, IStackElement arg1) {
    }
}

