/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.tibcobw.webservice;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.soaextension.tibcobw.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class WebServiceNameHelper {
    private static final String UNKNOWN = "unknown";
    private static final String TIBCO_CONSUMER_SERVICE = "Tibco.Consumer.OPERATION";
    private static final String GET_SOAP_ACTION = "getSoapAction";
    private static final String TIBCO_CONSUMER_SOAPACTION = "Tibco.Consumer.SOAPACTION";
    private static final String GET_TRANSPORT_URI = "getTransportUri";
    private static final String TIBCO_CONSUMER_URL = "Tibco.Consumer.URL";
    private static final String METRICSEPERATOR = "|";
    private static Method getSOAPActionMethod;
    private static Method getTransportUriMethod;
    private static Field transportContextField;
    private static final Object[] EMPTYOBJECTARRAY;
    private static final Class[] EMPTYCLASSARRAY;
    public static final String COR_ID = "CorID";
    public static final String CORR_ID = "CorrID";
    public static final String CORRELATION_ID = "CorrelationID";

    static {
        EMPTYOBJECTARRAY = new Object[0];
        EMPTYCLASSARRAY = new Class[0];
    }

    public static String removeTrailingPipeAndChars(String formattedName) {
        formattedName = formattedName.replace(':', '-');
        formattedName = formattedName.replace('|', '-');
        formattedName = formattedName.trim();
        return formattedName;
    }

    public String calculateURIWebService(InvocationData invocationData, IModuleFeedbackChannel feedback) throws SecurityException, IllegalArgumentException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, InvocationTargetException {
        String webService = (String)invocationData.get(TIBCO_CONSUMER_SERVICE);
        if (webService == null) {
            String transportUri = this.getURLWithOperation(invocationData, feedback);
            webService = transportUri.substring(transportUri.lastIndexOf("//") + 2);
            invocationData.put(TIBCO_CONSUMER_SERVICE, (Object)webService);
        }
        return WebServiceNameHelper.removeTrailingPipe(webService);
    }

    public static String removeTrailingPipe(String result) {
        if (result.endsWith(METRICSEPERATOR)) {
            return result.substring(0, result.length() - 1);
        }
        return result;
    }

    public Object analyzeTransportContext(Object requestExecutor, IModuleFeedbackChannel feedback) throws IllegalAccessException, SecurityException, NoSuchFieldException {
        if (transportContextField == null) {
            transportContextField = ReflectionUtils.getF_RequestExecutor_JakartaTransportContext(requestExecutor, feedback);
            transportContextField.setAccessible(true);
        }
        return transportContextField.get(requestExecutor);
    }

    private String getURLWithOperation(InvocationData data, IModuleFeedbackChannel feedback) throws SecurityException, IllegalAccessException, NoSuchFieldException, NoSuchMethodException, IllegalArgumentException, InvocationTargetException {
        String transportURI = (String)data.get(TIBCO_CONSUMER_URL);
        if (transportURI == null) {
            Object transportContextObject = this.analyzeTransportContext(data.getInvocationObject(), feedback);
            if (transportContextObject == null) {
                return UNKNOWN;
            }
            if (getTransportUriMethod == null) {
                getTransportUriMethod = transportContextObject.getClass().getMethod(GET_TRANSPORT_URI, EMPTYCLASSARRAY);
                getTransportUriMethod.setAccessible(true);
            }
            transportURI = getTransportUriMethod.invoke(transportContextObject, EMPTYOBJECTARRAY).toString();
            transportURI = transportURI.replace(':', '-');
            data.put(TIBCO_CONSUMER_URL, (Object)transportURI);
        }
        if (feedback.isDebugEnabled()) {
            feedback.debug("Detected URL: " + transportURI);
        }
        return WebServiceNameHelper.removeTrailingPipe(transportURI);
    }
}

