/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.metrics;

import com.wily.introscope.agent.api.DataRecorderFactory;
import com.wily.introscope.agent.api.IntCounterDataRecorder;
import com.wily.introscope.agent.api.StringEventDataRecorder;
import com.wily.powerpack.websphereMQ.agent.extensions.metrics.IMetric;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;

public final class ActivityReportMetric
implements IMetric {
    public static final int VALUE_STATUS_ID_ACTIVITYREPORT_ON = 0;
    public static final int VALUE_STATUS_ID_ACTIVITYREPORT_OFF = 1;
    public static final String VALUE_STATUS_MESSAGE_MQMONITORLIST_NOT_SET = new String("No MQMonitor agent is set in 'mqmonitor.mqagent.id.list' property. The MQ trace will remain always on.");
    public static final String VALUE_STATUS_MESSAGE_MQAGENTID_NOT_SET = new String("MQAgent id is not set in 'handshake.mqagent.id' property. The MQ trace will remain always off.");
    public static final String VALUE_STATUS_MESSAGE_PUT_OR_GET_INHIBITED = new String(String.valueOf(TraceProperties.HANDSHAKE_QUEUE_NAME_VALUE) + " queue is put/get inhibited.");
    public static final String VALUE_STATUS_MESSAGE_CONNECTION_FAILURE = new String(String.valueOf(TraceProperties.HANDSHAKE_QUEUE_NAME_VALUE) + " queue connection failed.");
    public static final String VALUE_STATUS_MESSAGE_ALL_QM_NOT_MONITORED = new String("All MQMonitor agents(s) are not running. Check if all MQMonitor agents with agentid given in MQAgent.properties are running.");
    public static final String VALUE_STATUS_MESSAGE_ALL_MQMONITOR_RUNNING = new String("All MQMonitors are running and monitoring all queue managers.");
    public static final String VALUE_STATUS_MESSAGE_INITIALIZATION = new String("Initializing...");
    public static final String VALUE_STATUS_MESSAGE_NOT_STARTED = new String("MQ trace process not started.");
    private int status_flag = 1;
    private String status_message = VALUE_STATUS_MESSAGE_INITIALIZATION;
    private static ActivityReportMetric instance = null;
    public static final String ROOT_METRIC_PATH = "Health|MQ Trace Handshake";
    public static final String METRIC_STATUS = "Health|MQ Trace Handshake:Handshake Status Value";
    public static final String METRIC_STATUS_MESSAGE = "Health|MQ Trace Handshake:Handshake Status";
    private static StringEventDataRecorder statusMessageRecorder = null;
    private static IntCounterDataRecorder statusFlagRecorder = null;

    private ActivityReportMetric() {
        try {
            this.createDataRecorder();
        }
        catch (Exception e) {
            MQPPLog.getLogger().error(MQPPLog.getModule(), "ActivityReportMetric" + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
    }

    private void createDataRecorder() {
        try {
            statusFlagRecorder = DataRecorderFactory.createIntCounterDataRecorder((String)METRIC_STATUS);
            statusMessageRecorder = DataRecorderFactory.createStringEventDataRecorder((String)METRIC_STATUS_MESSAGE);
        }
        catch (Exception e) {
            MQPPLog.getLogger().error(MQPPLog.getModule(), "ActivityReportMetric" + e.getMessage());
            MQPPLog.getLogger().debug((Throwable)e);
        }
    }

    private void updateMetricValues() {
        if (statusFlagRecorder.isRemoved() || statusFlagRecorder.isShutoff() || statusMessageRecorder.isRemoved() || statusMessageRecorder.isShutoff()) {
            this.createDataRecorder();
        }
        statusFlagRecorder.recordCurrentValue(this.status_flag);
        statusMessageRecorder.recordDataPoint(this.status_message);
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException e) {
            MQPPLog.getLogger().debug((Throwable)e);
        }
    }

    public static synchronized ActivityReportMetric getInstance() {
        if (instance == null) {
            instance = new ActivityReportMetric();
            new Thread(){

                @Override
                public void run() {
                    while (true) {
                        instance.updateMetricValues();
                    }
                }
            }.start();
        }
        return instance;
    }

    public void setMetric(int statusFlag, String statusMessage) {
        this.status_flag = statusFlag;
        this.status_message = statusMessage;
    }

    public int getStatusFlag() {
        return this.status_flag;
    }

    public String getStatusMessage() {
        return this.status_message;
    }
}

