/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.AAgentMetricArray;
import com.wily.introscope.agent.trace.cas.IBlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.BackendTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionElement;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.properties.AttributeListing;
import java.util.ArrayList;

public class MQBackendTracer
extends BackendTracer {
    private static final String kShouldComputeAggregatedMetricsKey = "computeaggregatedmetrics";
    private final boolean fShouldComputeAggregatedMetrics = this.calculateBooleanParameter("computeaggregatedmetrics", false);

    public MQBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public ITransactionElement getElementOnStartTrace(Object key, int tracerIndex, IStackElement dataElement, ITransactionElement parent) {
        InvocationData data = (InvocationData)dataElement;
        WilyTransactionElement result = (WilyTransactionElement)super.getElementOnStartTrace(key, tracerIndex, (IStackElement)data, parent);
        this.createBackendFullMetrics(tracerIndex, data, result);
        this.createBackendAggregatedMetrics(tracerIndex, data, result);
        return result;
    }

    protected void createCalledMetrics(int tracerIndex, InvocationData data, WilyTransactionElement result, IBlameTransactionElement previous) {
        String metricName = data.getComponentNameAt(tracerIndex);
        metricName = metricName.substring(0, metricName.indexOf("|", 10));
        String calledPrefix = MQBackendTracer.getCalledPrefix((IBlameTransactionElement)previous);
        ArrayList<AgentMetric> metricsForGrouping = new ArrayList<AgentMetric>();
        AgentMetric[] timerMetric = this.createTimerMetric(String.valueOf(calledPrefix) + this.getTimerMetricName(metricName));
        result.addMetric(timerMetric, result.getTimerRepository());
        metricsForGrouping.add(timerMetric[0]);
        AgentMetric[] perIntervalMetric = this.createPerIntervalMetric(String.valueOf(calledPrefix) + this.getPerIntervalMetricName(metricName));
        result.addMetric(perIntervalMetric, result.getPerIntervalRepository());
        metricsForGrouping.add(perIntervalMetric[0]);
        if (this.shouldForceStandardBlameMetrics()) {
            AgentMetric[] stallMetric = this.createStallsMetric(String.valueOf(calledPrefix) + this.getStallsMetricName(metricName));
            result.addMetric(stallMetric, result.getStallsRepository());
            metricsForGrouping.add(stallMetric[0]);
            AgentMetric[] errorMetric = this.createErrorsMetric(String.valueOf(calledPrefix) + this.getErrorsMetricName(metricName));
            result.addMetric(errorMetric, result.getErrorsRepository());
            metricsForGrouping.add(errorMetric[0]);
        }
        this.getAgent().IAgent_getMetricRecordingAdministrator().addMetricGroup(calledPrefix, metricsForGrouping);
    }

    private void createAdditionalMetricsWithSharedRepository(int tracerIndex, InvocationData data, String metricName, WilyTransactionElement result) {
        AgentMetric[] timerMetric = this.createTimerMetricBtc(this.getTimerMetricName(metricName));
        result.addMetric(timerMetric, result.getTimerRepository());
        AgentMetric[] perIntervalMetric = this.createPerIntervalMetricBtc(this.getPerIntervalMetricName(metricName));
        result.addMetric(perIntervalMetric, result.getPerIntervalRepository());
        if (this.shouldForceStandardBlameMetrics()) {
            AgentMetric[] stallMetric = this.createStallsMetricBtc(this.getStallsMetricName(metricName));
            result.addMetric(stallMetric, result.getStallsRepository());
            AgentMetric[] concurrentMetric = this.createConcurrentInvocationMetric(this.getConcurrentInvocationMetricName(metricName));
            IRepository concurrentSds = this.getSharedRepositoryNoSharedStructure(false);
            concurrentSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AAgentMetricArray)new AAgentMetricArray(concurrentMetric), (IRepository)concurrentSds);
            result.addConcurrentInvocation(concurrentSds);
            AgentMetric[] errorMetric = this.createErrorsMetricBtc(this.getErrorsMetricName(metricName));
            result.addMetric(errorMetric, result.getErrorsRepository());
        }
    }

    protected void createBackendFullMetrics(int tracerIndex, InvocationData data, WilyTransactionElement result) {
        String metricName = data.getComponentNameAt(tracerIndex);
        metricName = metricName.substring(0, metricName.lastIndexOf("|"));
        this.createAdditionalMetricsWithSharedRepository(tracerIndex, data, metricName, result);
    }

    protected void createBackendAggregatedMetrics(int tracerIndex, InvocationData data, WilyTransactionElement result) {
        if (this.fShouldComputeAggregatedMetrics) {
            String metricName = data.getComponentNameAt(tracerIndex);
            metricName = metricName.substring(0, metricName.indexOf("|", 10));
            this.createAdditionalMetricsWithSharedRepository(tracerIndex, data, metricName, result);
        }
    }

    public ITransactionElement getElementOnEndTrace(Object key, int tracerIndex, IStackElement dataElement, ITransactionElement parent) {
        InvocationData data = (InvocationData)dataElement;
        WilyTransactionElement result = (WilyTransactionElement)super.getElementOnEndTrace(key, tracerIndex, (IStackElement)data, parent);
        IBlameTransactionElement start = (IBlameTransactionElement)data.getStartCursorAt(tracerIndex);
        IBlameTransactionElement previous = start.getPreviousBlamePoint();
        String metricName = data.getComponentNameAt(tracerIndex);
        if (this.shouldForceStandardBlameMetrics()) {
            String backendMetricName = metricName.substring(0, metricName.lastIndexOf("|"));
            AgentMetric[] stallMetric = this.createStallsMetric(this.getStallsMetricName(backendMetricName));
            result.addMetric(stallMetric, result.getStallsRepository());
            if (previous != null) {
                String calledMetricName = metricName.substring(0, metricName.indexOf("|", 10));
                String calledPrefix = MQBackendTracer.getCalledPrefix((IBlameTransactionElement)previous);
                stallMetric = this.createStallsMetric(String.valueOf(calledPrefix) + this.getStallsMetricName(calledMetricName));
                result.addMetric(stallMetric, result.getStallsRepository());
            }
        }
        return result;
    }
}

