/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.websphereMQ.agent.extensions.tracer.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.FilterController;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.logger.MQPPLog;
import com.wily.powerpack.websphereMQ.agent.extensions.nameformatter.utils.MQClassLoaderUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerConstants;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.MQTransactionTracerUtil;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.TraceProperties;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryDataProcessor;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.discovery.MQDiscoveryDataWriter;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.HandshakeReader;
import com.wily.powerpack.websphereMQ.agent.extensions.tracer.handshake.Reflection;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class MQGetTransactionTracer
extends ASingleMetricTracerFactory
implements MQTransactionTracerConstants {
    private IModuleFeedbackChannel fLogger = MQPPLog.getLogger();
    public static final Module kModule = new Module("MQGetTransactionTracer");

    static {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        MQClassLoaderUtil.initialize(classloader);
        Reflection.initialise(classloader);
        if (TraceProperties.shouldStartDiscovery()) {
            MQDiscoveryDataProcessor.getInstance();
        }
    }

    public MQGetTransactionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fLogger.debug(kModule, "Inside MQGetTransactionTracer consutructor");
    }

    protected IDataAccumulator createDataAccumulator(String arg0) {
        return null;
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        this.fLogger.debug(kModule, "Inside ITracer_startTrace");
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        this.fLogger.debug(kModule, "Inside ITracer_finishTrace");
        try {
            int feedback;
            boolean traceOn = FilterController.shouldCurrentTraceBePropagated();
            Object mqMessage = data.getInvocationParameterAsObject(0);
            if (TraceProperties.shouldTraceMQSYSVIEW() && ((feedback = MQTransactionTracerUtil.getMQMessageFeedback(mqMessage)) == 99990001 || feedback == 99990000)) {
                MQTransactionTracerUtil.setMQMessageFeedback(mqMessage, 0);
            }
            if (traceOn) {
                Object object = data.getInvocationObject();
                Object handShakeQueue = HandshakeReader.getReadQueue();
                Object discoveryQueue = MQDiscoveryDataWriter.getWriteQueue();
                if (object != handShakeQueue && object != discoveryQueue) {
                    String queueName = MQTransactionTracerUtil.getQueueName(object);
                    String queueManagerName = MQTransactionTracerUtil.getQueueManagerName(object);
                    if (!MQTransactionTracerUtil.shouldExcludeQueue(queueManagerName, queueName)) {
                        if (MQTransactionTracerUtil.getMQReasonCode(object) != 2033) {
                            String messageID = MQTransactionTracerUtil.getMQMessageID(mqMessage);
                            String correlationID = MQTransactionTracerUtil.getMQCorrelationID(mqMessage);
                            MQTransactionTracerUtil.addCustomMQCorrelationParameter(mqMessage, data, null);
                            MQTransactionTracerUtil.addToCorrelation(this.getAgent(), messageID, correlationID, data);
                        }
                    } else {
                        this.fLogger.debug(kModule, String.valueOf(queueName) + " is in exclude list to avoid mq tracing");
                    }
                } else {
                    this.fLogger.debug(kModule, "Invocation object is Handshake queue, no MQ correlated transaction trace");
                }
            }
        }
        catch (Exception e) {
            this.fLogger.debug(kModule, e.getMessage(), (Throwable)e);
        }
    }
}

