/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.constants;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.personality.java.classfile.constants.DGConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import com.wily.diagnos.personality.java.classfile.constants.DGUtfDataTooLongException;
import com.wily.util.io.NullOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

class DGUtf8Constant
extends DGConstant {
    private String fString;

    public DGUtf8Constant(DGConstantPool constantPool, int index, String string) throws DGUtfDataTooLongException {
        super(constantPool, 1);
        this.fIndex = index;
        this.validateAndSetStringValue(string);
    }

    private void validateStringValue(String value) throws DGUtfDataTooLongException {
        try {
            DataOutputStream out = new DataOutputStream(new NullOutputStream());
            out.writeUTF(value);
        }
        catch (IOException iOException) {
            throw new DGUtfDataTooLongException();
        }
    }

    void validateAndSetStringValue(String value) throws DGUtfDataTooLongException {
        this.validateStringValue(value);
        this.fString = value;
    }

    DGUtf8Constant(DGConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool, 1);
        this.fString = in.readUTF();
    }

    @Override
    public void validate() throws DGClassLoadingException {
    }

    public String getString() {
        return this.fString;
    }

    public String toString() {
        return "# " + this.fIndex + ": Kind = UTF (" + this.fTag + ")\n" + "\tString = " + this.fString;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.fTag);
        out.writeUTF(this.fString);
    }
}

