/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ABundledTracerFactory;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.io.SocketMap;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;

public final class SocketAcceptMappingTracer
extends ABundledTracerFactory
implements ITracer {
    private final ReentrancyLevel fReentrancyLevel = this.calculateReentrancyLevel(ReentrancyLevel.kNone);

    public SocketAcceptMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (!(invocationObject instanceof ServerSocket)) {
            Assertion.wilyAssert("Instrumentation error: instrumented object is not a ServerSocket");
        }
        return this;
    }

    @Override
    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!data.hasMethodResultAvailable()) {
            Assertion.wilyAssert("Instrumentation error: no method result");
            return;
        }
        Object resultObject = data.getInvocationReturnValueAsObject();
        if (resultObject == null) {
            return;
        }
        if (!(resultObject instanceof Socket)) {
            Assertion.wilyAssert("Instrumentation error: method result is not a Socket");
            return;
        }
        Socket socket = (Socket)resultObject;
        ServerSocket serverSocket = (ServerSocket)data.getInvocationObject();
        InetSocketAddress localAddress = new InetSocketAddress(serverSocket.getLocalPort());
        SocketMap.put(serverSocket, this.getNameParameter(), localAddress, false);
        SocketMap.put(socket, this.getNameParameter(), localAddress, false);
    }

    @Override
    public final void ITracerFactory_releaseTracer(int tracerIndex, ITracer tracer) {
    }

    @Override
    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return this.fReentrancyLevel;
    }

    @Override
    public final boolean ITracerFactory_isShutoff() {
        return false;
    }
}

