/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.io;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.io.SocketFormatMetricsCache;
import com.wily.introscope.agent.trace.io.SocketMap;
import com.wily.introscope.agent.trace.io.SocketPerIntervalCounter;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.net.ServerSocket;
import java.net.Socket;

public final class SocketAcceptPerIntervalCounter
extends SocketPerIntervalCounter
implements ITracer {
    public SocketAcceptPerIntervalCounter(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public final ITracer ITracerFactory_allocateTracer(int tracerIndex, InvocationData data) {
        if (data.isSocketClamped()) {
            return null;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject instanceof ServerSocket) {
            return this;
        }
        Assertion.wilyAssert("Instrumentation error: instrumented object is not a ServerSocket");
        return null;
    }

    @Override
    protected final ILongIntervalCounterDataAccumulator createDataAccumulator(InvocationData data) {
        String formattedName;
        if (!data.hasMethodResultAvailable()) {
            Assertion.wilyAssert("Instrumentation error: no method result");
            return null;
        }
        Object resultObject = data.getInvocationReturnValueAsObject();
        if (resultObject == null) {
            return null;
        }
        if (!(resultObject instanceof Socket)) {
            Assertion.wilyAssert("Instrumentation error: method result is not a Socket");
            return null;
        }
        Socket socket = (Socket)resultObject;
        if (SocketMap.isRequired(socket, this.getAgent()) && (formattedName = this.quickFormat(data, this.getMetricPosition())) != null) {
            return this.createDataAccumulator(formattedName);
        }
        return null;
    }

    @Override
    protected int getMetricPosition() {
        return 3;
    }

    @Override
    protected void increaseCacheQuantity(SocketFormatMetricsCache cache) {
        cache.addToAcceptCounter();
    }
}

