/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.finder;

import com.wily.util.finder.IIndexedPropertiesFinder;
import com.wily.util.finder.IIndexedPropertiesFinderFeedback;
import com.wily.util.properties.IndexedProperties;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.io.InputStream;

public class EmbeddedResourceProfileFinder
implements IIndexedPropertiesFinder {
    private final IStringLocalizer fLocalizer;
    private final String fProfileFileName;
    private final String fProfileResourceLocationKey;
    private final Class fSourceLoaderClass;

    public EmbeddedResourceProfileFinder(IStringLocalizer local, String profileFileName, String profileResourceLocationKey) {
        this(local, profileFileName, profileResourceLocationKey, EmbeddedResourceProfileFinder.class);
    }

    public EmbeddedResourceProfileFinder(IStringLocalizer local, String profileFileName, String profileResourceLocationKey, Class sourceLoaderClass) {
        Assertion.wilyAssert(local != null);
        Assertion.wilyAssert(profileFileName != null);
        Assertion.wilyAssert(profileResourceLocationKey != null);
        Assertion.wilyAssert(sourceLoaderClass != null);
        this.fLocalizer = local;
        this.fProfileFileName = profileFileName;
        this.fProfileResourceLocationKey = profileResourceLocationKey;
        this.fSourceLoaderClass = sourceLoaderClass;
    }

    public IndexedProperties IIndexedPropertiesFinder_findProperties(IIndexedPropertiesFinderFeedback feedback) {
        IndexedProperties resultProps;
        block6: {
            resultProps = null;
            String statusMessage = "";
            try {
                statusMessage = this.fLocalizer.IStringLocalizer_getLocalizedString("Profile_Search_Resource_Loader_Attempt_Message");
                feedback.IIndexedPropertiesFinderFeedback_feedbackStatus(statusMessage);
                String resource = System.getProperty(this.fProfileResourceLocationKey);
                if (resource == null) {
                    resource = "/" + this.fSourceLoaderClass.getName() + "/";
                    resource = resource.replace('.', '/') + this.fProfileFileName;
                }
                try {
                    InputStream in = this.fSourceLoaderClass.getResourceAsStream(resource);
                    if (in != null) {
                        resultProps = new IndexedProperties();
                        resultProps.load(in);
                        in.close();
                        statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_Resource_Loader_Succeeded_Message", resource);
                        feedback.IIndexedPropertiesFinderFeedback_feedbackSuccess(statusMessage);
                        break block6;
                    }
                    statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_Resource_Loader_Resource_Not_Found_Message", resource);
                    feedback.IIndexedPropertiesFinderFeedback_feedbackFailure(statusMessage);
                    resultProps = null;
                }
                catch (Throwable t) {
                    statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_Resource_Loader_Failed_With_Name_Message", resource, t.getClass().getName(), t.getMessage());
                    feedback.IIndexedPropertiesFinderFeedback_feedbackFailure(statusMessage);
                    resultProps = null;
                }
            }
            catch (Throwable t2) {
                statusMessage = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Profile_Search_Resource_Loader_Failed_No_Name_Message", t2.getClass().getName(), t2.getMessage());
                feedback.IIndexedPropertiesFinderFeedback_feedbackFailure(statusMessage);
                resultProps = null;
            }
        }
        return resultProps;
    }
}

