/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.servletheaderdecorator;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.servletheaderdecorator.DecoratorBackendFeature;
import com.wily.introscope.agent.servletheaderdecorator.DecoratorBackendFeatureFactory;
import com.wily.introscope.agent.servletheaderdecorator.TrackedBackendInfo;
import com.wily.introscope.agent.servletheaderdecorator.TranInfoPayload;
import com.wily.introscope.agent.servletheaderdecorator.common.GUIDUtilsReflected;
import com.wily.introscope.agent.servletheaderdecorator.common.MutableInteger;
import com.wily.introscope.agent.servletheaderdecorator.common.PPSimpleTracer;
import com.wily.introscope.agent.servletheaderdecorator.common.SimpleMethodCache;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidParameterSpecException;
import java.util.Iterator;
import java.util.TreeSet;

public class ServletHeaderDecorator
extends PPSimpleTracer {
    private static final boolean g_kbDebugMsg = false;
    private static final String kstTranInfoParamName = "com.wily.decorator.traninfo";
    static final String kstAgentProfileProperty_Enabled = "introscope.agent.decorator.enabled";
    static final String kstAgentProfileProperty_Security = "introscope.agent.decorator.security";
    static final String kstDecoratorSecurity_Clear = "clear";
    static final String kstDecoratorSecurity_Base64 = "base64";
    static final String kstDecoratorSecurity_Encrypt1 = "encrypted";
    static final String kstDecoratorSecurity_Obfuscated = "obfuscated";
    public static final int kiMethod_getAttribute = 0;
    public static final int kiMethod_setAttribute = 1;
    public static final int kiMethod_IAgent_getName = 2;
    public static final int kiMethod_IAgent_getHostProcessAgentTriplet = 3;
    public static final int kiMethod_setHeader = 4;
    public static final int kiMethod_isCommitted = 5;
    public static final String[] methodNames = new String[]{"getAttribute", "setAttribute", "IAgent_getName", "IAgent_getHostProcessAgentTriplet", "setHeader", "isCommitted"};
    public static final String[] overrideClassName;
    private static boolean g_bInitialized;
    private static boolean g_bEnabled;
    private static int g_iSecurityMode;
    private static int g_iGetAgentNameState;
    private static ThreadLocal stackDepthLocal;
    public static final String kstTracerName = "ServletHeaderDecorator";
    String serverIp = null;

    static {
        String[] stringArray = new String[6];
        stringArray[0] = "javax.servlet.http.HttpServletRequest";
        stringArray[1] = "javax.servlet.http.HttpServletRequest";
        stringArray[4] = "javax.servlet.http.HttpServletResponse";
        stringArray[5] = "javax.servlet.http.HttpServletResponse";
        overrideClassName = stringArray;
        g_bInitialized = false;
        g_bEnabled = true;
        g_iSecurityMode = 2;
        m_methodCache = new SimpleMethodCache(methodNames.length, methodNames, overrideClassName);
        stackDepthLocal = new ThreadLocal(){

            public Object initialValue() {
                return new MutableInteger();
            }
        };
    }

    public ServletHeaderDecorator(IAgent agent, AttributeListing arg1, ProbeIdentification arg2, Object arg3) throws AgentNotAvailableException {
        super(agent, arg1, arg2, arg3);
    }

    @Override
    public String getTracerName() {
        return kstTracerName;
    }

    private void init(IAgent agent) {
        this.init_enabled(agent);
        if (!g_bEnabled) {
            return;
        }
        this.init_security(agent);
    }

    private void init_enabled(IAgent agent) {
        try {
            String enabledString = agent.IAgent_getIndexedProperties().getProperty(kstAgentProfileProperty_Enabled);
            if (enabledString == null || enabledString.length() == 0) {
                return;
            }
            g_bEnabled = Boolean.valueOf(enabledString);
        }
        catch (Exception e) {
            agent.IAgent_safeReportError("Decorator: " + this.getTracerName() + ": Could not check for global Decorator shutoff", (Throwable)e);
        }
    }

    private void init_security(IAgent agent) {
        try {
            String securityString = agent.IAgent_getIndexedProperties().getProperty(kstAgentProfileProperty_Security, kstDecoratorSecurity_Encrypt1);
            if (securityString == null || securityString.length() == 0) {
                return;
            }
            if (securityString.equals(kstDecoratorSecurity_Clear)) {
                g_iSecurityMode = 0;
            } else if (securityString.equals(kstDecoratorSecurity_Obfuscated)) {
                g_iSecurityMode = 1;
            } else if (securityString.equals(kstDecoratorSecurity_Base64)) {
                g_iSecurityMode = 3;
            } else if (securityString.equals(kstDecoratorSecurity_Encrypt1)) {
                g_iSecurityMode = 2;
            } else {
                agent.IAgent_safeReportError("Decorator: " + this.getTracerName() + ": Invalid Decorator security mode. Disabling Decorator.", null);
                g_bEnabled = false;
            }
        }
        catch (Exception e) {
            agent.IAgent_safeReportError("Decorator: " + this.getTracerName() + ": Could not get Decorator security mode. Disabling Decorator.", (Throwable)e);
            g_bEnabled = false;
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return false;
    }

    @Override
    public void ITracer_startTrace(int arg0, InvocationData invocationData) {
        if (!g_bInitialized) {
            this.init(this.getAgent());
        }
        if (!g_bEnabled) {
            return;
        }
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
        invocationData.storeWallClockStartTime();
        Object response = ServletHeaderDecorator.getParameter(invocationData, 1);
        TranInfoPayload infoPayload = new TranInfoPayload();
        Object request = ServletHeaderDecorator.getParameter(invocationData, 0);
        String guidString = GUIDUtilsReflected.findOrGenerateAndSetGuidWithReflection(request, response, invocationData);
        infoPayload.addParameter(0, guidString);
        try {
            this.setResponseHeader(response, infoPayload, invocationData, "x-wily-info");
            ComponentTracer componentTracer = this.getAgent().IAgent_getComponentTracer();
            IBlameStack stack = invocationData.getStack(componentTracer, false);
            componentTracer.addRootParameter(stack, "CorGUID", guidString);
            BTThreadLocalAdministrator.getInstance().insert("CorGUID", (Object)guidString);
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getAgent().IAgent_getModuleFeedback().error("SHD: " + this.getTracerName() + ": error in setting WilyInfo header", t);
        }
        TranInfoPayload servletPayload = new TranInfoPayload();
        servletPayload.setEncoding(g_iSecurityMode);
        ProbeIdentification pid = invocationData.getProbeInformation().getProbeIdentification();
        String servletName = pid.getRuntimeSimpleClassName();
        servletPayload.addParameter(3, servletName);
        try {
            if (this.serverIp == null) {
                this.serverIp = InetAddress.getLocalHost().getHostAddress();
            }
            servletPayload.addParameter(1, this.serverIp);
        }
        catch (UnknownHostException e) {
            this.getAgent().IAgent_getModuleFeedback().error("SHD: " + this.getTracerName() + ": Could not figure out my own IP", e);
        }
        if (g_iGetAgentNameState == 0) {
            boolean present_getTriplet = ServletHeaderDecorator.isMethodPresent(this.getAgent(), 3, kEmptyClassArray);
            boolean present_getName = ServletHeaderDecorator.isMethodPresent(this.getAgent(), 2, kEmptyClassArray);
            g_iGetAgentNameState = present_getTriplet ? 2 : (present_getName ? 1 : -1);
        }
        switch (g_iGetAgentNameState) {
            case 2: {
                String[] agentTriplet = (String[])ServletHeaderDecorator.getObjectResult(this.getAgent(), null, 3);
                if (agentTriplet == null) break;
                if (agentTriplet[0] != null && agentTriplet[0].length() > 0) {
                    servletPayload.addParameter(9, agentTriplet[0]);
                }
                if (agentTriplet[1] != null && agentTriplet[1].length() > 0) {
                    servletPayload.addParameter(10, agentTriplet[1]);
                }
                if (agentTriplet[2] == null || agentTriplet[2].length() <= 0) break;
                servletPayload.addParameter(2, agentTriplet[2]);
                break;
            }
            case 1: {
                String agentName = (String)ServletHeaderDecorator.getObjectResult(this.getAgent(), null, 2);
                if (agentName == null || agentName.length() <= 0) break;
                servletPayload.addParameter(2, agentName);
            }
        }
        invocationData.put(kstTranInfoParamName, (Object)servletPayload);
        try {
            this.setResponseHeader(response, servletPayload, invocationData, "x-wily-servlet");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getAgent().IAgent_getModuleFeedback().error("SHD: " + this.getTracerName() + ": error in setting WilyServlet header (startTrace)", t);
        }
    }

    @Override
    public void ITracer_finishTrace(int arg0, InvocationData invocationData) {
        if (!g_bEnabled) {
            return;
        }
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.dec();
        if (stackDepth.getValue() > 0) {
            return;
        }
        Object response = ServletHeaderDecorator.getParameter(invocationData, 1);
        TranInfoPayload payload = (TranInfoPayload)invocationData.get(kstTranInfoParamName);
        if (payload == null) {
            this.getAgent().IAgent_getModuleFeedback().error("SHD: " + this.getTracerName() + ": cannot fetch TranInfoPayload from invocationData.  This means startTrace and finishTrace aren't communicating properly.");
            return;
        }
        String servletResponseTime = String.valueOf(invocationData.getWallClockElapsedTimeAsInt());
        payload.addParameter(4, servletResponseTime);
        this.addBackends(payload);
        try {
            this.setResponseHeader(response, payload, invocationData, "x-wily-servlet");
        }
        catch (ThreadDeath td) {
            throw td;
        }
        catch (Throwable t) {
            this.getAgent().IAgent_getModuleFeedback().error("SHD: " + this.getTracerName() + ": error in setting WilyServlet header (finishTrace)", t);
        }
    }

    private void addBackends(TranInfoPayload payload) {
        StringBuilder backendListBuf = new StringBuilder();
        DecoratorBackendFeature decoFeature = DecoratorBackendFeatureFactory.getFeatureForCurrentThread();
        decoFeature.recordBackend();
        TreeSet backendSet = decoFeature.getTrackedBackends();
        if (backendSet != null) {
            Iterator iter = backendSet.iterator();
            boolean firstFlag = true;
            while (iter.hasNext()) {
                if (firstFlag) {
                    firstFlag = false;
                } else {
                    backendListBuf.append(',');
                }
                TrackedBackendInfo curElem = (TrackedBackendInfo)iter.next();
                backendListBuf.append(curElem.getHost());
                backendListBuf.append(':');
                backendListBuf.append(curElem.getPort());
            }
        }
        payload.addParameter(8, backendListBuf.toString());
    }

    private void setResponseHeader(Object response, TranInfoPayload payload, InvocationData invocationData, String headerName) throws Exception {
        Object[] argArray = new Object[2];
        Class[] argClassArray = new Class[2];
        argArray[0] = headerName;
        argClassArray[0] = String.class;
        argClassArray[1] = String.class;
        Object[] isCommittedArgArray = new Object[]{};
        Class[] isCommittedClassArray = new Class[]{};
        try {
            argArray[1] = payload.toPayloadString();
            Boolean isCommittedResult = ServletHeaderDecorator.invokeReturnsBoolean(response, invocationData, 5, isCommittedArgArray, isCommittedClassArray);
            if (!isCommittedResult.booleanValue()) {
                ServletHeaderDecorator.invokeReturnsVoid(response, invocationData, 4, argArray, argClassArray);
            }
        }
        catch (InvalidKeyException e) {
            AgentShim.handleError((String)(String.valueOf(this.getTracerName()) + ": Invalid key."), (Throwable)e);
        }
        catch (UnsupportedEncodingException e) {
            AgentShim.handleError((String)(String.valueOf(this.getTracerName()) + ": Unsupported encoding."), (Throwable)e);
        }
        catch (NoSuchAlgorithmException e) {
            AgentShim.handleError((String)(String.valueOf(this.getTracerName()) + ": No such algorithm.  Your JCE provider does not support the required algorithms.  Try clear text mode."), (Throwable)e);
        }
        catch (InvalidParameterSpecException e) {
            AgentShim.handleError((String)(String.valueOf(this.getTracerName()) + ": Invalid parameter spec."), (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            AgentShim.handleError((String)(String.valueOf(this.getTracerName()) + ": Invalid algorithm parameter."), (Throwable)e);
        }
        catch (Exception e) {
            String exceptionName = e.getClass().getName();
            if (exceptionName.equals("javax.crypto.BadPaddingException")) {
                AgentShim.handleError((String)(String.valueOf(this.getTracerName()) + ": Bad padding."), (Throwable)e);
            }
            if (exceptionName.equals("javax.crypto.IllegalBlockSizeException")) {
                AgentShim.handleError((String)(String.valueOf(this.getTracerName()) + ": Illegal block size."), (Throwable)e);
            }
            if (exceptionName.equals("javax.crypto.NoSuchPaddingException")) {
                AgentShim.handleError((String)(String.valueOf(this.getTracerName()) + ": No such padding.  Your JCE provider does not support the required padding.  Try clear text mode."), (Throwable)e);
            }
            throw e;
        }
    }
}

