/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.action.ExtendedActionException;
import com.wily.ui.action.IExtendedAction;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.awt.event.ActionEvent;
import java.util.EmptyStackException;
import java.util.Enumeration;
import java.util.Stack;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class ExtendedActionMonitor
implements KUICommonStringsKeys {
    private static final int kMaxUndoStackSize = 80;
    private Stack fUndoStack = new Stack();
    private Stack fRedoStack = new Stack();
    private Action fUndoAction;
    private Action fRedoAction;
    private String fUndoActionName;
    private String fRedoActionName;

    public ExtendedActionMonitor(IStringLocalizer stringLocalizer) {
        this.fUndoActionName = stringLocalizer.IStringLocalizer_getLocalizedString("Undo");
        this.fRedoActionName = stringLocalizer.IStringLocalizer_getLocalizedString("Redo");
        this.fUndoAction = new UndoAction(this.fUndoActionName);
        this.fRedoAction = new RedoAction(this.fRedoActionName);
        this.updateActionStates();
    }

    public synchronized void addExtendedAction(IExtendedAction action) {
        Assertion.wilyAssert(!action.IExtendedAction_wasCancelled(), "Cancelled actions should not be added to an action monitor");
        if (action != null) {
            int actionType = action.IExtendedAction_getActionType();
            switch (actionType) {
                case 2: {
                    this.clearUndoStack();
                    this.clearRedoStack();
                    this.updateActionStates();
                    break;
                }
                case 1: 
                case 3: {
                    this.fUndoStack.push(action);
                    this.clearRedoStack();
                    this.trimStackIfNecessary();
                    this.updateActionStates();
                }
            }
        }
    }

    public Action getUndoAction() {
        return this.fUndoAction;
    }

    public Action getRedoAction() {
        return this.fRedoAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void undo() {
        IExtendedAction action = (IExtendedAction)this.fUndoStack.pop();
        try {
            action.IExtendedAction_undoAction();
            this.fRedoStack.push(action);
        }
        catch (ExtendedActionException ae) {
            this.clearUndoStack();
        }
        catch (EmptyStackException ese) {
            Assertion.wilyAssert(false, "tried to undo on an empty stack");
        }
        finally {
            this.updateActionStates();
        }
    }

    IExtendedAction peekNextUndo() {
        return this.fUndoStack.empty() ? null : (IExtendedAction)this.fUndoStack.peek();
    }

    IExtendedAction peekNextRedo() {
        return this.fRedoStack.empty() ? null : (IExtendedAction)this.fRedoStack.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void redo() {
        IExtendedAction action = (IExtendedAction)this.fRedoStack.pop();
        try {
            action.IExtendedAction_redoAction();
            this.fUndoStack.push(action);
        }
        catch (ExtendedActionException ae) {
            this.clearRedoStack();
        }
        catch (EmptyStackException ese) {
            Assertion.wilyAssert(false, "tried to redo on an empty stack");
        }
        finally {
            this.updateActionStates();
        }
    }

    protected void trimStackIfNecessary() {
        if (this.fUndoStack.size() > 80) {
            IExtendedAction action = (IExtendedAction)this.fUndoStack.elementAt(0);
            action.IExtendedAction_tearDown();
            this.fUndoStack.removeElementAt(0);
        }
        Assertion.wilyAssert(this.fUndoStack.size() < 81);
    }

    private void clearUndoStack() {
        this.clearStack(this.fUndoStack);
    }

    private void clearRedoStack() {
        this.clearStack(this.fRedoStack);
    }

    private void clearStack(Stack stack) {
        Enumeration e = stack.elements();
        while (e.hasMoreElements()) {
            IExtendedAction action = (IExtendedAction)e.nextElement();
            action.IExtendedAction_tearDown();
        }
        stack.removeAllElements();
    }

    public void tearDownActionMonitor() {
        this.clearUndoStack();
        this.clearRedoStack();
    }

    protected synchronized void updateActionStates() {
        this.fUndoAction.setEnabled(this.fUndoStack.size() != 0);
        this.fRedoAction.setEnabled(this.fRedoStack.size() != 0);
        this.fUndoAction.putValue("Name", this.fUndoActionName + " " + this.getNextUndoActionName());
        this.fRedoAction.putValue("Name", this.fRedoActionName + " " + this.getNextRedoActionName());
    }

    public String getNextUndoActionName() {
        Action nextUndoAction = null;
        String undoActionName = null;
        if (this.fUndoStack.size() != 0) {
            nextUndoAction = (Action)this.fUndoStack.peek();
            undoActionName = (String)nextUndoAction.getValue("Name");
        }
        if (undoActionName == null) {
            undoActionName = "";
        }
        return undoActionName;
    }

    public String getNextRedoActionName() {
        Action nextRedoAction = null;
        String redoActionName = null;
        if (this.fRedoStack.size() != 0) {
            nextRedoAction = (Action)this.fRedoStack.peek();
            redoActionName = (String)nextRedoAction.getValue("Name");
        }
        if (redoActionName == null) {
            redoActionName = "";
        }
        return redoActionName;
    }

    private class RedoAction
    extends AbstractAction {
        private static final long serialVersionUID = -424215944586586912L;

        public RedoAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExtendedActionMonitor.this.redo();
        }
    }

    private class UndoAction
    extends AbstractAction {
        private static final long serialVersionUID = -5811781410303428552L;

        public UndoAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ExtendedActionMonitor.this.undo();
        }
    }
}

