/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.swing.layout.SimpleVerticalLayout;
import com.wily.wilyassert.Assertion;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Scrollable;

public class VerticalScrollingComponentPanel
extends JPanel {
    private static final long serialVersionUID = -636978931920875777L;
    private static final int kDefaultVisibleCount = 3;
    private final Component[] fComponents;
    private final int fVisibleCount;

    public VerticalScrollingComponentPanel(Component[] components) {
        this(components, 3);
    }

    public VerticalScrollingComponentPanel(Component[] components, int visibleCount) {
        Assertion.wilyAssert(components != null);
        Assertion.wilyAssert(components.length > 0);
        Assertion.wilyAssert(visibleCount > 0);
        this.fComponents = components;
        this.fVisibleCount = visibleCount;
        this.buildUI();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        ScrollablePanel panel = new ScrollablePanel();
        JScrollPane scrollPane = new JScrollPane(panel, 20, 31);
        this.add(scrollPane);
    }

    private final class ScrollablePanel
    extends JPanel
    implements Scrollable {
        private static final long serialVersionUID = -3653744348341666361L;
        private final int fScrollableUnitHeight;

        public ScrollablePanel() {
            super(new SimpleVerticalLayout(0, 0));
            for (int i = 0; i < VerticalScrollingComponentPanel.this.fComponents.length; ++i) {
                this.add(VerticalScrollingComponentPanel.this.fComponents[i]);
            }
            this.fScrollableUnitHeight = ((VerticalScrollingComponentPanel)VerticalScrollingComponentPanel.this).fComponents[0].getPreferredSize().height;
        }

        public Dimension getPreferredScrollableViewportSize() {
            return new Dimension(this.getPreferredSize().width, this.fScrollableUnitHeight * VerticalScrollingComponentPanel.this.fVisibleCount);
        }

        public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return visibleRect.width / 10;
            }
            Assertion.wilyAssert(orientation == 1);
            return this.fScrollableUnitHeight;
        }

        public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
            if (orientation == 0) {
                return visibleRect.width;
            }
            Assertion.wilyAssert(orientation == 1);
            return this.getScrollableUnitIncrement(visibleRect, orientation, direction) * VerticalScrollingComponentPanel.this.fVisibleCount;
        }

        public boolean getScrollableTracksViewportHeight() {
            return false;
        }

        public boolean getScrollableTracksViewportWidth() {
            return false;
        }
    }
}

