/*
 * Decompiled with CFR 0.152.
 */
package com.wily.powerpack.webservices.extension.agent.trace.correlation;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.powerpack.webservices.KConstants;
import com.wily.powerpack.webservices.WSMUtils;
import com.wily.util.clock.MasterClock;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CXFClientCorrelationProxy
implements KConstants {
    private static volatile Class clsSoapHeader = null;
    private static volatile Constructor constrSoapHeader = null;
    private static final QName kCOR_HEADER_QNAME = new QName("http://www.ca.com/apm", "WSCorIDSOAPHeader");

    public void populateRequestContext(InvocationData data, boolean isAsync) {
        try {
            Object objClientProxy = data.getInvocationObject();
            Object objClient = WSMUtils.invokeMethodOnObject(objClientProxy, "getClient");
            Map mapRequestContext = (Map)WSMUtils.invokeMethodOnObject(objClient, "getRequestContext");
            mapRequestContext.put("com.wily.cxf.jaxws.client.isAsync", isAsync);
            data.put("com.wily.cxf.jaxws.client.isAsync", (Object)isAsync);
            WSMUtils.refreshLogLevels();
            boolean isDebugEnabled = WSMUtils.getLogger().isDebugEnabled();
            String debugPrefix = "[" + Thread.currentThread() + "]CXFClientCorrelationProxy ";
            if (isDebugEnabled) {
                WSMUtils.getLogger().debug(String.valueOf(debugPrefix) + "mapRequestContext(" + this.debug_getObjectId(mapRequestContext) + ")=" + mapRequestContext);
            }
            boolean isHTTPInsertionEnabled = WSMUtils.correlationHTTPInsertionEnabled();
            this.addCorrelationInfoToHttpHeaders(mapRequestContext, isHTTPInsertionEnabled);
            if (WSMUtils.correlationSOAPInsertionEnabled()) {
                ArrayList lstHeaders;
                Class<?> clsDomUtils = this.invokeClassForName("org.apache.cxf.helpers.DOMUtils", objClientProxy);
                Document document = (Document)WSMUtils.invokeMethodOnClass(clsDomUtils, "createDocument");
                Element elemWSSoapHeader = document.createElementNS("http://www.ca.com/apm", "WSCorIDSOAPHeader");
                String corrId = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
                if (isDebugEnabled) {
                    WSMUtils.getLogger().debug(String.valueOf(debugPrefix) + "correlationSOAPInsertionEnabled corrId=" + corrId);
                }
                elemWSSoapHeader.setAttribute("CorID", corrId);
                if (constrSoapHeader == null) {
                    clsSoapHeader = this.invokeClassForName("org.apache.cxf.binding.soap.SoapHeader", objClientProxy);
                    constrSoapHeader = clsSoapHeader.getDeclaredConstructor(QName.class, Object.class);
                }
                Object objWSSoapHeader = constrSoapHeader.newInstance(kCOR_HEADER_QNAME, elemWSSoapHeader);
                List oldLstHeaders = (List)mapRequestContext.get("org.apache.cxf.headers.Header.list");
                int clearOldHeaders = WSMUtils.cxfClearOldHeaders();
                if (oldLstHeaders == null || clearOldHeaders == 2) {
                    if (isDebugEnabled) {
                        WSMUtils.getLogger().debug(String.valueOf(debugPrefix) + "creating new header list");
                    }
                    lstHeaders = new ArrayList();
                } else {
                    lstHeaders = new ArrayList(oldLstHeaders);
                    if (clearOldHeaders == 1) {
                        int i = 0;
                        while (i < lstHeaders.size()) {
                            Object objHeader = lstHeaders.get(i);
                            Object currentQName = WSMUtils.invokeMethodOnObject(objHeader, "getName");
                            String namespace = (String)WSMUtils.invokeMethodOnObject(currentQName, "getNamespaceURI");
                            if (namespace.equals(kCOR_HEADER_QNAME.getNamespaceURI())) {
                                if (isDebugEnabled) {
                                    WSMUtils.getLogger().debug(String.valueOf(debugPrefix) + "removing old wily header " + i + ": " + objHeader);
                                }
                                lstHeaders.remove(objHeader);
                                --i;
                            }
                            ++i;
                        }
                    }
                }
                lstHeaders.add(objWSSoapHeader);
                if (isDebugEnabled) {
                    WSMUtils.getLogger().debug(String.valueOf(debugPrefix) + "replacing header list old(" + this.debug_getObjectId(oldLstHeaders) + ") with " + "new(" + this.debug_getObjectId(lstHeaders) + ")=" + lstHeaders);
                }
                mapRequestContext.put("org.apache.cxf.headers.Header.list", lstHeaders);
            }
            if (isAsync) {
                String corId = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
                if (isDebugEnabled) {
                    WSMUtils.getLogger().debug(String.valueOf(debugPrefix) + "isAsync corId=" + corId);
                }
                data.put("com.wily.cxf.jaxws.corId", (Object)corId);
                mapRequestContext.put("com.wily.cxf.jaxws.corId", corId);
                long startTime = MasterClock.currentTimeMillis();
                mapRequestContext.put("com.wily.cxf.jaxws.client.starttime", startTime);
            }
        }
        catch (Exception e) {
            try {
                WSMUtils.handleException(WSMUtils.getAgent(), "CXFClientCorrelationProxy populateRequestContext", e);
            }
            catch (Exception ae) {
                WSMUtils.getLogger().info("CXFClientCorrelationProxy handleException failed" + ae);
            }
        }
    }

    private String debug_getObjectId(Object object) {
        return Integer.toHexString(System.identityHashCode(object));
    }

    protected void addCorrelationInfoToHttpHeaders(Map requestContext, boolean isHTTPInsertionEnabled) throws Exception {
        if (isHTTPInsertionEnabled) {
            String corrId = new CorrelationId().getOutgoingCorrelationIdStrippedForHeader();
            WSMUtils.getLogger().debug("CXFClientCorrelationProxy addCorrelationInfoToHttpHeaders correlationHTTPInsertionEnabled corrId=" + corrId);
            ArrayList<String> lstCorId = new ArrayList<String>();
            lstCorId.add(corrId);
            HashMap<String, ArrayList<String>> protocolHeaders = (HashMap<String, ArrayList<String>>)requestContext.get("org.apache.cxf.message.Message.PROTOCOL_HEADERS");
            if (protocolHeaders == null) {
                WSMUtils.getLogger().debug("CXFClientCorrelationProxy.addCorrelationInfoToHttpHeaders: protocolHeaders is null");
                protocolHeaders = new HashMap<String, ArrayList<String>>();
                requestContext.put("org.apache.cxf.message.Message.PROTOCOL_HEADERS", protocolHeaders);
            } else {
                List soapAction = (List)protocolHeaders.get("SOAPAction");
                if (soapAction == null || soapAction.isEmpty()) {
                    WSMUtils.getLogger().debug("CXFClientCorrelationProxy.addCorrelationInfoToHttpHeaders: SOAPAction not found in PROTOCOL_HEADERS.");
                } else {
                    WSMUtils.getLogger().debug("CXFClientCorrelationProxy.addCorrelationInfoToHttpHeaders: remove from PROTOCOL_HEADERS: SOAPAction=" + soapAction);
                    protocolHeaders.remove("SOAPAction");
                }
            }
            protocolHeaders.put("CorID", lstCorId);
        }
    }

    protected Class<?> invokeClassForName(String className, Object instrumentedObj) {
        Class<?> clazz = null;
        try {
            try {
                clazz = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    clazz = Class.forName(className, false, instrumentedObj.getClass().getClassLoader());
                }
                catch (Exception e) {
                    WSMUtils.getLogger().error("Cannot access class: " + className + " for SOAP correlation.");
                    if (WSMUtils.getLogger().isDebugEnabled()) {
                        WSMUtils.getLogger().debug("Cannot access class: " + className, (Throwable)e);
                    }
                }
            }
        }
        catch (Throwable throwable) {}
        return clazz;
    }
}

