/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.agent.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.soaextension.webmethods.services.ServiceFilter;
import com.wily.soaextension.webmethods.util.WMUtils;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.Method;
import java.net.URL;

public class HttpUrlConnectionTracer
extends ASingleInstanceTracerFactory {
    public HttpUrlConnectionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_finishTrace(int arg0, InvocationData data) {
        try {
            Object objIsExcludedService = data.get("is-excluded-service");
            if (objIsExcludedService != null && objIsExcludedService.equals("Y")) {
                data.get("excluded-service-name");
                return;
            }
            Object objUrlConnection = data.getInvocationReturnValueAsObject();
            Method mthSetReqProps = objUrlConnection.getClass().getMethod("setRequestProperty", String.class, String.class);
            WMUtils.getLogger().debug("START:HttpUrlConnectionTracer.threadID:" + Thread.currentThread().getId() + "[" + Thread.currentThread().getName() + "]CorId:" + this.getComponentTracer().getCrossProcessDataCache().getCorrelationID());
            String strCorrelationId = new CorrelationId().getCurrentOutgoingCorrelationIdStrippedForHeader();
            WMUtils.getLogger().debug("END:HttpUrlConnectionTracer.threadID:" + Thread.currentThread().getId() + "[" + Thread.currentThread().getName() + "]CorId:" + this.getComponentTracer().getCrossProcessDataCache().getCorrelationID());
            mthSetReqProps.invoke(objUrlConnection, "CorID", strCorrelationId);
        }
        catch (Exception e) {
            WMUtils.getLogger().error(e.getMessage());
            WMUtils.getLogger().debug((Throwable)e);
        }
    }

    public void ITracer_startTrace(int arg0, InvocationData data) {
        try {
            URL httpUrl = (URL)data.getInvocationParameterAsObject(0);
            String name = httpUrl.getPath();
            int lastIndex = name.lastIndexOf("/");
            String serviceLastName = name.substring(lastIndex + 1, name.length());
            String serviceName1 = name.substring(0, lastIndex);
            int lastIndex2 = serviceName1.lastIndexOf("/");
            String strServiceName = String.valueOf(serviceName1.substring(lastIndex2 + 1, serviceName1.length())) + ":" + serviceLastName;
            if (strServiceName != null && !ServiceFilter.isServiceInteresting(strServiceName.toString(), null)) {
                data.put("is-excluded-service", (Object)"Y");
                data.put("excluded-service-name", (Object)strServiceName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public boolean ITracerFactory_isShutoff() {
        return false;
    }
}

