/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.messaging.tracers;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.hc2.FrontendTracer;
import com.wily.introscope.agent.util.ReflectionUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.reflect.InvocationTargetException;

public class UMJmsListenerTracer
extends FrontendTracer {
    private IModuleFeedbackChannel feedback = null;
    private final Module module = new Module("UMJmsListenerTracer");
    private static final String UM_CORRELATION_PROCESSING_ENABLED = "um.correlation.processing.enabled";

    public UMJmsListenerTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = this.getAgent().IAgent_getModuleFeedback();
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        Object msg = data.getInvocationParameterAsObject(0);
        String jmsDestination = null;
        String umDestinationName = null;
        try {
            if (msg != null && (umDestinationName = this.getUMDestinationName(data)) != null && (jmsDestination = (String)ReflectionUtils.invokeMethodOnObject((Object)msg, (String)"getJMSDestination", (boolean)true, (IModuleFeedbackChannel)this.feedback)) == null) {
                if (this.feedback.isDebugEnabled(this.module)) {
                    this.feedback.debug(this.module, "JMS Destination is null , So processing Correlation");
                }
                super.ITracer_startTrace(tracerIndex, data);
                data.put(UM_CORRELATION_PROCESSING_ENABLED, (Object)true);
            }
        }
        catch (Exception e) {
            this.feedback.error(this.module, "Error getting correlation information in UMIncomingCorrelationTracer: " + e.getMessage());
            this.feedback.debug(this.module, e.getMessage(), (Throwable)e);
        }
    }

    private String getUMDestinationName(InvocationData data) throws NoSuchMethodException, SecurityException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        String destName = null;
        Object msg = data.getInvocationParameterAsObject(0);
        destName = (String)ReflectionUtils.invokeMethodOnObject((Object)msg, (String)"getStringProperty", (Class[])new Class[]{String.class}, (Object[])new Object[]{"CA_APM_UM_DESTINATION_NAME"});
        return destName;
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.get(UM_CORRELATION_PROCESSING_ENABLED) != null && data.get(UM_CORRELATION_PROCESSING_ENABLED) == Boolean.TRUE) {
            super.ITracer_finishTrace(tracerIndex, data);
        }
    }
}

