/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.soa.wm.tn.agent.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.ICacheableBlameKeyNameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.cas.IBlameComponent;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.soa.wm.tn.agent.util.WmCache;
import com.wily.util.StringUtils;
import com.wily.util.feedback.IModuleFeedbackChannel;

public class BizDocTypeNameFormatter
implements ICacheableBlameKeyNameFormatter {
    public static final String kDocTypeNamePlaceHolder = "{doctypename}";
    public static final String kDocTypeNameRegex = "\\{doctypename\\}";
    public static final char[] kIllegalResourceChars = new char[]{':'};
    public static final char kResourceReplacementChar = '_';
    protected final IAgent fAgent;
    protected final IModuleFeedbackChannel logger;

    public BizDocTypeNameFormatter(IAgent agent) {
        this.fAgent = agent;
        this.logger = this.fAgent.IAgent_getModuleFeedback();
    }

    public String INameFormatter_format(String name, InvocationData data) {
        try {
            String strDocTypeName = this.getDocumentType(data);
            if (name.indexOf(kDocTypeNamePlaceHolder, 0) >= 0) {
                strDocTypeName = BizDocTypeNameFormatter.formatToBeResourceSafe(strDocTypeName);
                this.logger.debug("IN BizDocTypeNameFormatter.INameFormatter_format()BEFORE name is " + name);
                name = name.replaceAll(kDocTypeNameRegex, strDocTypeName);
                this.logger.debug("IN BizDocTypeNameFormatter.INameFormatter_format()AFTER name is " + name);
            }
            WmCache.setDocumentName(strDocTypeName);
            WmCache.setDocumentType(this.getClassname(data));
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        return name;
    }

    private String getDocumentType(InvocationData data) {
        String strDocTypeName = null;
        try {
            Object obj = data.getInvocationObject();
            Object objDoctypeName = obj.getClass().getMethod("get", Integer.TYPE).invoke(obj, 1);
            if (objDoctypeName != null) {
                strDocTypeName = objDoctypeName.toString();
            }
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
        }
        if (strDocTypeName == null) {
            strDocTypeName = "UnknownDocumentTypeName";
        }
        return strDocTypeName;
    }

    private String getClassname(InvocationData data) {
        Object obj = data.getInvocationObject();
        return obj.getClass().getSimpleName();
    }

    public static String formatToBeResourceSafe(String value) {
        return StringUtils.replaceIllegalChars((String)value, (char[])kIllegalResourceChars, (char)'_');
    }

    public Object getObjectKey(IModuleFeedbackChannel imodulefeedbackchannel, int i, InvocationData invocationdata) {
        return null;
    }

    public IBlameComponent getKey(IModuleFeedbackChannel imodulefeedbackchannel, String name, InvocationData data) {
        try {
            return ABlameComponent.getArrayInstance((Object[])new Object[]{name, this.getClassname(data), this.getDocumentType(data)});
        }
        catch (Exception e) {
            this.logger.error(e.getMessage());
            return null;
        }
    }
}

