/*
 * Decompiled with CFR 0.152.
 */
package com.wily.soaextension.webmethods.services;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.soaextension.webmethods.util.WMUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class ServiceFilter {
    private static String strDEFAULT_INCLUDE_SERVICES = "wm.tn:receive,wm.tn.route:routeBizdoc,pub.prt.tn:handleBizDoc";
    private static final int MAX_CACHE_ENTRIES = 1000;
    private static List filterPatterns;
    private static String configFileLoc;
    private static IAgent agent;
    private static final Map cache;

    static {
        configFileLoc = null;
        agent = null;
        cache = new LinkedHashMap(1001, 0.75f, true){

            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 1000;
            }
        };
        List tempfilterPatterns = null;
        try {
            agent = AgentShim.getAgent();
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        try {
            if (agent != null) {
                String[] filtersArr = null;
                File filterDir = null;
                File wmExtensionConfigFile = null;
                configFileLoc = ServiceFilter.getConfigFileLoc();
                if (configFileLoc != null) {
                    WMUtils.getLogger().debug("ServiceFilter::Got Filter Config file path as:" + configFileLoc);
                }
                if ((filterDir = new File(configFileLoc)) != null && filterDir.exists() && filterDir.isDirectory()) {
                    wmExtensionConfigFile = new File(filterDir, "wmExtension.config");
                }
                WMUtils.getLogger().info("Loading filters for WebMethods services from \"wmExtension.config\" at " + filterDir.getAbsolutePath());
                filtersArr = ServiceFilter.loadFiltersFromFile(wmExtensionConfigFile);
                if (filtersArr == null || filtersArr.length == 0) {
                    WMUtils.getLogger().info("No filter found, showing every WebMethods service");
                } else {
                    tempfilterPatterns = ServiceFilter.getPatterns(filtersArr);
                }
            }
            filterPatterns = tempfilterPatterns;
        }
        catch (Exception bomb) {
            WMUtils.getLogger().error("Error in Service Filter:" + bomb.getMessage());
        }
    }

    public static String getConfigFileLoc() {
        String fileLoc = System.getProperty("com.wily.wm.service.filter.fileloc");
        if (fileLoc == null || fileLoc.length() == 0) {
            fileLoc = WMUtils.getConfigFilePath();
        }
        return fileLoc;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String[] loadFiltersFromFile(File configFile) {
        String[] filterArr = null;
        if (configFile != null && configFile.exists() && configFile.isFile()) {
            FileInputStream inStream = null;
            Properties props = null;
            String filter = null;
            try {
                inStream = new FileInputStream(configFile);
                props = new Properties();
                props.load(inStream);
                filter = props.getProperty("com.wily.wm.service.filter.exclude");
                WMUtils.getLogger().info("ServiceFilter::Got filter as:" + filter);
                if (filter != null && filter.equals("")) {
                    WMUtils.getLogger().debug("Could not find a valid filter property in wmExtension.config");
                }
                if (filter != null || !filter.equals("") || filter.trim().length() != 0) {
                    filterArr = filter.trim().split("\\s*,\\s*");
                }
                strDEFAULT_INCLUDE_SERVICES = props.getProperty("com.wily.wm.service.include", "wm.tn:receive,wm.tn.route:routeBizdoc,pub.prt.tn:handleBizDoc");
                ServiceFilter.setInterestingServices(strDEFAULT_INCLUDE_SERVICES, Boolean.TRUE);
                String strDEFAULT_EXCLUDE_SERVICES = props.getProperty("com.wily.wm.service.exclude");
                if (strDEFAULT_EXCLUDE_SERVICES == null) {
                    strDEFAULT_EXCLUDE_SERVICES = "wm.tn.polling:localCheck,wm.tn.polling:remoteCheck,wm.server:connect,wm.server:disconnect,wm.server:ping,pub.event.stats:logToFile";
                }
                ServiceFilter.setInterestingServices(strDEFAULT_EXCLUDE_SERVICES, Boolean.FALSE);
                WMUtils.getLogger().info("These services [" + strDEFAULT_EXCLUDE_SERVICES + "] are excluded by default");
            }
            catch (IOException e) {
                WMUtils.getLogger().error("Error in reading Service Filter config file:" + e.getMessage());
                if (inStream == null) return filterArr;
                try {
                    inStream.close();
                    return filterArr;
                }
                catch (IOException iOException) {}
                return filterArr;
            }
            catch (Exception bomb) {
                try {
                    WMUtils.getLogger().error("Error in Service Filter:" + bomb.getMessage());
                    bomb.printStackTrace();
                    if (inStream == null) return filterArr;
                }
                catch (Throwable throwable) {
                    if (inStream == null) throw throwable;
                    try {
                        inStream.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    inStream.close();
                    return filterArr;
                }
                catch (IOException iOException) {}
                return filterArr;
            }
            if (inStream == null) return filterArr;
            try {
                inStream.close();
                return filterArr;
            }
            catch (IOException iOException) {}
            return filterArr;
        }
        WMUtils.getLogger().error("No Config file exists at this location");
        return filterArr;
    }

    private static final void setInterestingServices(String serviceNames, Boolean enable) {
        if (serviceNames != null && serviceNames.trim().length() > 0) {
            StringTokenizer serviceTokens = new StringTokenizer(serviceNames, ",");
            while (serviceTokens.hasMoreTokens()) {
                cache.put(serviceTokens.nextToken(), enable);
            }
        }
    }

    public static List getPatterns(String[] filters) {
        List<Pattern> tempPatterns = new ArrayList(filters.length);
        int i = 0;
        while (i < filters.length) {
            String f = filters[i];
            if ((f = f.trim()).length() > 0) {
                try {
                    Pattern p = Pattern.compile(f);
                    tempPatterns.add(p);
                }
                catch (PatternSyntaxException patternSyntaxException) {
                    WMUtils.getLogger().warn("Invalid filter value \"" + f + "\" found for property: \"" + "com.wily.wm.service.filter.exclude" + "\"");
                }
            }
            ++i;
        }
        if (tempPatterns != null) {
            tempPatterns = Collections.unmodifiableList(tempPatterns);
        }
        return tempPatterns;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isServiceInteresting(String serviceName, List lstPatterns) {
        if (lstPatterns != null) {
            filterPatterns = lstPatterns;
        }
        if (filterPatterns == null) {
            return true;
        }
        boolean temp = false;
        boolean isReqd = false;
        try {
            Class<ServiceFilter> clazz = ServiceFilter.class;
            synchronized (ServiceFilter.class) {
                if (serviceName != null && serviceName.length() > 0) {
                    Boolean valueFromCache = (Boolean)cache.get(serviceName);
                    if (valueFromCache == null) {
                        Iterator iter = filterPatterns.iterator();
                        while (!temp && iter.hasNext()) {
                            Pattern p = (Pattern)iter.next();
                            temp = p.matcher(serviceName).matches();
                        }
                        boolean bl = isReqd = !temp;
                        if (isReqd) {
                            cache.put(serviceName, Boolean.TRUE);
                        } else {
                            cache.put(serviceName, Boolean.FALSE);
                        }
                    } else {
                        isReqd = valueFromCache;
                    }
                }
                // ** MonitorExit[var4_4] (shouldn't be in output)
            }
        }
        catch (Throwable bomb) {
            WMUtils.getLogger().error("Error in Service Filter:" + bomb.getMessage());
        }
        {
            return isReqd;
        }
    }
}

