/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.locale;

import com.wily.util.locale.LocaleUtils;
import com.wily.utilities.properties.Messages;
import java.io.File;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;

public class LocaleHttpUtils {
    public static final String LOCALE_TEST_PARAM = "_LOCALETEST_";

    public static String getLocaleSpecificFolder(HttpServletRequest request, File dir) {
        String serverLocale;
        if (dir == null) {
            return "";
        }
        if (request != null) {
            String clientLocale = LocaleHttpUtils.getClientLocale(request);
            if (LocaleUtils.isBaseLocale(clientLocale)) {
                return "";
            }
            if (LocaleHttpUtils.folderExists(dir, clientLocale)) {
                return clientLocale;
            }
        }
        if (LocaleUtils.isBaseLocale(serverLocale = LocaleHttpUtils.getServerLocale())) {
            return "";
        }
        if (LocaleHttpUtils.folderExists(dir, serverLocale)) {
            return serverLocale;
        }
        return "";
    }

    public static String getLocaleSpecificFolder(HttpServletRequest request, String baseURL, String file) {
        String serverLocale;
        if (baseURL == null || baseURL.equals("")) {
            return "";
        }
        if (file == null) {
            file = "";
        }
        if (!file.equals("") && !file.startsWith("/")) {
            file = String.valueOf('/') + file;
        }
        if (request != null) {
            String clientLocale = LocaleHttpUtils.getClientLocale(request);
            if (LocaleUtils.isBaseLocale(clientLocale)) {
                return "";
            }
            if (LocaleHttpUtils.urlExists(String.valueOf(baseURL) + '/' + clientLocale + file)) {
                return clientLocale;
            }
        }
        if (LocaleUtils.isBaseLocale(serverLocale = LocaleHttpUtils.getServerLocale())) {
            return "";
        }
        if (LocaleHttpUtils.urlExists(String.valueOf(baseURL) + '/' + serverLocale + file)) {
            return serverLocale;
        }
        return "";
    }

    public static String getLocaleSpecificURL(HttpServletRequest request, String defaultURL) {
        String serverLocale;
        if (defaultURL == null || defaultURL.equals("")) {
            return defaultURL;
        }
        String urlPrefix = defaultURL.substring(0, defaultURL.lastIndexOf(46));
        String urlPostfix = defaultURL.substring(defaultURL.lastIndexOf(46), defaultURL.length());
        if (request != null) {
            String clientLocale = LocaleHttpUtils.getClientLocale(request);
            if (LocaleUtils.isBaseLocale(clientLocale)) {
                return defaultURL;
            }
            String clientURL = String.valueOf(urlPrefix) + '_' + clientLocale + urlPostfix;
            if (LocaleHttpUtils.urlExists(clientURL)) {
                return clientURL;
            }
        }
        if (LocaleUtils.isBaseLocale(serverLocale = LocaleHttpUtils.getServerLocale())) {
            return defaultURL;
        }
        String serverURL = String.valueOf(urlPrefix) + '_' + serverLocale + urlPostfix;
        if (LocaleHttpUtils.urlExists(serverURL)) {
            return serverURL;
        }
        return defaultURL;
    }

    public static boolean urlExists(String urlPath) {
        try {
            HttpURLConnection conn = (HttpURLConnection)new URL(String.valueOf(urlPath) + "?" + LOCALE_TEST_PARAM + "=1").openConnection();
            conn.setRequestMethod("HEAD");
            int responseCode = conn.getResponseCode();
            return responseCode == 200;
        }
        catch (Exception exception) {
            return false;
        }
    }

    private static boolean folderExists(File dir, String locale) {
        File localeDir = new File(dir, locale);
        return localeDir != null && localeDir.exists();
    }

    private static String getClientLocale(HttpServletRequest request) {
        Locale locale = request.getLocale();
        if (locale == null) {
            return null;
        }
        return locale.getLanguage();
    }

    public static Locale getResponseLocale(Locale locale) {
        String keyStrEngLocale;
        String keyStrLocale = Messages.getString(locale, "Locale_Test_Message");
        if (!keyStrLocale.equalsIgnoreCase(keyStrEngLocale = Messages.getString(LocaleUtils.getFallbackLocale(), "Locale_Test_Message"))) {
            return locale;
        }
        return LocaleUtils.getFallbackLocale();
    }

    private static String getServerLocale() {
        return Locale.getDefault().getLanguage();
    }
}

