/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.filemonitor;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public abstract class AZipEntryChange
implements Serializable,
Externalizable {
    private static final long serialVersionUID = 1L;
    private String fileName;

    public AZipEntryChange() {
    }

    private AZipEntryChange(String fileName) {
        this.fileName = fileName;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeUTF(this.fileName);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException {
        this.fileName = oi.readUTF().intern();
    }

    public static AZipEntryChange getDeletionEntry(String fileName) {
        return new ZipEntryDelete(fileName);
    }

    public static AZipEntryChange getAdditionEntry(String fileName) {
        return new ZipEntryAdd(fileName);
    }

    public static AZipEntryChange getModificationEntry(String fileName) {
        return new ZipEntryModify(fileName);
    }

    public String getFileSpec() {
        return this.fileName;
    }

    public boolean isAdd() {
        return false;
    }

    public boolean isModify() {
        return false;
    }

    public boolean isDelete() {
        return false;
    }

    /* synthetic */ AZipEntryChange(String string, AZipEntryChange aZipEntryChange) {
        this(string);
    }

    private static class ZipEntryAdd
    extends AZipEntryChange {
        private static final long serialVersionUID = 1L;

        private ZipEntryAdd(String fileName) {
            super(fileName, null);
        }

        @Override
        public boolean isAdd() {
            return true;
        }
    }

    private static class ZipEntryDelete
    extends AZipEntryChange {
        private static final long serialVersionUID = 1L;

        private ZipEntryDelete(String fileName) {
            super(fileName, null);
        }

        @Override
        public boolean isDelete() {
            return true;
        }
    }

    private static class ZipEntryModify
    extends AZipEntryChange {
        private static final long serialVersionUID = 1L;

        private ZipEntryModify(String fileName) {
            super(fileName, null);
        }

        @Override
        public boolean isModify() {
            return true;
        }
    }
}

