/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.spec.ds.filemonitor;

import com.wily.rave.spec.IContentValue;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.UnsupportedEncodingException;

public class FileContentValue
implements IContentValue,
Externalizable {
    public static final String DEFAULT_ENCODING = "UTF8";
    private static final long serialVersionUID = 1L;
    private byte[] completeContent;

    public FileContentValue() {
    }

    public FileContentValue(byte[] content) {
        if (content == null) {
            throw new IllegalArgumentException("Content must not be null!");
        }
        this.completeContent = content;
    }

    public FileContentValue(String content) {
        this(FileContentValue.getBytes(content));
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeInt(this.completeContent.length);
        oo.write(this.completeContent);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException {
        int length = oi.readInt();
        this.completeContent = new byte[length];
        oi.readFully(this.completeContent);
    }

    private static final byte[] getBytes(String content) {
        try {
            return content.getBytes(DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("Unexpected encoding exception!" + ex.getMessage());
        }
    }

    public byte[] getItemContentData() {
        return this.completeContent;
    }

    public String toShortString() {
        String string = "";
        if (this.completeContent.length != 0) {
            try {
                string = new String(this.completeContent, DEFAULT_ENCODING);
            }
            catch (UnsupportedEncodingException ex) {
                throw new RuntimeException("This should never happen..." + ex.getMessage());
            }
        }
        return string.substring(0, Math.min(100, string.length()));
    }

    public String toString() {
        return this.toShortString().replace('\n', ' ');
    }

    @Override
    public String getStringValue() {
        try {
            return new String(this.completeContent, DEFAULT_ENCODING);
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("This should never happen..." + ex.getMessage());
        }
    }
}

