/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.brtm.trace;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.brtm.trace.common.MutableInteger;
import com.wily.introscope.agent.brtm.trace.common.PPSimpleTracer;
import com.wily.introscope.agent.brtm.utilities.EncryptionDecryptionUtils;
import com.wily.introscope.agent.brtm.utilities.InternalDataUtils;
import com.wily.introscope.agent.brtm.utilities.WrapperFactoryUtils;
import com.wily.introscope.agent.trace.BTThreadLocalAdministrator;
import com.wily.introscope.agent.trace.ITracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.feedback.DelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.hot.ConfigurationProperty;
import java.util.HashMap;
import java.util.Map;

public class BALevelOneHelperTracer
extends PPSimpleTracer
implements ITracer {
    private static final Module BA_MODULE = new Module("BrowserAgent");
    private static IAgent agent;
    private static IModuleFeedbackChannel feedback;
    private static boolean g_initialized;
    private static final String PROPERTYNAME_USERIDCOOKIE = "introscope.agent.decorator.userid.cookie.name";
    private static String userIDCookieName;
    private static Map agentInfoMap;
    private static ThreadLocal stackDepthLocal;

    static {
        g_initialized = false;
        userIDCookieName = "";
        agentInfoMap = new HashMap();
        stackDepthLocal = new ThreadLocal(){

            public Object initialValue() {
                return new MutableInteger();
            }
        };
    }

    public BALevelOneHelperTracer(IAgent a, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) throws AgentNotAvailableException {
        super(a, parameters, probe, sampleTracedObject);
        agent = a;
        feedback = new DelegatingFeedbackChannel(agent.IAgent_getModuleFeedback(), BA_MODULE);
        if (!g_initialized) {
            g_initialized = true;
            userIDCookieName = agent.IAgent_getIndexedProperties().getProperty(PROPERTYNAME_USERIDCOOKIE);
            agent.IAgent_getConfigurationManager().add(new UserIDCookieNameProperty(agent), true);
            this.getAgentInfoMap();
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        if (!BTThreadLocalAdministrator.getInstance().isResponseDecorationAPMDataEnabled().booleanValue()) {
            return;
        }
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.inc();
        if (stackDepth.getValue() > 1) {
            return;
        }
        if (data.getInvocationParameterCount() < 2) {
            return;
        }
        Object shouldAddResponseDecoration = BTThreadLocalAdministrator.getInstance().get("shouldAddResponseCookie");
        if (shouldAddResponseDecoration instanceof Boolean && ((Boolean)shouldAddResponseDecoration).booleanValue()) {
            Object params;
            Object request = data.getInvocationParameterAsObject(0);
            Map httpParams = data.getServletParameterMap();
            HashMap<String, String> paramsAll = new HashMap<String, String>();
            if (agentInfoMap != null) {
                paramsAll.putAll(agentInfoMap);
            }
            if (request != null && !"".equals(userIDCookieName)) {
                this.getUserIDCookie(request, data);
            } else {
                feedback.debug(BA_MODULE, "the request is null");
            }
            if (httpParams != null) {
                InternalDataUtils.addUserIDWebappName(httpParams, feedback, paramsAll);
            }
            if ((params = BTThreadLocalAdministrator.getInstance().get("agentInfo")) instanceof Map) {
                paramsAll.putAll((Map)params);
            }
            BTThreadLocalAdministrator.getInstance().insert("agentInfo", paramsAll);
        }
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (!BTThreadLocalAdministrator.getInstance().isResponseDecorationAPMDataEnabled().booleanValue()) {
            return;
        }
        MutableInteger stackDepth = (MutableInteger)stackDepthLocal.get();
        stackDepth.dec();
        if (stackDepth.getValue() > 0) {
            return;
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return (agent.IAgent_getComponentTracer().isAgentOldMode() ? Boolean.FALSE : BTThreadLocalAdministrator.getInstance().isResponseDecorationAPMDataEnabled()) == false;
    }

    private void getUserIDCookie(Object request, InvocationData data) {
        WrapperFactoryUtils wrapperFactoryUtil = (WrapperFactoryUtils)BTThreadLocalAdministrator.getInstance().get("wrapperFactoryUtil");
        Object factoryObject = wrapperFactoryUtil.getFactoryObject();
        Object[] argArray = new Object[2];
        Class[] argClassArray = new Class[2];
        argArray[0] = request;
        argClassArray[0] = Object.class;
        argArray[1] = userIDCookieName;
        argClassArray[1] = String.class;
        BALevelOneHelperTracer.invokeReturnsVoid(factoryObject, data, 4, argArray, argClassArray, wrapperFactoryUtil.getMethodCache());
    }

    private void getAgentInfoMap() {
        String[] hpa = agent.IAgent_getHostProcessAgentTriplet();
        if (hpa != null) {
            String configHost = EncryptionDecryptionUtils.encrypt(hpa[0], feedback);
            String configProcess = EncryptionDecryptionUtils.encrypt(hpa[1], feedback);
            String configAgent = EncryptionDecryptionUtils.encrypt(hpa[2], feedback);
            if (configHost != null) {
                agentInfoMap.put("apmAgentHost", configHost);
            } else if (feedback.isTraceEnabled()) {
                feedback.trace(BA_MODULE, "can not get host name");
            }
            if (configProcess != null) {
                agentInfoMap.put("apmAgentProcess", configProcess);
            } else if (feedback.isTraceEnabled()) {
                feedback.trace(BA_MODULE, "can not get process name");
            }
            if (configAgent != null) {
                agentInfoMap.put("apmAgentName", configAgent);
            } else if (feedback.isTraceEnabled()) {
                feedback.trace(BA_MODULE, "can not get agent name");
            }
        } else {
            String configAgent = EncryptionDecryptionUtils.encrypt(agent.IAgent_getName(), feedback);
            if (configAgent != null) {
                agentInfoMap.put("apmAgentName", configAgent);
            } else if (feedback.isTraceEnabled()) {
                feedback.trace(BA_MODULE, "can not get agent name");
            }
        }
    }

    static final class UserIDCookieNameProperty
    extends ConfigurationProperty {
        private UserIDCookieNameProperty(IAgent agent) {
            super(BALevelOneHelperTracer.PROPERTYNAME_USERIDCOOKIE, "", agent.IAgent_getModuleFeedback(), BA_MODULE, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            userIDCookieName = (String)newValue;
        }
    }
}

