/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feature;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveLongConfigurationProperty;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Map;

public class ThreadMXBeanTimingFeature {
    private static Module Module = new Module("CPUMethodTimeBreakdown");
    private static IAgent agent;
    private static IModuleFeedbackChannel feedback;
    private static boolean isThreadMXBeanLoaded;
    private static ThreadMXBean threadBean;
    private static DataAccumulatorFactory dataAccumulatorfactory;
    private static boolean allocatedMemoryAPIEnabled;
    private static boolean allocatedMemoryEnabledInitiated;
    private static final String ALLOCATEDMEMORY_ENABLE = "introscope.agent.allocatedmemory.enable";
    private static boolean allocatedMemoryEnabled;
    private static final String METHODTIMEBREAKDOWN_ENABLE = "introscope.agent.cpumethodtimebreakdown.enable";
    private static boolean isMethodTimeBreakdownEnabled;
    private static boolean isThreadCpuTimeSupported;
    private static final String METHODTIMEBREAKDOWN_CONTENTION_ENABLE = "introscope.agent.cpumethodtimebreakdown.contention.enable";
    private static boolean isMethodTimeBreakdownContentionEnabled;
    private static boolean isThreadContentionMonitoringSupported;
    private static final String METHODTIMEBREAKDOWN_METRIC_ENABLE = "introscope.agent.cpumethodtimebreakdown.metric.enable";
    private static boolean isCPUMetricEnabled;
    private static final String METHODTIMEBREAKDOWN_TTPERCENTAGE_ENABLE = "introscope.agent.cpumethodtimebreakdown.tt.percentage.decoration.enable";
    private static boolean isTTPercentageEnabled;
    private static final String METHODTIMEBREAKDOWN_TT_THRESHOLD = "introscope.agent.cpumethodtimebreakdown.tt.threshold";
    private static long traceThresholdInMs;
    private static Method allocatedBytesMethod;
    private static final String USER_CPUTIME_START = "userCPUTimeStart";
    private static final String WAITTIME_START = "waitedTimeStart";
    private static final String BLOCKTIME_START = "blockedTimeStart";
    private static final String START_MEOMERY = "startMemory";
    private static final String TOTAL = "Total Time";
    private static final String CPUTOTAL = "CPU Time";
    private static final String CPUUSER = "CPU User Time";
    private static final String CPUSYSTEM = "CPU System Time";
    private static final String OTHERWAIT = "Wait Time";
    private static final String OTHERBLOCK = "Block Time";
    private static final String OTHER = "Other Time";
    private static final String MSECOND = " (ms)";
    private static final String PERCENTAGE = " (%)";
    private static final String MEOMORY_TTNAME = "Allocated Memory (bytes)";
    private static final String MEMORY_METRICNAME = ":Average Bytes Allocated";
    private static final String SYSTEM_CPUTIME_METRICNAME = ":Average System CPU Time (ms)";
    private static final String USER_CPUTIME_METRICNAME = ":Average User CPU Time (ms)";
    private static final String WAIT_TIME_METRICNAME = ":Average Wait Time (ms)";
    private static final String BLOCK_TIME_METRICNAME = ":Average Block Time (ms)";

    static {
        allocatedMemoryAPIEnabled = false;
        allocatedMemoryEnabledInitiated = false;
        allocatedMemoryEnabled = false;
        isMethodTimeBreakdownEnabled = false;
        isThreadCpuTimeSupported = false;
        isMethodTimeBreakdownContentionEnabled = false;
        isThreadContentionMonitoringSupported = false;
        isCPUMetricEnabled = false;
        isTTPercentageEnabled = false;
        traceThresholdInMs = 0L;
    }

    public static void loadThreadMXBean(IAgent agent0) {
        if (!isThreadMXBeanLoaded) {
            agent = agent0;
            feedback = agent.IAgent_getModuleFeedback();
            dataAccumulatorfactory = agent.IAgent_getDataAccumulatorFactory();
            try {
                threadBean = ManagementFactory.getThreadMXBean();
                if (threadBean != null) {
                    if (threadBean.isThreadCpuTimeSupported()) {
                        isThreadCpuTimeSupported = true;
                        if (threadBean.isThreadContentionMonitoringSupported()) {
                            isThreadContentionMonitoringSupported = true;
                        } else {
                            feedback.info(Module, "ThreadContentionMonitoring is not supported");
                        }
                    } else {
                        feedback.info(Module, "ThreadCpuTime is not supported");
                    }
                } else {
                    feedback.info(Module, "Null ThreadMXBean returned from the ManagementFactory");
                }
            }
            catch (Throwable t) {
                isThreadMXBeanLoaded = true;
                feedback.error(Module, "Unable to load ManagementFactory", t);
            }
            ThreadMXBeanTimingFeature.initMethodTimeBreakdownProperties(agent);
            isThreadMXBeanLoaded = true;
        }
    }

    private static void initMethodTimeBreakdownProperties(IAgent agent) {
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        cm.add(new MethodTimeBreakdownEnableProperty(agent), true);
        cm.add(new MethodTimeBreakdownContentionMonitorEnableProperty(agent), true);
        cm.add(new MethodTimeBreakdownTTthresholdProperty(agent), true);
        cm.add(new MethodTimeBreakdownTTPercentageDecorationEnableProperty(agent), true);
        cm.add(new MethodTimeBreakdownMetricEnableProperty(agent), true);
    }

    public static boolean putStartDataPoint(InvocationData data, boolean shouldCollectCpuTiming) {
        if ((shouldCollectCpuTiming || data.IMethodTracer_shouldDecorateCPUTiming()) && threadBean != null && isMethodTimeBreakdownEnabled) {
            data.IMethodTracer_setShouldDecorateCPUTiming(true);
            if (data.getCPUStartTimeNanos() < 0L) {
                data.setCPUStartTimeNanos(threadBean.getCurrentThreadCpuTime());
            }
            data.put(USER_CPUTIME_START, threadBean.getCurrentThreadUserTime());
            if (isMethodTimeBreakdownContentionEnabled) {
                ThreadInfo currentThreadInfo = threadBean.getThreadInfo(Thread.currentThread().getId());
                data.put(WAITTIME_START, currentThreadInfo.getWaitedTime());
                data.put(BLOCKTIME_START, currentThreadInfo.getBlockedTime());
            }
            return true;
        }
        return false;
    }

    public static void putEndDataPoint(InvocationData data, String metricPath) {
        long totalTime;
        if (data.IMethodTracer_shouldDecorateCPUTiming() && threadBean != null && isMethodTimeBreakdownEnabled && (totalTime = data.getWallClockElapsedTime()) >= traceThresholdInMs) {
            long startTime = data.getCPUStartTimeNanos();
            long endTime = -1L;
            if (startTime >= 0L && (endTime = data.getCPUFinishTimeNanos()) < 0L) {
                endTime = threadBean.getCurrentThreadCpuTime();
                data.setCPUFinishTimeNanos(endTime);
            }
            if (startTime >= 0L && endTime >= 0L) {
                long cpuTotal = -1L;
                long cpuUser = -1L;
                long cpuSystem = -1L;
                long otherTime = -1L;
                cpuTotal = ThreadMXBeanTimingFeature.elapsedTime(startTime, endTime) / 1000000L;
                if (cpuTotal > totalTime) {
                    cpuTotal = totalTime;
                }
                otherTime = ThreadMXBeanTimingFeature.elapsedTime(cpuTotal, totalTime);
                Object cpustart = data.get(USER_CPUTIME_START);
                if (cpustart instanceof Long && (Long)cpustart >= 0L) {
                    long cpuend = threadBean.getCurrentThreadUserTime();
                    cpuUser = ThreadMXBeanTimingFeature.elapsedTime((Long)cpustart, cpuend) / 1000000L;
                    if (cpuTotal < cpuUser) {
                        cpuUser = cpuTotal;
                    }
                    cpuSystem = cpuTotal - cpuUser;
                }
                if (cpuTotal >= 0L) {
                    data.put(CPUTOTAL, cpuTotal);
                }
                if (cpuUser >= 0L) {
                    data.put(CPUUSER, cpuUser);
                    ThreadMXBeanTimingFeature.reportAverageLongTypeMetricData(String.valueOf(metricPath) + USER_CPUTIME_METRICNAME, cpuUser, isCPUMetricEnabled);
                }
                if (cpuSystem >= 0L) {
                    data.put(CPUSYSTEM, cpuSystem);
                    ThreadMXBeanTimingFeature.reportAverageLongTypeMetricData(String.valueOf(metricPath) + SYSTEM_CPUTIME_METRICNAME, cpuSystem, isCPUMetricEnabled);
                }
                long waitTime = -1L;
                long blockTime = -1L;
                if (isMethodTimeBreakdownContentionEnabled) {
                    Object waitedstart;
                    ThreadInfo currentThreadInfo = threadBean.getThreadInfo(Thread.currentThread().getId());
                    Object blockedstart = data.get(BLOCKTIME_START);
                    if (blockedstart instanceof Long && (Long)blockedstart >= 0L) {
                        long blockedend = currentThreadInfo.getBlockedTime();
                        blockTime = ThreadMXBeanTimingFeature.elapsedTime((Long)blockedstart, blockedend);
                    }
                    if ((waitedstart = data.get(WAITTIME_START)) instanceof Long && (Long)waitedstart >= 0L) {
                        long waitedend = currentThreadInfo.getWaitedTime();
                        waitTime = ThreadMXBeanTimingFeature.elapsedTime((Long)waitedstart, waitedend);
                    }
                    if (waitTime >= 0L && blockTime >= 0L) {
                        long diff = waitTime + blockTime - otherTime;
                        if (diff > 0L) {
                            if (waitTime >= blockTime) {
                                if (waitTime >= diff) {
                                    waitTime -= diff;
                                } else {
                                    blockTime -= diff - waitTime;
                                    waitTime = 0L;
                                }
                            } else if (blockTime >= diff) {
                                blockTime -= diff;
                            } else {
                                waitTime -= diff - blockTime;
                                blockTime = 0L;
                            }
                        }
                        otherTime = otherTime - waitTime - blockTime;
                    }
                    if (waitTime >= 0L) {
                        data.put(OTHERWAIT, waitTime);
                        ThreadMXBeanTimingFeature.reportAverageLongTypeMetricData(String.valueOf(metricPath) + WAIT_TIME_METRICNAME, waitTime, isCPUMetricEnabled);
                    }
                    if (blockTime >= 0L) {
                        data.put(OTHERBLOCK, blockTime);
                        ThreadMXBeanTimingFeature.reportAverageLongTypeMetricData(String.valueOf(metricPath) + BLOCK_TIME_METRICNAME, blockTime, isCPUMetricEnabled);
                    }
                }
                if (otherTime >= 0L) {
                    data.put(OTHER, otherTime);
                }
            }
        }
    }

    public static void addParameters(InvocationData data, Map parameters) {
        Object memoryBytes;
        long totalTime;
        if (isMethodTimeBreakdownEnabled && (totalTime = data.getWallClockElapsedTime()) >= traceThresholdInMs) {
            if (isMethodTimeBreakdownContentionEnabled) {
                ThreadMXBeanTimingFeature.decorateSingleTime(data, parameters, totalTime, OTHERWAIT);
                ThreadMXBeanTimingFeature.decorateSingleTime(data, parameters, totalTime, OTHERBLOCK);
            }
            ThreadMXBeanTimingFeature.decorateSingleTime(data, parameters, totalTime, CPUTOTAL);
            ThreadMXBeanTimingFeature.decorateSingleTime(data, parameters, totalTime, CPUUSER);
            ThreadMXBeanTimingFeature.decorateSingleTime(data, parameters, totalTime, CPUSYSTEM);
            ThreadMXBeanTimingFeature.decorateSingleTime(data, parameters, totalTime, OTHER);
        }
        if ((memoryBytes = data.get(MEOMORY_TTNAME)) != null) {
            parameters.put(MEOMORY_TTNAME, memoryBytes.toString());
        }
    }

    private static void decorateSingleTime(InvocationData data, Map parameters, long totalTime, String name) {
        long time;
        Object timeObject = data.get(name);
        if (timeObject instanceof Long && (time = ((Long)timeObject).longValue()) >= 0L) {
            parameters.put(String.valueOf(name) + MSECOND, String.valueOf(time));
            if (isTTPercentageEnabled) {
                parameters.put(String.valueOf(name) + PERCENTAGE, String.valueOf(time * 100L / totalTime));
            }
        }
    }

    private static long elapsedTime(long start, long finish) {
        return finish > start ? finish - start : 0L;
    }

    public static boolean initAllocatedMemoryEnabled() {
        if (!allocatedMemoryEnabledInitiated) {
            try {
                if (threadBean == null) {
                    threadBean = ManagementFactory.getThreadMXBean();
                }
                Class<?> threadMXBeanClass = ManagementFactory.getThreadMXBean().getClass();
                Method enabledMethod = threadMXBeanClass.getMethod("isThreadAllocatedMemoryEnabled", null);
                allocatedBytesMethod = threadMXBeanClass.getMethod("getThreadAllocatedBytes", Long.TYPE);
                enabledMethod.setAccessible(true);
                allocatedBytesMethod.setAccessible(true);
                boolean apiEnabled = (Boolean)enabledMethod.invoke((Object)ManagementFactory.getThreadMXBean(), new Object[0]);
                if (apiEnabled) {
                    allocatedMemoryAPIEnabled = true;
                }
                allocatedMemoryEnabledInitiated = true;
                ConfigurationManager cm = agent.IAgent_getConfigurationManager();
                cm.add(new AllocatedMemoryEnableProperty(agent), true);
            }
            catch (Throwable throwable) {
                allocatedMemoryEnabledInitiated = true;
                allocatedMemoryAPIEnabled = false;
                feedback.info(Module, "Allocated Memory is not supported.");
            }
        }
        return allocatedMemoryAPIEnabled;
    }

    public static boolean putStartMemoryDataPoint(InvocationData data, boolean shouldCollectAllocatedBytes) {
        if (!allocatedMemoryEnabledInitiated) {
            ThreadMXBeanTimingFeature.initAllocatedMemoryEnabled();
        }
        if (allocatedMemoryEnabled && (shouldCollectAllocatedBytes || data.IMethodTracer_shouldReportAllocatedBytesMetric())) {
            data.IMethodTracer_setShouldReportAllocatedBytesMetric(true);
            try {
                long startBytes = (Long)allocatedBytesMethod.invoke((Object)threadBean, Thread.currentThread().getId());
                data.put(START_MEOMERY, startBytes);
                return true;
            }
            catch (Throwable t) {
                feedback.error(t.getMessage(), t);
                return false;
            }
        }
        return false;
    }

    public static void reportMemoryData(InvocationData data, String metricPath) {
        if (allocatedMemoryEnabled && data.IMethodTracer_shouldReportAllocatedBytesMetric() && metricPath != null) {
            try {
                Object startMemory = data.get(START_MEOMERY);
                if (startMemory != null) {
                    long endBytes = (Long)allocatedBytesMethod.invoke((Object)threadBean, Thread.currentThread().getId());
                    long allocatedBytes = endBytes - (Long)startMemory;
                    data.put(MEOMORY_TTNAME, allocatedBytes);
                    ThreadMXBeanTimingFeature.reportAverageLongTypeMetricData(String.valueOf(metricPath) + MEMORY_METRICNAME, allocatedBytes, true);
                }
            }
            catch (Throwable t) {
                feedback.error(t.getMessage(), t);
            }
        }
    }

    private static void reportAverageLongTypeMetricData(String metricName, long value, boolean shouldReport) {
        if (shouldReport) {
            ILongAverageDataAccumulator counter = dataAccumulatorfactory.safeGetLongAverageDataAccumulator(metricName);
            counter.ILongAggregatingDataAccumulator_recordDataPoint(value);
        }
    }

    private static class AllocatedMemoryEnableProperty
    extends BooleanConfigurationProperty {
        private AllocatedMemoryEnableProperty(IAgent agent) {
            super(ThreadMXBeanTimingFeature.ALLOCATEDMEMORY_ENABLE, Boolean.TRUE, "Enables/Disables Allocated Memory", true, false, agent.IAgent_getModuleFeedback(), Module, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            allocatedMemoryEnabled = (Boolean)newValue;
            if (allocatedMemoryEnabled && allocatedMemoryAPIEnabled) {
                feedback.info(Module, "Turn on Allocated Memory Monitor.");
            } else {
                allocatedMemoryEnabled = false;
                feedback.info(Module, "Turn off Allocated Memory Monitor.");
            }
        }
    }

    private static class MethodTimeBreakdownContentionMonitorEnableProperty
    extends BooleanConfigurationProperty {
        private MethodTimeBreakdownContentionMonitorEnableProperty(IAgent agent) {
            super(ThreadMXBeanTimingFeature.METHODTIMEBREAKDOWN_CONTENTION_ENABLE, Boolean.TRUE, "Enables/Disables CPU Method Time Breakdown Contention Monitor", true, false, agent.IAgent_getModuleFeedback(), Module, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            isMethodTimeBreakdownContentionEnabled = (Boolean)newValue;
            if (isMethodTimeBreakdownContentionEnabled && isThreadContentionMonitoringSupported) {
                feedback.info(Module, "Turn on CPU Method Time Breakdown Contention Monitor");
                if (!threadBean.isThreadContentionMonitoringEnabled()) {
                    threadBean.setThreadContentionMonitoringEnabled(true);
                }
            } else {
                isMethodTimeBreakdownContentionEnabled = false;
                feedback.info(Module, "Turn off CPU Method Time Breakdown Contention Monitor");
            }
        }
    }

    private static class MethodTimeBreakdownEnableProperty
    extends BooleanConfigurationProperty {
        private MethodTimeBreakdownEnableProperty(IAgent agent) {
            super(ThreadMXBeanTimingFeature.METHODTIMEBREAKDOWN_ENABLE, Boolean.TRUE, "Enables/Disables Method Time Breakdown", true, false, agent.IAgent_getModuleFeedback(), Module, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            isMethodTimeBreakdownEnabled = (Boolean)newValue;
            if (isMethodTimeBreakdownEnabled && isThreadCpuTimeSupported) {
                feedback.info(Module, "Turn on Method Time Breakdown");
                if (!threadBean.isThreadCpuTimeEnabled()) {
                    threadBean.setThreadCpuTimeEnabled(true);
                }
            } else {
                isMethodTimeBreakdownEnabled = false;
                feedback.info(Module, "Turn off Method Time Breakdown");
            }
        }
    }

    private static class MethodTimeBreakdownMetricEnableProperty
    extends BooleanConfigurationProperty {
        private MethodTimeBreakdownMetricEnableProperty(IAgent agent) {
            super(ThreadMXBeanTimingFeature.METHODTIMEBREAKDOWN_METRIC_ENABLE, Boolean.TRUE, "Enables/Disables CPU Method Time Breakdown Metric", true, false, agent.IAgent_getModuleFeedback(), Module, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            isCPUMetricEnabled = (Boolean)newValue;
        }
    }

    private static class MethodTimeBreakdownTTPercentageDecorationEnableProperty
    extends BooleanConfigurationProperty {
        private MethodTimeBreakdownTTPercentageDecorationEnableProperty(IAgent agent) {
            super(ThreadMXBeanTimingFeature.METHODTIMEBREAKDOWN_TTPERCENTAGE_ENABLE, Boolean.FALSE, "Enables/Disables CPU Method Time Breakdown TT Percentage Decoration", true, false, agent.IAgent_getModuleFeedback(), Module, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            isTTPercentageEnabled = (Boolean)newValue;
        }
    }

    private static class MethodTimeBreakdownTTthresholdProperty
    extends PositiveLongConfigurationProperty {
        private MethodTimeBreakdownTTthresholdProperty(IAgent agent) {
            super(ThreadMXBeanTimingFeature.METHODTIMEBREAKDOWN_TT_THRESHOLD, traceThresholdInMs, agent.IAgent_getModuleFeedback(), Module, agent.IAgent_getStringLocalizer());
        }

        @Override
        public void set(Object newValue) {
            traceThresholdInMs = ((Long)newValue).intValue();
        }
    }
}

