/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.cas;

import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.cas.AbstractTransactionElement;
import com.wily.introscope.agent.trace.cas.IChildEditor;
import com.wily.introscope.agent.trace.cas.IChildRead;
import com.wily.introscope.agent.trace.cas.IEditableTransactionElement;
import com.wily.introscope.agent.trace.cas.IErrorSubscriber;
import com.wily.introscope.agent.trace.cas.IFaultSubscriber;
import com.wily.introscope.agent.trace.cas.IStallSubscriber;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.ITransactionElementProvider;
import com.wily.introscope.agent.trace.cas.SetElement;
import java.util.Iterator;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;

public abstract class APureSetTransactionElement
extends AbstractTransactionElement
implements ITransactionElement,
IEditableTransactionElement {
    private final CopyOnWriteArrayList fSet = new CopyOnWriteArrayList();

    public APureSetTransactionElement(ITransactionElement parent, boolean isStartTrace) {
        super(parent, isStartTrace);
    }

    @Override
    public Iterator iterateChildren() {
        return new PureSetIterator(this.fSet, this.fEndTransactionChild);
    }

    @Override
    public int countChildren() {
        int sizeOfEnd = this.fEndTransactionChild.get() == null ? 0 : 1;
        return this.fSet.size() + sizeOfEnd;
    }

    @Override
    public boolean isLastInTransaction() {
        return false;
    }

    @Override
    public ITransactionElement goToChild(Object key, ITransactionElementProvider provider) {
        return this.goToChildStartTransaction(key, 0, null, provider);
    }

    @Override
    public ITransactionElement goToChildStartTransaction(Object key, int tracerIndex, IStackElement data, ITransactionElementProvider provider) {
        int currentSize = this.fSet.size();
        int i = 0;
        while (i < currentSize) {
            try {
                SetElement se = (SetElement)this.fSet.get(i);
                if (se.equalsObject(key)) {
                    this.needToSendDiscoveryTraceAgain(data, se.element);
                    return se.element;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            ++i;
        }
        APureSetTransactionElement.checkCount(provider, key, tracerIndex, data, this);
        ITransactionElement result = provider.getElementOnStartTrace(key, tracerIndex, data, this);
        SetElement newElement = new SetElement(key, result);
        if (this.fSet.addIfAbsent(newElement)) {
            result.notifyPublished();
            this.markTransactionElementForDiscoveryTrace(data, result);
            return result;
        }
        return this.goToChildStartTransaction(key, tracerIndex, data, provider);
    }

    @Override
    public void terminateTransaction(String endKey) {
    }

    @Override
    public boolean hasChildren() {
        return this.fSet.size() > 0 || this.fEndTransactionChild.get() != null;
    }

    @Override
    public ITransactionElement goToChild(Object keyToNextStep, IStackElement currentData, ITransactionElementProvider elementProvider) {
        return this.goToChildStartTransaction(keyToNextStep, 0, currentData, elementProvider);
    }

    @Override
    public IErrorSubscriber getErrorSubscriber() {
        return null;
    }

    @Override
    public IStallSubscriber getStallSubscriber() {
        return null;
    }

    @Override
    public IFaultSubscriber getFaultSubscriber() {
        return null;
    }

    @Override
    public ITransactionElement getNextOnEndTransaction() {
        return this;
    }

    @Override
    public void offerChildrenForEdit(IChildEditor editor) {
        for (SetElement se : this.fSet) {
            ITransactionElement e = se.element;
            if (!editor.removeElement(e, se.key)) continue;
            this.fSet.remove(se);
            editor.onPostRemove(se);
        }
    }

    @Override
    public void offerChildrenForRead(IChildRead reader) {
        int currentSize = this.fSet.size();
        int i = 0;
        while (i < currentSize) {
            try {
                SetElement se = (SetElement)this.fSet.get(i);
                ITransactionElement e = se.element;
                reader.readElement(e);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
            ++i;
        }
        ITransactionElement e = (ITransactionElement)this.fEndTransactionChild.get();
        if (e != null) {
            reader.readElement(e);
        }
    }

    @Override
    public void clearAllChildren() {
        this.fSet.clear();
        this.fEndTransactionChild.set(null);
    }

    public static class PureSetIterator
    implements Iterator {
        boolean hasStartedUsingSnapshotIterator = false;
        final AtomicReference fEnd;
        final Iterator snapshotIterator;

        PureSetIterator(CopyOnWriteArrayList set, AtomicReference end) {
            this.fEnd = end;
            this.snapshotIterator = set.iterator();
        }

        @Override
        public boolean hasNext() {
            if (this.hasStartedUsingSnapshotIterator) {
                return this.snapshotIterator.hasNext();
            }
            return this.fEnd.get() != null || this.snapshotIterator.hasNext();
        }

        public Object next() {
            if (this.hasStartedUsingSnapshotIterator) {
                return this.snapshotIterator.next();
            }
            Object o = this.fEnd.get();
            if (o == null) {
                this.hasStartedUsingSnapshotIterator = true;
                return this.next();
            }
            this.hasStartedUsingSnapshotIterator = true;
            return o;
        }

        @Override
        public void remove() {
        }
    }
}

