/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.jdbc;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.jdbc.IDBNameFormatter;
import com.wily.introscope.agent.trace.jdbc.SQLNameFormatterUtilities;
import com.wily.util.text.IStringLocalizer;
import java.sql.SQLException;
import java.sql.Statement;

public class SQLBackendNameFormatter
implements INameFormatter {
    private IAgent fAgent;
    private IDBNameFormatter fDefaultFormatter;
    private static final char kColonReplaceChar = '%';

    public SQLBackendNameFormatter(IAgent agent) {
        this.fAgent = agent;
        this.fDefaultFormatter = new IDBNameFormatter(){

            @Override
            public String format(String inString, IStringLocalizer localizer) {
                return inString.replace(':', '%');
            }
        };
    }

    @Override
    public String INameFormatter_format(String name, InvocationData data) {
        String result = name;
        String formattedName = null;
        Statement stmt = null;
        Object invocationObj = data.getInvocationObject();
        if (invocationObj instanceof Statement) {
            stmt = (Statement)invocationObj;
            SQLNameFormatterUtilities utilities = SQLNameFormatterUtilities.getInstance();
            try {
                formattedName = utilities.getFormattedString(stmt, this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer());
            }
            catch (SQLException sqle) {
                this.fAgent.IAgent_getModuleFeedback().error("An error occurred formatting SQL backend name");
                this.fAgent.IAgent_getModuleFeedback().verbose("An error occurred formatting SQL backend name", sqle);
            }
        }
        result = formattedName != null ? formattedName : this.fDefaultFormatter.format(name, this.fAgent.IAgent_getStringLocalizer());
        result = "Backends|" + result;
        return result;
    }
}

