/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.util.ReflectionLookupException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;

public class ReflectionLookupStore {
    private static final String[] EMPTY_STRING = new String[0];
    private static Map<String, Method> methodReflectionCache = null;
    private static Map<String, Class> classReflectionCache = null;
    private static Map<String, Field> fieldReflectionCache = null;

    private static Map<String, Method> getMethodReflectionCache() {
        if (methodReflectionCache == null) {
            try {
                methodReflectionCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("GenericMethodCache");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                return null;
            }
        }
        return methodReflectionCache;
    }

    private static Map<String, Class> getClassReflectionCache() {
        if (classReflectionCache == null) {
            try {
                classReflectionCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("GenericClassCache");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                return null;
            }
        }
        return classReflectionCache;
    }

    private static Map<String, Field> getFieldReflectionCache() {
        if (fieldReflectionCache == null) {
            try {
                fieldReflectionCache = AgentShim.getAgent().IAgent_getConcurrentMapFactory().getConcurrentCappedMap("GenericFieldCache");
            }
            catch (AgentNotAvailableException agentNotAvailableException) {
                return null;
            }
        }
        return fieldReflectionCache;
    }

    public static Method lookupMethod(Object instance, String name, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException {
        return ReflectionLookupStore.lookupMethod(instance, name, EMPTY_STRING, publicModifier, feedback);
    }

    public static Method lookupMethod(Object instance, String name, String[] strings, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException {
        return ReflectionLookupStore.lookupMethodOnClass(instance.getClass(), name, strings, publicModifier, feedback);
    }

    /*
     * Unable to fully structure code
     */
    public static Method lookupMethodOnClass(Class className, String methodName, String[] strings, boolean publicModifier, IModuleFeedbackChannel feedback) throws ReflectionLookupException {
        block11: {
            arguments = null;
            try {
                key = String.valueOf(className.getName()) + "#" + methodName;
                method = ReflectionLookupStore.getMethodReflectionCache().get(key);
                if (method == null) {
                    arguments = ReflectionLookupStore.resolveParameterStrings(strings, className.getClassLoader());
                    if (publicModifier) {
                        method = className.getMethod(methodName, arguments);
                        argumentsBuffer = new StringBuilder();
                        if (arguments != null) {
                            var12_13 = arguments;
                            var11_16 = arguments.length;
                            var10_20 = 0;
                            while (var10_20 < var11_16) {
                                class1 = var12_13[var10_20];
                                argumentsBuffer.append(class1.getName());
                                argumentsBuffer.append(";");
                                ++var10_20;
                            }
                        }
                    } else {
                        method = className.getDeclaredMethod(methodName, arguments);
                        argumentsBuffer = new StringBuilder();
                        if (arguments != null) {
                            var12_14 = arguments;
                            var11_17 = arguments.length;
                            var10_21 = 0;
                            while (var10_21 < var11_17) {
                                class1 = var12_14[var10_21];
                                argumentsBuffer.append(class1.getName());
                                argumentsBuffer.append(";");
                                ++var10_21;
                            }
                        }
                    }
                    method.setAccessible(true);
                    ReflectionLookupStore.getMethodReflectionCache().put(key, method);
                }
                return method;
            }
            catch (Exception e) {
                argumentsBuffer = new StringBuilder();
                if (arguments == null) break block11;
                var11_18 = arguments;
                var10_22 = arguments.length;
                class1 = 0;
                ** while (class1 < var10_22)
            }
lbl-1000:
            // 1 sources

            {
                class1 = var11_18[class1];
                argumentsBuffer.append(class1.getName());
                argumentsBuffer.append(";");
                ++class1;
                continue;
            }
        }
        methodsBuffer = new StringBuilder();
        var13_28 = methods = className.getMethods();
        var12_15 = methods.length;
        var11_19 = 0;
        while (var11_19 < var12_15) {
            method = var13_28[var11_19];
            methodsBuffer.append(method.toString());
            methodsBuffer.append(";");
            ++var11_19;
        }
        feedback.debug("Available methods on class " + className.getName() + ": " + methodsBuffer.toString());
        throw new ReflectionLookupException("Error looking up method " + methodName + " on " + className + " with parameters " + argumentsBuffer.toString(), e);
    }

    /*
     * Unable to fully structure code
     */
    public static Method lookupMethodOnClass(Class className, String methodName, Class[] arguments, boolean publicModifier, IModuleFeedbackChannel feedback, boolean useCaching) throws ReflectionLookupException {
        block5: {
            try {
                key = String.valueOf(className.getName()) + "#" + methodName;
                method = ReflectionLookupStore.getMethodReflectionCache().get(key);
                if (method == null) {
                    method = publicModifier != false ? className.getMethod(methodName, arguments) : className.getDeclaredMethod(methodName, arguments);
                    method.setAccessible(true);
                    ReflectionLookupStore.getMethodReflectionCache().put(key, method);
                }
                return method;
            }
            catch (Exception e) {
                argumentsBuffer = new StringBuffer();
                if (arguments == null) break block5;
                var11_10 = arguments;
                var10_12 = arguments.length;
                var9_14 = 0;
                ** while (var9_14 < var10_12)
            }
lbl-1000:
            // 1 sources

            {
                class1 = var11_10[var9_14];
                argumentsBuffer.append(class1.getName());
                argumentsBuffer.append(";");
                ++var9_14;
                continue;
            }
        }
        methodsBuffer = new StringBuffer();
        var13_17 = methods = className.getMethods();
        var12_18 = methods.length;
        var11_11 = 0;
        while (var11_11 < var12_18) {
            method = var13_17[var11_11];
            methodsBuffer.append(method.toString());
            methodsBuffer.append(";");
            ++var11_11;
        }
        feedback.error("Available methods on class " + className.getName() + ": " + methodsBuffer.toString());
        throw new ReflectionLookupException("Error looking up method " + methodName + " on " + className + " with parameters " + argumentsBuffer.toString(), e);
    }

    public static Method lookupMethod(Object instance, String methodName, Class[] parameterTypes, boolean publicModifier, IModuleFeedbackChannel feedback, boolean useCaching) throws ReflectionLookupException {
        return ReflectionLookupStore.lookupMethodOnClass(instance.getClass(), methodName, parameterTypes, publicModifier, feedback, useCaching);
    }

    public static Class[] resolveParameterStrings(String[] strings, ClassLoader classloader) throws ReflectionLookupException {
        Class[] classNames = new Class[strings.length];
        int i = 0;
        while (i < strings.length) {
            String className = strings[i];
            classNames[i] = ReflectionLookupStore.lookupClass(className, classloader);
            ++i;
        }
        return classNames;
    }

    public static Class lookupClass(String className, ClassLoader classloader) throws ReflectionLookupException {
        try {
            Class<?> lookupClass = ReflectionLookupStore.getClassReflectionCache().get(className);
            if (lookupClass == null) {
                lookupClass = Class.forName(className, false, classloader);
                ReflectionLookupStore.getClassReflectionCache().put(className, lookupClass);
            }
            return lookupClass;
        }
        catch (Exception e) {
            throw new ReflectionLookupException("Error looking up class " + className, e);
        }
    }

    public static Class<?> lookupClass(String className, ClassLoader classLoader, boolean initialize) throws ReflectionLookupException {
        try {
            Class<?> lookupClass = ReflectionLookupStore.getClassReflectionCache().get(className);
            if (lookupClass == null) {
                lookupClass = Class.forName(className, initialize, classLoader);
                ReflectionLookupStore.getClassReflectionCache().put(className, lookupClass);
            }
            return lookupClass;
        }
        catch (Exception e) {
            throw new ReflectionLookupException("Error looking up class " + className, e);
        }
    }

    public static Field lookupField(ClassLoader classLoader, String className, String fieldName, boolean publicModifier) throws ReflectionLookupException {
        try {
            Class searchClass = ReflectionLookupStore.lookupClass(className, classLoader);
            Field searchField = ReflectionLookupStore.lookupField(searchClass, fieldName, publicModifier);
            return searchField;
        }
        catch (Exception e) {
            throw new ReflectionLookupException("Error looking up field " + fieldName + " on class " + className, e);
        }
    }

    static Field lookupField(Class classInstance, String fieldName, boolean publicModifier) throws ReflectionLookupException, NoSuchFieldException, SecurityException {
        String key = String.valueOf(classInstance.getName()) + "+" + fieldName;
        Field lookupField = ReflectionLookupStore.getFieldReflectionCache().get(key);
        if (lookupField == null) {
            lookupField = publicModifier ? classInstance.getField(fieldName) : classInstance.getDeclaredField(fieldName);
            lookupField.setAccessible(true);
            ReflectionLookupStore.getFieldReflectionCache().put(key, lookupField);
        }
        return lookupField;
    }
}

