/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.commons.io.filefilter;

import com.wily.org.apache.commons.io.filefilter.AbstractFileFilter;
import java.io.File;
import java.util.List;

public class SuffixFileFilter
extends AbstractFileFilter {
    private String[] suffixes;

    public SuffixFileFilter(String suffix) {
        if (suffix == null) {
            throw new IllegalArgumentException("The suffix must not be null");
        }
        this.suffixes = new String[]{suffix};
    }

    public SuffixFileFilter(String[] suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException("The array of suffixes must not be null");
        }
        this.suffixes = suffixes;
    }

    public SuffixFileFilter(List suffixes) {
        if (suffixes == null) {
            throw new IllegalArgumentException("The list of suffixes must not be null");
        }
        this.suffixes = suffixes.toArray(new String[suffixes.size()]);
    }

    public boolean accept(File file) {
        String name = file.getName();
        int i = 0;
        while (i < this.suffixes.length) {
            if (name.endsWith(this.suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean accept(File file, String name) {
        int i = 0;
        while (i < this.suffixes.length) {
            if (name.endsWith(this.suffixes[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

