/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.tracer;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.introscope.agent.trace.hc2.BackendTracer;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.util.Map;

public class JMSReceiveBackendTracer
extends BackendTracer
implements IInvocationDataParameterCallback,
BackendProtocolsConstants {
    private static final Module ModuleName = new Module("JMSReceiveBackendTracer");
    private final String START_TRACE_QUALIFIED_BACKEND_RECEIVE = "backend.jms.JMSReceiveBackendTracer";

    public JMSReceiveBackendTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        boolean foundInMap;
        boolean bl = foundInMap = JMSHelper.getDestinationInfoFromSession(data.getInvocationObject()) != null;
        if (foundInMap && !JMSHelper.isStackEmpty(data)) {
            data.put("backend.jms.JMSReceiveBackendTracer", (Object)Boolean.TRUE);
            data.setParameterCallback((IInvocationDataParameterCallback)this);
            super.ITracer_startTrace(tracerIndex, data);
        } else if (foundInMap) {
            JMSHelper.debug(ModuleName, "failed to run JMSReceiveBackendTracer.ITracer_startTrace because the Stack was found to be Empty");
        } else {
            JMSHelper.debug(ModuleName, "failed to run JMSReceiveBackendTracer.ITracer_startTrace  because the destination  was NULL for the Consumer object.Possibly JMSSessionTracer didn't run.");
        }
    }

    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Boolean wasStartTraceQualified = (Boolean)data.get("backend.jms.JMSReceiveBackendTracer");
        if (wasStartTraceQualified != null && wasStartTraceQualified.booleanValue()) {
            super.ITracer_finishTrace(tracerIndex, data);
        } else {
            JMSHelper.debug(ModuleName, "failed to call ITracer_finishTrace because the value of the attribute START_TRACE_QUALIFIED_BACKEND_RECEIVE was found as false ");
        }
    }

    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        if (JMSHelper.isCachedDestTypeAQueue(data)) {
            parameters.put("Queue Name", JMSHelper.getCachedDestinationName(data));
        } else if (JMSHelper.isCachedDestTypeATopic(data)) {
            parameters.put("Topic Name", JMSHelper.getCachedDestinationName(data));
        }
    }
}

