/*
 * Decompiled with CFR 0.152.
 */
package com.wily.rave.agent.config;

import com.wily.rave.agent.ds.file.FilePatternFilter;
import java.io.File;
import java.io.FileFilter;

public final class DirectoryScanSpec {
    private final File fRootDirectory;
    private final boolean fRecursive;
    private final FilePatternFilter fPatternFilter;
    private final File[] fExcludeSubDirectories;

    public DirectoryScanSpec(File rootDirectory, boolean recursive, FilePatternFilter fileSet, File[] excludeSubDirectories) {
        this.fRootDirectory = rootDirectory;
        this.fRecursive = recursive;
        this.fPatternFilter = fileSet;
        this.fExcludeSubDirectories = excludeSubDirectories == null ? new File[]{} : excludeSubDirectories;
    }

    public FileFilter getFilePatternFilter() {
        return this.fPatternFilter;
    }

    public boolean isRecursive() {
        return this.fRecursive;
    }

    public File getRootDirectory() {
        return this.fRootDirectory;
    }

    public boolean shouldProcessSubDirectory(File subDirectory) {
        if (subDirectory.equals(this.getRootDirectory())) {
            return true;
        }
        if (!this.fRecursive) {
            return false;
        }
        int i = 0;
        while (i < this.fExcludeSubDirectories.length) {
            if (subDirectory.compareTo(this.fExcludeSubDirectories[i]) == 0) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String toString() {
        return "DirectoryScanSpec[" + this.fRootDirectory + "]";
    }
}

